/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.hoglin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.BehaviorAttack;
import net.minecraft.world.entity.ai.behavior.BehaviorAttackTargetForget;
import net.minecraft.world.entity.ai.behavior.BehaviorAttackTargetSet;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorFollowAdult;
import net.minecraft.world.entity.ai.behavior.BehaviorGateSingle;
import net.minecraft.world.entity.ai.behavior.BehaviorLook;
import net.minecraft.world.entity.ai.behavior.BehaviorLookWalk;
import net.minecraft.world.entity.ai.behavior.BehaviorMakeLoveAnimal;
import net.minecraft.world.entity.ai.behavior.BehaviorNop;
import net.minecraft.world.entity.ai.behavior.BehaviorPacify;
import net.minecraft.world.entity.ai.behavior.BehaviorRemoveMemory;
import net.minecraft.world.entity.ai.behavior.BehaviorStrollRandomUnconstrained;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.behavior.BehaviorWalkAway;
import net.minecraft.world.entity.ai.behavior.BehaviorWalkAwayOutOfRange;
import net.minecraft.world.entity.ai.behavior.BehavorMove;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.monster.hoglin.EntityHoglin;
import net.minecraft.world.entity.schedule.Activity;

public class HoglinAI {
    public static final int REPELLENT_DETECTION_RANGE_HORIZONTAL = 8;
    public static final int REPELLENT_DETECTION_RANGE_VERTICAL = 4;
    private static final UniformInt RETREAT_DURATION = TimeRange.rangeOfSeconds(5, 20);
    private static final int ATTACK_DURATION = 200;
    private static final int DESIRED_DISTANCE_FROM_PIGLIN_WHEN_IDLING = 8;
    private static final int DESIRED_DISTANCE_FROM_PIGLIN_WHEN_RETREATING = 15;
    private static final int ATTACK_INTERVAL = 40;
    private static final int BABY_ATTACK_INTERVAL = 15;
    private static final int REPELLENT_PACIFY_TIME = 200;
    private static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.of(5, 16);
    private static final float SPEED_MULTIPLIER_WHEN_AVOIDING_REPELLENT = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_RETREATING = 1.3f;
    private static final float SPEED_MULTIPLIER_WHEN_MAKING_LOVE = 0.6f;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 0.4f;
    private static final float SPEED_MULTIPLIER_WHEN_FOLLOWING_ADULT = 0.6f;

    protected static BehaviorController<?> makeBrain(BehaviorController<EntityHoglin> var0) {
        HoglinAI.initCoreActivity(var0);
        HoglinAI.initIdleActivity(var0);
        HoglinAI.initFightActivity(var0);
        HoglinAI.initRetreatActivity(var0);
        var0.setCoreActivities((Set<Activity>)ImmutableSet.of((Object)Activity.CORE));
        var0.setDefaultActivity(Activity.IDLE);
        var0.useDefaultActivity();
        return var0;
    }

    private static void initCoreActivity(BehaviorController<EntityHoglin> var0) {
        var0.addActivity(Activity.CORE, 0, (ImmutableList<BehaviorControl<EntityHoglin>>)ImmutableList.of((Object)new BehaviorLook(45, 90), (Object)new BehavorMove()));
    }

    private static void initIdleActivity(BehaviorController<EntityHoglin> var0) {
        var0.addActivity(Activity.IDLE, 10, (ImmutableList<BehaviorControl<EntityHoglin>>)ImmutableList.of(BehaviorPacify.create(MemoryModuleType.NEAREST_REPELLENT, 200), (Object)new BehaviorMakeLoveAnimal(EntityTypes.HOGLIN, 0.6f, 2), BehaviorWalkAway.pos(MemoryModuleType.NEAREST_REPELLENT, 1.0f, 8, true), BehaviorAttackTargetSet.create(HoglinAI::findNearestValidAttackTarget), BehaviorBuilder.triggerIf(EntityHoglin::isAdult, BehaviorWalkAway.entity(MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLIN, 0.4f, 8, false)), SetEntityLookTargetSometimes.create(8.0f, UniformInt.of(30, 60)), BehaviorFollowAdult.create(ADULT_FOLLOW_RANGE, 0.6f), HoglinAI.createIdleMovementBehaviors()));
    }

    private static void initFightActivity(BehaviorController<EntityHoglin> var0) {
        var0.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, (ImmutableList<BehaviorControl<EntityHoglin>>)ImmutableList.of(BehaviorPacify.create(MemoryModuleType.NEAREST_REPELLENT, 200), (Object)new BehaviorMakeLoveAnimal(EntityTypes.HOGLIN, 0.6f, 2), BehaviorWalkAwayOutOfRange.create(1.0f), BehaviorBuilder.triggerIf(EntityHoglin::isAdult, BehaviorAttack.create(40)), BehaviorBuilder.triggerIf(EntityAgeable::isBaby, BehaviorAttack.create(15)), BehaviorAttackTargetForget.create(), BehaviorRemoveMemory.create(HoglinAI::isBreeding, MemoryModuleType.ATTACK_TARGET)), MemoryModuleType.ATTACK_TARGET);
    }

    private static void initRetreatActivity(BehaviorController<EntityHoglin> var0) {
        var0.addActivityAndRemoveMemoryWhenStopped(Activity.AVOID, 10, (ImmutableList<BehaviorControl<EntityHoglin>>)ImmutableList.of(BehaviorWalkAway.entity(MemoryModuleType.AVOID_TARGET, 1.3f, 15, false), HoglinAI.createIdleMovementBehaviors(), SetEntityLookTargetSometimes.create(8.0f, UniformInt.of(30, 60)), BehaviorRemoveMemory.create(HoglinAI::wantsToStopFleeing, MemoryModuleType.AVOID_TARGET)), MemoryModuleType.AVOID_TARGET);
    }

    private static BehaviorGateSingle<EntityHoglin> createIdleMovementBehaviors() {
        return new BehaviorGateSingle<EntityHoglin>((List<Pair<BehaviorControl<EntityHoglin>, Integer>>)ImmutableList.of((Object)Pair.of(BehaviorStrollRandomUnconstrained.stroll(0.4f), (Object)2), (Object)Pair.of(BehaviorLookWalk.create(0.4f, 3), (Object)2), (Object)Pair.of((Object)new BehaviorNop(30, 60), (Object)1)));
    }

    protected static void updateActivity(EntityHoglin var0) {
        BehaviorController<EntityHoglin> var1 = var0.getBrain();
        Activity var2 = var1.getActiveNonCoreActivity().orElse(null);
        var1.setActiveActivityToFirstValid((List<Activity>)ImmutableList.of((Object)Activity.FIGHT, (Object)Activity.AVOID, (Object)Activity.IDLE));
        Activity var3 = var1.getActiveNonCoreActivity().orElse(null);
        if (var2 != var3) {
            HoglinAI.getSoundForCurrentActivity(var0).ifPresent(var0::makeSound);
        }
        var0.setAggressive(var1.hasMemoryValue(MemoryModuleType.ATTACK_TARGET));
    }

    protected static void onHitTarget(EntityHoglin var0, EntityLiving var1) {
        if (var0.isBaby()) {
            return;
        }
        if (var1.getType() == EntityTypes.PIGLIN && HoglinAI.piglinsOutnumberHoglins(var0)) {
            HoglinAI.setAvoidTarget(var0, var1);
            HoglinAI.broadcastRetreat(var0, var1);
            return;
        }
        HoglinAI.broadcastAttackTarget(var0, var1);
    }

    private static void broadcastRetreat(EntityHoglin var0, EntityLiving var12) {
        HoglinAI.getVisibleAdultHoglins(var0).forEach(var1 -> HoglinAI.retreatFromNearestTarget(var1, var12));
    }

    private static void retreatFromNearestTarget(EntityHoglin var0, EntityLiving var1) {
        EntityLiving var2 = var1;
        BehaviorController<EntityHoglin> var3 = var0.getBrain();
        var2 = BehaviorUtil.getNearestTarget(var0, var3.getMemory(MemoryModuleType.AVOID_TARGET), var2);
        var2 = BehaviorUtil.getNearestTarget(var0, var3.getMemory(MemoryModuleType.ATTACK_TARGET), var2);
        HoglinAI.setAvoidTarget(var0, var2);
    }

    private static void setAvoidTarget(EntityHoglin var0, EntityLiving var1) {
        var0.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
        var0.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        var0.getBrain().setMemoryWithExpiry(MemoryModuleType.AVOID_TARGET, var1, RETREAT_DURATION.sample(var0.level().random));
    }

    private static Optional<? extends EntityLiving> findNearestValidAttackTarget(EntityHoglin var0) {
        if (HoglinAI.isPacified(var0) || HoglinAI.isBreeding(var0)) {
            return Optional.empty();
        }
        return var0.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER);
    }

    static boolean isPosNearNearestRepellent(EntityHoglin var0, BlockPosition var1) {
        Optional<BlockPosition> var2 = var0.getBrain().getMemory(MemoryModuleType.NEAREST_REPELLENT);
        return var2.isPresent() && var2.get().closerThan(var1, 8.0);
    }

    private static boolean wantsToStopFleeing(EntityHoglin var0) {
        return var0.isAdult() && !HoglinAI.piglinsOutnumberHoglins(var0);
    }

    private static boolean piglinsOutnumberHoglins(EntityHoglin var0) {
        int var2;
        if (var0.isBaby()) {
            return false;
        }
        int var1 = var0.getBrain().getMemory(MemoryModuleType.VISIBLE_ADULT_PIGLIN_COUNT).orElse(0);
        return var1 > (var2 = var0.getBrain().getMemory(MemoryModuleType.VISIBLE_ADULT_HOGLIN_COUNT).orElse(0) + 1);
    }

    protected static void wasHurtBy(EntityHoglin var0, EntityLiving var1) {
        BehaviorController<EntityHoglin> var2 = var0.getBrain();
        var2.eraseMemory(MemoryModuleType.PACIFIED);
        var2.eraseMemory(MemoryModuleType.BREED_TARGET);
        if (var0.isBaby()) {
            HoglinAI.retreatFromNearestTarget(var0, var1);
            return;
        }
        HoglinAI.maybeRetaliate(var0, var1);
    }

    private static void maybeRetaliate(EntityHoglin var0, EntityLiving var1) {
        if (var0.getBrain().isActive(Activity.AVOID) && var1.getType() == EntityTypes.PIGLIN) {
            return;
        }
        if (var1.getType() == EntityTypes.HOGLIN) {
            return;
        }
        if (BehaviorUtil.isOtherTargetMuchFurtherAwayThanCurrentAttackTarget(var0, var1, 4.0)) {
            return;
        }
        if (!Sensor.isEntityAttackable(var0, var1)) {
            return;
        }
        HoglinAI.setAttackTarget(var0, var1);
        HoglinAI.broadcastAttackTarget(var0, var1);
    }

    private static void setAttackTarget(EntityHoglin var0, EntityLiving var1) {
        BehaviorController<EntityHoglin> var2 = var0.getBrain();
        var2.eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        var2.eraseMemory(MemoryModuleType.BREED_TARGET);
        var2.setMemoryWithExpiry(MemoryModuleType.ATTACK_TARGET, var1, 200L);
    }

    private static void broadcastAttackTarget(EntityHoglin var0, EntityLiving var12) {
        HoglinAI.getVisibleAdultHoglins(var0).forEach(var1 -> HoglinAI.setAttackTargetIfCloserThanCurrent(var1, var12));
    }

    private static void setAttackTargetIfCloserThanCurrent(EntityHoglin var0, EntityLiving var1) {
        if (HoglinAI.isPacified(var0)) {
            return;
        }
        Optional<EntityLiving> var2 = var0.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET);
        EntityLiving var3 = BehaviorUtil.getNearestTarget(var0, var2, var1);
        HoglinAI.setAttackTarget(var0, var3);
    }

    public static Optional<SoundEffect> getSoundForCurrentActivity(EntityHoglin var0) {
        return var0.getBrain().getActiveNonCoreActivity().map(var1 -> HoglinAI.getSoundForActivity(var0, var1));
    }

    private static SoundEffect getSoundForActivity(EntityHoglin var0, Activity var1) {
        if (var1 == Activity.AVOID || var0.isConverting()) {
            return SoundEffects.HOGLIN_RETREAT;
        }
        if (var1 == Activity.FIGHT) {
            return SoundEffects.HOGLIN_ANGRY;
        }
        if (HoglinAI.isNearRepellent(var0)) {
            return SoundEffects.HOGLIN_RETREAT;
        }
        return SoundEffects.HOGLIN_AMBIENT;
    }

    private static List<EntityHoglin> getVisibleAdultHoglins(EntityHoglin var0) {
        return var0.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_ADULT_HOGLINS).orElse((List<EntityHoglin>)ImmutableList.of());
    }

    private static boolean isNearRepellent(EntityHoglin var0) {
        return var0.getBrain().hasMemoryValue(MemoryModuleType.NEAREST_REPELLENT);
    }

    private static boolean isBreeding(EntityHoglin var0) {
        return var0.getBrain().hasMemoryValue(MemoryModuleType.BREED_TARGET);
    }

    protected static boolean isPacified(EntityHoglin var0) {
        return var0.getBrain().hasMemoryValue(MemoryModuleType.PACIFIED);
    }
}

