/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.piglin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.GlobalPos;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.BehaviorAttack;
import net.minecraft.world.entity.ai.behavior.BehaviorAttackTargetForget;
import net.minecraft.world.entity.ai.behavior.BehaviorAttackTargetSet;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorForgetAnger;
import net.minecraft.world.entity.ai.behavior.BehaviorGateSingle;
import net.minecraft.world.entity.ai.behavior.BehaviorInteract;
import net.minecraft.world.entity.ai.behavior.BehaviorInteractDoor;
import net.minecraft.world.entity.ai.behavior.BehaviorLook;
import net.minecraft.world.entity.ai.behavior.BehaviorLookInteract;
import net.minecraft.world.entity.ai.behavior.BehaviorLookTarget;
import net.minecraft.world.entity.ai.behavior.BehaviorNop;
import net.minecraft.world.entity.ai.behavior.BehaviorStrollPlace;
import net.minecraft.world.entity.ai.behavior.BehaviorStrollPosition;
import net.minecraft.world.entity.ai.behavior.BehaviorStrollRandomUnconstrained;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.behavior.BehaviorWalkAwayOutOfRange;
import net.minecraft.world.entity.ai.behavior.BehavorMove;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.monster.piglin.EntityPiglinAbstract;
import net.minecraft.world.entity.monster.piglin.EntityPiglinBrute;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.schedule.Activity;

public class PiglinBruteAI {
    private static final int ANGER_DURATION = 600;
    private static final int MELEE_ATTACK_COOLDOWN = 20;
    private static final double ACTIVITY_SOUND_LIKELIHOOD_PER_TICK = 0.0125;
    private static final int MAX_LOOK_DIST = 8;
    private static final int INTERACTION_RANGE = 8;
    private static final double TARGETING_RANGE = 12.0;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 0.6f;
    private static final int HOME_CLOSE_ENOUGH_DISTANCE = 2;
    private static final int HOME_TOO_FAR_DISTANCE = 100;
    private static final int HOME_STROLL_AROUND_DISTANCE = 5;

    protected static BehaviorController<?> makeBrain(EntityPiglinBrute var0, BehaviorController<EntityPiglinBrute> var1) {
        PiglinBruteAI.initCoreActivity(var0, var1);
        PiglinBruteAI.initIdleActivity(var0, var1);
        PiglinBruteAI.initFightActivity(var0, var1);
        var1.setCoreActivities((Set<Activity>)ImmutableSet.of((Object)Activity.CORE));
        var1.setDefaultActivity(Activity.IDLE);
        var1.useDefaultActivity();
        return var1;
    }

    protected static void initMemories(EntityPiglinBrute var0) {
        GlobalPos var1 = GlobalPos.of(var0.level().dimension(), var0.blockPosition());
        var0.getBrain().setMemory(MemoryModuleType.HOME, var1);
    }

    private static void initCoreActivity(EntityPiglinBrute var0, BehaviorController<EntityPiglinBrute> var1) {
        var1.addActivity(Activity.CORE, 0, (ImmutableList<BehaviorControl<EntityPiglinBrute>>)ImmutableList.of((Object)new BehaviorLook(45, 90), (Object)new BehavorMove(), BehaviorInteractDoor.create(), BehaviorForgetAnger.create()));
    }

    private static void initIdleActivity(EntityPiglinBrute var0, BehaviorController<EntityPiglinBrute> var1) {
        var1.addActivity(Activity.IDLE, 10, (ImmutableList<BehaviorControl<EntityPiglinBrute>>)ImmutableList.of(BehaviorAttackTargetSet.create(PiglinBruteAI::findNearestValidAttackTarget), PiglinBruteAI.createIdleLookBehaviors(), PiglinBruteAI.createIdleMovementBehaviors(), BehaviorLookInteract.create(EntityTypes.PLAYER, 4)));
    }

    private static void initFightActivity(EntityPiglinBrute var0, BehaviorController<EntityPiglinBrute> var12) {
        var12.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, (ImmutableList<BehaviorControl<EntityPiglinBrute>>)ImmutableList.of(BehaviorAttackTargetForget.create(var1 -> !PiglinBruteAI.isNearestValidAttackTarget(var0, var1)), BehaviorWalkAwayOutOfRange.create(1.0f), BehaviorAttack.create(20)), MemoryModuleType.ATTACK_TARGET);
    }

    private static BehaviorGateSingle<EntityPiglinBrute> createIdleLookBehaviors() {
        return new BehaviorGateSingle<EntityPiglinBrute>((List<Pair<BehaviorControl<EntityPiglinBrute>, Integer>>)ImmutableList.of((Object)Pair.of(BehaviorLookTarget.create(EntityTypes.PLAYER, 8.0f), (Object)1), (Object)Pair.of(BehaviorLookTarget.create(EntityTypes.PIGLIN, 8.0f), (Object)1), (Object)Pair.of(BehaviorLookTarget.create(EntityTypes.PIGLIN_BRUTE, 8.0f), (Object)1), (Object)Pair.of(BehaviorLookTarget.create(8.0f), (Object)1), (Object)Pair.of((Object)new BehaviorNop(30, 60), (Object)1)));
    }

    private static BehaviorGateSingle<EntityPiglinBrute> createIdleMovementBehaviors() {
        return new BehaviorGateSingle<EntityPiglinBrute>((List<Pair<BehaviorControl<EntityPiglinBrute>, Integer>>)ImmutableList.of((Object)Pair.of(BehaviorStrollRandomUnconstrained.stroll(0.6f), (Object)2), (Object)Pair.of(BehaviorInteract.of(EntityTypes.PIGLIN, 8, MemoryModuleType.INTERACTION_TARGET, 0.6f, 2), (Object)2), (Object)Pair.of(BehaviorInteract.of(EntityTypes.PIGLIN_BRUTE, 8, MemoryModuleType.INTERACTION_TARGET, 0.6f, 2), (Object)2), (Object)Pair.of(BehaviorStrollPlace.create(MemoryModuleType.HOME, 0.6f, 2, 100), (Object)2), (Object)Pair.of(BehaviorStrollPosition.create(MemoryModuleType.HOME, 0.6f, 5), (Object)2), (Object)Pair.of((Object)new BehaviorNop(30, 60), (Object)1)));
    }

    protected static void updateActivity(EntityPiglinBrute var0) {
        BehaviorController<EntityPiglinBrute> var1 = var0.getBrain();
        Activity var2 = var1.getActiveNonCoreActivity().orElse(null);
        var1.setActiveActivityToFirstValid((List<Activity>)ImmutableList.of((Object)Activity.FIGHT, (Object)Activity.IDLE));
        Activity var3 = var1.getActiveNonCoreActivity().orElse(null);
        if (var2 != var3) {
            PiglinBruteAI.playActivitySound(var0);
        }
        var0.setAggressive(var1.hasMemoryValue(MemoryModuleType.ATTACK_TARGET));
    }

    private static boolean isNearestValidAttackTarget(EntityPiglinAbstract var0, EntityLiving var12) {
        return PiglinBruteAI.findNearestValidAttackTarget(var0).filter(var1 -> var1 == var12).isPresent();
    }

    private static Optional<? extends EntityLiving> findNearestValidAttackTarget(EntityPiglinAbstract var0) {
        Optional<EntityLiving> var1 = BehaviorUtil.getLivingEntityFromUUIDMemory(var0, MemoryModuleType.ANGRY_AT);
        if (var1.isPresent() && Sensor.isEntityAttackableIgnoringLineOfSight(var0, var1.get())) {
            return var1;
        }
        Optional<? extends EntityLiving> var2 = PiglinBruteAI.getTargetIfWithinRange(var0, MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER);
        if (var2.isPresent()) {
            return var2;
        }
        return var0.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_NEMESIS);
    }

    private static Optional<? extends EntityLiving> getTargetIfWithinRange(EntityPiglinAbstract var0, MemoryModuleType<? extends EntityLiving> var12) {
        return var0.getBrain().getMemory(var12).filter(var1 -> var1.closerThan(var0, 12.0));
    }

    protected static void wasHurtBy(EntityPiglinBrute var0, EntityLiving var1) {
        if (var1 instanceof EntityPiglinAbstract) {
            return;
        }
        PiglinAI.maybeRetaliate(var0, var1);
    }

    protected static void setAngerTarget(EntityPiglinBrute var0, EntityLiving var1) {
        var0.getBrain().eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        var0.getBrain().setMemoryWithExpiry(MemoryModuleType.ANGRY_AT, var1.getUUID(), 600L);
    }

    protected static void maybePlayActivitySound(EntityPiglinBrute var0) {
        if ((double)var0.level().random.nextFloat() < 0.0125) {
            PiglinBruteAI.playActivitySound(var0);
        }
    }

    private static void playActivitySound(EntityPiglinBrute var0) {
        var0.getBrain().getActiveNonCoreActivity().ifPresent(var1 -> {
            if (var1 == Activity.FIGHT) {
                var0.playAngrySound();
            }
        });
    }
}

