/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalInteract;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtTradingPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveTowardsRestriction;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTradeWithPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalUseItem;
import net.minecraft.world.entity.monster.EntityEvoker;
import net.minecraft.world.entity.monster.EntityIllagerIllusioner;
import net.minecraft.world.entity.monster.EntityPillager;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.monster.EntityVindicator;
import net.minecraft.world.entity.monster.EntityZoglin;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.tuple.Pair;

public class EntityVillagerTrader
extends EntityVillagerAbstract {
    private static final int NUMBER_OF_TRADE_OFFERS = 5;
    @Nullable
    private BlockPosition wanderTarget;
    private int despawnDelay;

    public EntityVillagerTrader(EntityTypes<? extends EntityVillagerTrader> var0, World var1) {
        super((EntityTypes<? extends EntityVillagerAbstract>)var0, var1);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(0, new PathfinderGoalUseItem<EntityVillagerTrader>(this, PotionContents.createItemStack(Items.POTION, Potions.INVISIBILITY), SoundEffects.WANDERING_TRADER_DISAPPEARED, var0 -> this.level().isNight() && !var0.isInvisible()));
        this.goalSelector.addGoal(0, new PathfinderGoalUseItem<EntityVillagerTrader>(this, new ItemStack(Items.MILK_BUCKET), SoundEffects.WANDERING_TRADER_REAPPEARED, var0 -> this.level().isDay() && var0.isInvisible()));
        this.goalSelector.addGoal(1, new PathfinderGoalTradeWithPlayer(this));
        this.goalSelector.addGoal(1, new PathfinderGoalAvoidTarget<EntityZombie>(this, EntityZombie.class, 8.0f, 0.5, 0.5));
        this.goalSelector.addGoal(1, new PathfinderGoalAvoidTarget<EntityEvoker>(this, EntityEvoker.class, 12.0f, 0.5, 0.5));
        this.goalSelector.addGoal(1, new PathfinderGoalAvoidTarget<EntityVindicator>(this, EntityVindicator.class, 8.0f, 0.5, 0.5));
        this.goalSelector.addGoal(1, new PathfinderGoalAvoidTarget<EntityVex>(this, EntityVex.class, 8.0f, 0.5, 0.5));
        this.goalSelector.addGoal(1, new PathfinderGoalAvoidTarget<EntityPillager>(this, EntityPillager.class, 15.0f, 0.5, 0.5));
        this.goalSelector.addGoal(1, new PathfinderGoalAvoidTarget<EntityIllagerIllusioner>(this, EntityIllagerIllusioner.class, 12.0f, 0.5, 0.5));
        this.goalSelector.addGoal(1, new PathfinderGoalAvoidTarget<EntityZoglin>(this, EntityZoglin.class, 10.0f, 0.5, 0.5));
        this.goalSelector.addGoal(1, new PathfinderGoalPanic(this, 0.5));
        this.goalSelector.addGoal(1, new PathfinderGoalLookAtTradingPlayer(this));
        this.goalSelector.addGoal(2, new a(this, 2.0, 0.35));
        this.goalSelector.addGoal(4, new PathfinderGoalMoveTowardsRestriction(this, 0.35));
        this.goalSelector.addGoal(8, new PathfinderGoalRandomStrollLand(this, 0.35));
        this.goalSelector.addGoal(9, new PathfinderGoalInteract(this, EntityHuman.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
    }

    @Override
    @Nullable
    public EntityAgeable getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        return null;
    }

    @Override
    public boolean showProgressBar() {
        return false;
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        ItemStack var2 = var0.getItemInHand(var1);
        if (!var2.is(Items.VILLAGER_SPAWN_EGG) && this.isAlive() && !this.isTrading() && !this.isBaby()) {
            if (var1 == EnumHand.MAIN_HAND) {
                var0.awardStat(StatisticList.TALKED_TO_VILLAGER);
            }
            if (!this.level().isClientSide) {
                if (this.getOffers().isEmpty()) {
                    return EnumInteractionResult.CONSUME;
                }
                this.setTradingPlayer(var0);
                this.openTradingScreen(var0, this.getDisplayName(), 1);
            }
            return EnumInteractionResult.sidedSuccess(this.level().isClientSide);
        }
        return super.mobInteract(var0, var1);
    }

    @Override
    protected void updateTrades() {
        if (this.level().enabledFeatures().contains(FeatureFlags.TRADE_REBALANCE)) {
            this.experimentalUpdateTrades();
            return;
        }
        VillagerTrades.IMerchantRecipeOption[] var0 = (VillagerTrades.IMerchantRecipeOption[])VillagerTrades.WANDERING_TRADER_TRADES.get(1);
        VillagerTrades.IMerchantRecipeOption[] var1 = (VillagerTrades.IMerchantRecipeOption[])VillagerTrades.WANDERING_TRADER_TRADES.get(2);
        if (var0 == null || var1 == null) {
            return;
        }
        MerchantRecipeList var2 = this.getOffers();
        this.addOffersFromItemListings(var2, var0, 5);
        int var3 = this.random.nextInt(var1.length);
        VillagerTrades.IMerchantRecipeOption var4 = var1[var3];
        MerchantRecipe var5 = var4.getOffer(this, this.random);
        if (var5 != null) {
            var2.add(var5);
        }
    }

    private void experimentalUpdateTrades() {
        MerchantRecipeList var0 = this.getOffers();
        for (Pair<VillagerTrades.IMerchantRecipeOption[], Integer> var2 : VillagerTrades.EXPERIMENTAL_WANDERING_TRADER_TRADES) {
            VillagerTrades.IMerchantRecipeOption[] var3 = (VillagerTrades.IMerchantRecipeOption[])var2.getLeft();
            this.addOffersFromItemListings(var0, var3, (Integer)var2.getRight());
        }
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("DespawnDelay", this.despawnDelay);
        if (this.wanderTarget != null) {
            var0.put("wander_target", GameProfileSerializer.writeBlockPos(this.wanderTarget));
        }
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var02) {
        super.readAdditionalSaveData(var02);
        if (var02.contains("DespawnDelay", 99)) {
            this.despawnDelay = var02.getInt("DespawnDelay");
        }
        GameProfileSerializer.readBlockPos(var02, "wander_target").ifPresent(var0 -> {
            this.wanderTarget = var0;
        });
        this.setAge(Math.max(0, this.getAge()));
    }

    @Override
    public boolean removeWhenFarAway(double var0) {
        return false;
    }

    @Override
    protected void rewardTradeXp(MerchantRecipe var0) {
        if (var0.shouldRewardExp()) {
            int var1 = 3 + this.random.nextInt(4);
            this.level().addFreshEntity(new EntityExperienceOrb(this.level(), this.getX(), this.getY() + 0.5, this.getZ(), var1));
        }
    }

    @Override
    protected SoundEffect getAmbientSound() {
        if (this.isTrading()) {
            return SoundEffects.WANDERING_TRADER_TRADE;
        }
        return SoundEffects.WANDERING_TRADER_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.WANDERING_TRADER_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.WANDERING_TRADER_DEATH;
    }

    @Override
    protected SoundEffect getDrinkingSound(ItemStack var0) {
        if (var0.is(Items.MILK_BUCKET)) {
            return SoundEffects.WANDERING_TRADER_DRINK_MILK;
        }
        return SoundEffects.WANDERING_TRADER_DRINK_POTION;
    }

    @Override
    protected SoundEffect getTradeUpdatedSound(boolean var0) {
        return var0 ? SoundEffects.WANDERING_TRADER_YES : SoundEffects.WANDERING_TRADER_NO;
    }

    @Override
    public SoundEffect getNotifyTradeSound() {
        return SoundEffects.WANDERING_TRADER_YES;
    }

    public void setDespawnDelay(int var0) {
        this.despawnDelay = var0;
    }

    public int getDespawnDelay() {
        return this.despawnDelay;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide) {
            this.maybeDespawn();
        }
    }

    private void maybeDespawn() {
        if (this.despawnDelay > 0 && !this.isTrading() && --this.despawnDelay == 0) {
            this.discard();
        }
    }

    public void setWanderTarget(@Nullable BlockPosition var0) {
        this.wanderTarget = var0;
    }

    @Nullable
    BlockPosition getWanderTarget() {
        return this.wanderTarget;
    }

    class a
    extends PathfinderGoal {
        final EntityVillagerTrader trader;
        final double stopDistance;
        final double speedModifier;

        a(EntityVillagerTrader var1, double var2, double var4) {
            this.trader = var1;
            this.stopDistance = var2;
            this.speedModifier = var4;
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
        }

        @Override
        public void stop() {
            this.trader.setWanderTarget(null);
            EntityVillagerTrader.this.navigation.stop();
        }

        @Override
        public boolean canUse() {
            BlockPosition var0 = this.trader.getWanderTarget();
            return var0 != null && this.isTooFarAway(var0, this.stopDistance);
        }

        @Override
        public void tick() {
            BlockPosition var0 = this.trader.getWanderTarget();
            if (var0 != null && EntityVillagerTrader.this.navigation.isDone()) {
                if (this.isTooFarAway(var0, 10.0)) {
                    Vec3D var1 = new Vec3D((double)var0.getX() - this.trader.getX(), (double)var0.getY() - this.trader.getY(), (double)var0.getZ() - this.trader.getZ()).normalize();
                    Vec3D var2 = var1.scale(10.0).add(this.trader.getX(), this.trader.getY(), this.trader.getZ());
                    EntityVillagerTrader.this.navigation.moveTo(var2.x, var2.y, var2.z, this.speedModifier);
                } else {
                    EntityVillagerTrader.this.navigation.moveTo(var0.getX(), var0.getY(), var0.getZ(), this.speedModifier);
                }
            }
        }

        private boolean isTooFarAway(BlockPosition var0, double var1) {
            return !var0.closerToCenterThan(this.trader.position(), var1);
        }
    }
}

