/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.collect.ImmutableSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public record VillagerProfession(String name, Predicate<Holder<VillagePlaceType>> heldJobSite, Predicate<Holder<VillagePlaceType>> acquirableJobSite, ImmutableSet<Item> requestedItems, ImmutableSet<Block> secondaryPoi, @Nullable SoundEffect workSound) {
    public static final Predicate<Holder<VillagePlaceType>> ALL_ACQUIRABLE_JOBS = var0 -> var0.is(PoiTypeTags.ACQUIRABLE_JOB_SITE);
    public static final VillagerProfession NONE = VillagerProfession.register("none", VillagePlaceType.NONE, ALL_ACQUIRABLE_JOBS, null);
    public static final VillagerProfession ARMORER = VillagerProfession.register("armorer", PoiTypes.ARMORER, SoundEffects.VILLAGER_WORK_ARMORER);
    public static final VillagerProfession BUTCHER = VillagerProfession.register("butcher", PoiTypes.BUTCHER, SoundEffects.VILLAGER_WORK_BUTCHER);
    public static final VillagerProfession CARTOGRAPHER = VillagerProfession.register("cartographer", PoiTypes.CARTOGRAPHER, SoundEffects.VILLAGER_WORK_CARTOGRAPHER);
    public static final VillagerProfession CLERIC = VillagerProfession.register("cleric", PoiTypes.CLERIC, SoundEffects.VILLAGER_WORK_CLERIC);
    public static final VillagerProfession FARMER = VillagerProfession.register("farmer", PoiTypes.FARMER, (ImmutableSet<Item>)ImmutableSet.of((Object)Items.WHEAT, (Object)Items.WHEAT_SEEDS, (Object)Items.BEETROOT_SEEDS, (Object)Items.BONE_MEAL), (ImmutableSet<Block>)ImmutableSet.of((Object)Blocks.FARMLAND), SoundEffects.VILLAGER_WORK_FARMER);
    public static final VillagerProfession FISHERMAN = VillagerProfession.register("fisherman", PoiTypes.FISHERMAN, SoundEffects.VILLAGER_WORK_FISHERMAN);
    public static final VillagerProfession FLETCHER = VillagerProfession.register("fletcher", PoiTypes.FLETCHER, SoundEffects.VILLAGER_WORK_FLETCHER);
    public static final VillagerProfession LEATHERWORKER = VillagerProfession.register("leatherworker", PoiTypes.LEATHERWORKER, SoundEffects.VILLAGER_WORK_LEATHERWORKER);
    public static final VillagerProfession LIBRARIAN = VillagerProfession.register("librarian", PoiTypes.LIBRARIAN, SoundEffects.VILLAGER_WORK_LIBRARIAN);
    public static final VillagerProfession MASON = VillagerProfession.register("mason", PoiTypes.MASON, SoundEffects.VILLAGER_WORK_MASON);
    public static final VillagerProfession NITWIT = VillagerProfession.register("nitwit", VillagePlaceType.NONE, VillagePlaceType.NONE, null);
    public static final VillagerProfession SHEPHERD = VillagerProfession.register("shepherd", PoiTypes.SHEPHERD, SoundEffects.VILLAGER_WORK_SHEPHERD);
    public static final VillagerProfession TOOLSMITH = VillagerProfession.register("toolsmith", PoiTypes.TOOLSMITH, SoundEffects.VILLAGER_WORK_TOOLSMITH);
    public static final VillagerProfession WEAPONSMITH = VillagerProfession.register("weaponsmith", PoiTypes.WEAPONSMITH, SoundEffects.VILLAGER_WORK_WEAPONSMITH);

    @Override
    public String toString() {
        return this.name;
    }

    private static VillagerProfession register(String var0, ResourceKey<VillagePlaceType> var12, @Nullable SoundEffect var2) {
        return VillagerProfession.register(var0, var1 -> var1.is(var12), var1 -> var1.is(var12), var2);
    }

    private static VillagerProfession register(String var0, Predicate<Holder<VillagePlaceType>> var1, Predicate<Holder<VillagePlaceType>> var2, @Nullable SoundEffect var3) {
        return VillagerProfession.register(var0, var1, var2, (ImmutableSet<Item>)ImmutableSet.of(), (ImmutableSet<Block>)ImmutableSet.of(), var3);
    }

    private static VillagerProfession register(String var0, ResourceKey<VillagePlaceType> var12, ImmutableSet<Item> var2, ImmutableSet<Block> var3, @Nullable SoundEffect var4) {
        return VillagerProfession.register(var0, var1 -> var1.is(var12), var1 -> var1.is(var12), var2, var3, var4);
    }

    private static VillagerProfession register(String var0, Predicate<Holder<VillagePlaceType>> var1, Predicate<Holder<VillagePlaceType>> var2, ImmutableSet<Item> var3, ImmutableSet<Block> var4, @Nullable SoundEffect var5) {
        return IRegistry.register(BuiltInRegistries.VILLAGER_PROFESSION, MinecraftKey.withDefaultNamespace(var0), new VillagerProfession(var0, var1, var2, var3, var4, var5));
    }
}

