/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.OminousItemSpawner;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class EntityArrow
extends IProjectile {
    private static final double ARROW_BASE_DAMAGE = 2.0;
    private static final DataWatcherObject<Byte> ID_FLAGS = DataWatcher.defineId(EntityArrow.class, DataWatcherRegistry.BYTE);
    private static final DataWatcherObject<Byte> PIERCE_LEVEL = DataWatcher.defineId(EntityArrow.class, DataWatcherRegistry.BYTE);
    private static final int FLAG_CRIT = 1;
    private static final int FLAG_NOPHYSICS = 2;
    @Nullable
    private IBlockData lastState;
    public boolean inGround;
    protected int inGroundTime;
    public PickupStatus pickup = PickupStatus.DISALLOWED;
    public int shakeTime;
    public int life;
    private double baseDamage = 2.0;
    private SoundEffect soundEvent = this.getDefaultHitGroundSoundEvent();
    @Nullable
    private IntOpenHashSet piercingIgnoreEntityIds;
    @Nullable
    private List<Entity> piercedAndKilledEntities;
    public ItemStack pickupItemStack = this.getDefaultPickupItem();
    @Nullable
    public ItemStack firedFromWeapon = null;

    protected EntityArrow(EntityTypes<? extends EntityArrow> var0, World var1) {
        super((EntityTypes<? extends IProjectile>)var0, var1);
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> var02, double var1, double var3, double var5, World var7, ItemStack var8, @Nullable ItemStack var9) {
        this(var02, var7);
        this.pickupItemStack = var8.copy();
        this.setCustomName(var8.get(DataComponents.CUSTOM_NAME));
        Unit var10 = var8.remove(DataComponents.INTANGIBLE_PROJECTILE);
        if (var10 != null) {
            this.pickup = PickupStatus.CREATIVE_ONLY;
        }
        this.setPos(var1, var3, var5);
        if (var9 != null && var7 instanceof WorldServer) {
            WorldServer var11 = (WorldServer)var7;
            if (var9.isEmpty()) {
                throw new IllegalArgumentException("Invalid weapon firing an arrow");
            }
            this.firedFromWeapon = var9.copy();
            int var12 = EnchantmentManager.getPiercingCount(var11, var9, this.pickupItemStack);
            if (var12 > 0) {
                this.setPierceLevel((byte)var12);
            }
            EnchantmentManager.onProjectileSpawned(var11, var9, this, var0 -> {
                this.firedFromWeapon = null;
            });
        }
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> var0, EntityLiving var1, World var2, ItemStack var3, @Nullable ItemStack var4) {
        this(var0, var1.getX(), var1.getEyeY() - (double)0.1f, var1.getZ(), var2, var3, var4);
        this.setOwner(var1);
    }

    public void setSoundEvent(SoundEffect var0) {
        this.soundEvent = var0;
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double var0) {
        double var2 = this.getBoundingBox().getSize() * 10.0;
        if (Double.isNaN(var2)) {
            var2 = 1.0;
        }
        return var0 < (var2 *= 64.0 * EntityArrow.getViewScale()) * var2;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        var0.define(ID_FLAGS, (byte)0);
        var0.define(PIERCE_LEVEL, (byte)0);
    }

    @Override
    public void shoot(double var0, double var2, double var4, float var6, float var7) {
        super.shoot(var0, var2, var4, var6, var7);
        this.life = 0;
    }

    @Override
    public void lerpTo(double var0, double var2, double var4, float var6, float var7, int var8) {
        this.setPos(var0, var2, var4);
        this.setRot(var6, var7);
    }

    @Override
    public void lerpMotion(double var0, double var2, double var4) {
        super.lerpMotion(var0, var2, var4);
        this.life = 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void tick() {
        Vec3D var5;
        Object var4;
        super.tick();
        boolean var0 = this.isNoPhysics();
        Vec3D var1 = this.getDeltaMovement();
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double var2 = var1.horizontalDistance();
            this.setYRot((float)(MathHelper.atan2(var1.x, var1.z) * 57.2957763671875));
            this.setXRot((float)(MathHelper.atan2(var1.y, var2) * 57.2957763671875));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
        BlockPosition var2 = this.blockPosition();
        IBlockData var3 = this.level().getBlockState(var2);
        if (!(var3.isAir() || var0 || ((VoxelShape)(var4 = var3.getCollisionShape(this.level(), var2))).isEmpty())) {
            var5 = this.position();
            for (AxisAlignedBB axisAlignedBB : ((VoxelShape)var4).toAabbs()) {
                if (!axisAlignedBB.move(var2).contains(var5)) continue;
                this.inGround = true;
                break;
            }
        }
        if (this.shakeTime > 0) {
            --this.shakeTime;
        }
        if (this.isInWaterOrRain() || var3.is(Blocks.POWDER_SNOW)) {
            this.clearFire();
        }
        if (this.inGround && !var0) {
            if (this.lastState != var3 && this.shouldFall()) {
                this.startFalling();
            } else if (!this.level().isClientSide) {
                this.tickDespawn();
            }
            ++this.inGroundTime;
            return;
        }
        this.inGroundTime = 0;
        var4 = this.position();
        var5 = ((Vec3D)var4).add(var1);
        MovingObjectPosition var6 = this.level().clip(new RayTrace((Vec3D)var4, var5, RayTrace.BlockCollisionOption.COLLIDER, RayTrace.FluidCollisionOption.NONE, this));
        if (var6.getType() != MovingObjectPosition.EnumMovingObjectType.MISS) {
            var5 = var6.getLocation();
        }
        while (!this.isRemoved()) {
            void var8_13;
            Object var8;
            MovingObjectPositionEntity movingObjectPositionEntity = this.findHitEntity((Vec3D)var4, var5);
            if (movingObjectPositionEntity != null) {
                var6 = movingObjectPositionEntity;
            }
            if (var6 != null && var6.getType() == MovingObjectPosition.EnumMovingObjectType.ENTITY) {
                var8 = ((MovingObjectPositionEntity)var6).getEntity();
                Entity var9 = this.getOwner();
                if (var8 instanceof EntityHuman && var9 instanceof EntityHuman && !((EntityHuman)var9).canHarmPlayer((EntityHuman)var8)) {
                    var6 = null;
                    Object var8_12 = null;
                }
            }
            if (var6 != null && !var0) {
                var8 = this.hitTargetOrDeflectSelf(var6);
                this.hasImpulse = true;
                if (var8 != ProjectileDeflection.NONE) break;
            }
            if (var8_13 == null || this.getPierceLevel() <= 0) break;
            var6 = null;
        }
        var1 = this.getDeltaMovement();
        double d2 = var1.x;
        double var9 = var1.y;
        double var11 = var1.z;
        if (this.isCritArrow()) {
            for (int var13 = 0; var13 < 4; ++var13) {
                this.level().addParticle(Particles.CRIT, this.getX() + d2 * (double)var13 / 4.0, this.getY() + var9 * (double)var13 / 4.0, this.getZ() + var11 * (double)var13 / 4.0, -d2, -var9 + 0.2, -var11);
            }
        }
        double var13 = this.getX() + d2;
        double var15 = this.getY() + var9;
        double var17 = this.getZ() + var11;
        double var19 = var1.horizontalDistance();
        if (var0) {
            this.setYRot((float)(MathHelper.atan2(-d2, -var11) * 57.2957763671875));
        } else {
            this.setYRot((float)(MathHelper.atan2(d2, var11) * 57.2957763671875));
        }
        this.setXRot((float)(MathHelper.atan2(var9, var19) * 57.2957763671875));
        this.setXRot(EntityArrow.lerpRotation(this.xRotO, this.getXRot()));
        this.setYRot(EntityArrow.lerpRotation(this.yRotO, this.getYRot()));
        float var21 = 0.99f;
        if (this.isInWater()) {
            for (int var22 = 0; var22 < 4; ++var22) {
                float var23 = 0.25f;
                this.level().addParticle(Particles.BUBBLE, var13 - d2 * 0.25, var15 - var9 * 0.25, var17 - var11 * 0.25, d2, var9, var11);
            }
            var21 = this.getWaterInertia();
        }
        this.setDeltaMovement(var1.scale(var21));
        if (!var0) {
            this.applyGravity();
        }
        this.setPos(var13, var15, var17);
        this.checkInsideBlocks();
    }

    @Override
    protected double getDefaultGravity() {
        return 0.05;
    }

    private boolean shouldFall() {
        return this.inGround && this.level().noCollision(new AxisAlignedBB(this.position(), this.position()).inflate(0.06));
    }

    private void startFalling() {
        this.inGround = false;
        Vec3D var0 = this.getDeltaMovement();
        this.setDeltaMovement(var0.multiply(this.random.nextFloat() * 0.2f, this.random.nextFloat() * 0.2f, this.random.nextFloat() * 0.2f));
        this.life = 0;
    }

    @Override
    public void move(EnumMoveType var0, Vec3D var1) {
        super.move(var0, var1);
        if (var0 != EnumMoveType.SELF && this.shouldFall()) {
            this.startFalling();
        }
    }

    protected void tickDespawn() {
        ++this.life;
        if (this.life >= 1200) {
            this.discard();
        }
    }

    private void resetPiercedEntities() {
        if (this.piercedAndKilledEntities != null) {
            this.piercedAndKilledEntities.clear();
        }
        if (this.piercingIgnoreEntityIds != null) {
            this.piercingIgnoreEntityIds.clear();
        }
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity var0) {
        World world;
        super.onHitEntity(var0);
        Entity var1 = var0.getEntity();
        float var2 = (float)this.getDeltaMovement().length();
        double var3 = this.baseDamage;
        Entity var5 = this.getOwner();
        DamageSource var6 = this.damageSources().arrow(this, var5 != null ? var5 : this);
        if (this.getWeaponItem() != null && (world = this.level()) instanceof WorldServer) {
            WorldServer var7 = (WorldServer)world;
            var3 = EnchantmentManager.modifyDamage(var7, this.getWeaponItem(), var1, var6, (float)var3);
        }
        int var7 = MathHelper.ceil(MathHelper.clamp((double)var2 * var3, 0.0, 2.147483647E9));
        if (this.getPierceLevel() > 0) {
            if (this.piercingIgnoreEntityIds == null) {
                this.piercingIgnoreEntityIds = new IntOpenHashSet(5);
            }
            if (this.piercedAndKilledEntities == null) {
                this.piercedAndKilledEntities = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.piercingIgnoreEntityIds.size() < this.getPierceLevel() + 1) {
                this.piercingIgnoreEntityIds.add(var1.getId());
            } else {
                this.discard();
                return;
            }
        }
        if (this.isCritArrow()) {
            long var8 = this.random.nextInt(var7 / 2 + 2);
            var7 = (int)Math.min(var8 + (long)var7, Integer.MAX_VALUE);
        }
        if (var5 instanceof EntityLiving) {
            EntityLiving var8 = (EntityLiving)var5;
            var8.setLastHurtMob(var1);
        }
        boolean var8 = var1.getType() == EntityTypes.ENDERMAN;
        int var9 = var1.getRemainingFireTicks();
        if (this.isOnFire() && !var8) {
            var1.igniteForSeconds(5.0f);
        }
        if (var1.hurt(var6, var7)) {
            if (var8) {
                return;
            }
            if (var1 instanceof EntityLiving) {
                Object var11;
                EntityLiving var10 = (EntityLiving)var1;
                if (!this.level().isClientSide && this.getPierceLevel() <= 0) {
                    var10.setArrowCount(var10.getArrowCount() + 1);
                }
                this.doKnockback(var10, var6);
                World world2 = this.level();
                if (world2 instanceof WorldServer) {
                    var11 = (WorldServer)world2;
                    EnchantmentManager.doPostAttackEffectsWithItemSource((WorldServer)var11, var10, var6, this.getWeaponItem());
                }
                this.doPostHurtEffects(var10);
                if (var10 != var5 && var10 instanceof EntityHuman && var5 instanceof EntityPlayer && !this.isSilent()) {
                    ((EntityPlayer)var5).connection.send(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.ARROW_HIT_PLAYER, 0.0f));
                }
                if (!var1.isAlive() && this.piercedAndKilledEntities != null) {
                    this.piercedAndKilledEntities.add(var10);
                }
                if (!this.level().isClientSide && var5 instanceof EntityPlayer) {
                    var11 = (EntityPlayer)var5;
                    if (this.piercedAndKilledEntities != null && this.shotFromCrossbow()) {
                        CriterionTriggers.KILLED_BY_CROSSBOW.trigger((EntityPlayer)var11, this.piercedAndKilledEntities);
                    } else if (!var1.isAlive() && this.shotFromCrossbow()) {
                        CriterionTriggers.KILLED_BY_CROSSBOW.trigger((EntityPlayer)var11, Arrays.asList(var1));
                    }
                }
            }
            this.playSound(this.soundEvent, 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
            if (this.getPierceLevel() <= 0) {
                this.discard();
            }
        } else {
            var1.setRemainingFireTicks(var9);
            this.deflect(ProjectileDeflection.REVERSE, var1, this.getOwner(), false);
            this.setDeltaMovement(this.getDeltaMovement().scale(0.2));
            if (!this.level().isClientSide && this.getDeltaMovement().lengthSqr() < 1.0E-7) {
                if (this.pickup == PickupStatus.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.discard();
            }
        }
    }

    protected void doKnockback(EntityLiving var0, DamageSource var1) {
        float f2;
        World world;
        if (this.firedFromWeapon != null && (world = this.level()) instanceof WorldServer) {
            WorldServer var4 = (WorldServer)world;
            f2 = EnchantmentManager.modifyKnockback(var4, this.firedFromWeapon, var0, var1, 0.0f);
        } else {
            f2 = 0.0f;
        }
        double var2 = f2;
        if (var2 > 0.0) {
            double var4 = Math.max(0.0, 1.0 - var0.getAttributeValue(GenericAttributes.KNOCKBACK_RESISTANCE));
            Vec3D var6 = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale(var2 * 0.6 * var4);
            if (var6.lengthSqr() > 0.0) {
                var0.push(var6.x, 0.1, var6.z);
            }
        }
    }

    @Override
    protected void onHitBlock(MovingObjectPositionBlock var0) {
        Object var3;
        this.lastState = this.level().getBlockState(var0.getBlockPos());
        super.onHitBlock(var0);
        Vec3D var1 = var0.getLocation().subtract(this.getX(), this.getY(), this.getZ());
        this.setDeltaMovement(var1);
        ItemStack var2 = this.getWeaponItem();
        World world = this.level();
        if (world instanceof WorldServer) {
            var3 = (WorldServer)world;
            if (var2 != null) {
                this.hitBlockEnchantmentEffects((WorldServer)var3, var0, var2);
            }
        }
        var3 = var1.normalize().scale(0.05f);
        this.setPosRaw(this.getX() - ((Vec3D)var3).x, this.getY() - ((Vec3D)var3).y, this.getZ() - ((Vec3D)var3).z);
        this.playSound(this.getHitGroundSoundEvent(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
        this.inGround = true;
        this.shakeTime = 7;
        this.setCritArrow(false);
        this.setPierceLevel((byte)0);
        this.setSoundEvent(SoundEffects.ARROW_HIT);
        this.resetPiercedEntities();
    }

    protected void hitBlockEnchantmentEffects(WorldServer var02, MovingObjectPositionBlock var1, ItemStack var2) {
        EntityLiving var4;
        Vec3D var3 = var1.getBlockPos().clampLocationWithin(var1.getLocation());
        Entity entity = this.getOwner();
        EnchantmentManager.onHitBlock(var02, var2, entity instanceof EntityLiving ? (var4 = (EntityLiving)entity) : null, this, null, var3, var02.getBlockState(var1.getBlockPos()), var0 -> {
            this.firedFromWeapon = null;
        });
    }

    @Override
    public ItemStack getWeaponItem() {
        return this.firedFromWeapon;
    }

    protected SoundEffect getDefaultHitGroundSoundEvent() {
        return SoundEffects.ARROW_HIT;
    }

    protected final SoundEffect getHitGroundSoundEvent() {
        return this.soundEvent;
    }

    protected void doPostHurtEffects(EntityLiving var0) {
    }

    @Nullable
    protected MovingObjectPositionEntity findHitEntity(Vec3D var0, Vec3D var1) {
        return ProjectileHelper.getEntityHitResult(this.level(), this, var0, var1, this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), this::canHitEntity);
    }

    @Override
    protected boolean canHitEntity(Entity var0) {
        return super.canHitEntity(var0) && (this.piercingIgnoreEntityIds == null || !this.piercingIgnoreEntityIds.contains(var0.getId()));
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putShort("life", (short)this.life);
        if (this.lastState != null) {
            var0.put("inBlockState", GameProfileSerializer.writeBlockState(this.lastState));
        }
        var0.putByte("shake", (byte)this.shakeTime);
        var0.putBoolean("inGround", this.inGround);
        var0.putByte("pickup", (byte)this.pickup.ordinal());
        var0.putDouble("damage", this.baseDamage);
        var0.putBoolean("crit", this.isCritArrow());
        var0.putByte("PierceLevel", this.getPierceLevel());
        var0.putString("SoundEvent", BuiltInRegistries.SOUND_EVENT.getKey(this.soundEvent).toString());
        var0.put("item", this.pickupItemStack.save(this.registryAccess()));
        if (this.firedFromWeapon != null) {
            var0.put("weapon", this.firedFromWeapon.save(this.registryAccess(), new NBTTagCompound()));
        }
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.life = var0.getShort("life");
        if (var0.contains("inBlockState", 10)) {
            this.lastState = GameProfileSerializer.readBlockState(this.level().holderLookup(Registries.BLOCK), var0.getCompound("inBlockState"));
        }
        this.shakeTime = var0.getByte("shake") & 0xFF;
        this.inGround = var0.getBoolean("inGround");
        if (var0.contains("damage", 99)) {
            this.baseDamage = var0.getDouble("damage");
        }
        this.pickup = PickupStatus.byOrdinal(var0.getByte("pickup"));
        this.setCritArrow(var0.getBoolean("crit"));
        this.setPierceLevel(var0.getByte("PierceLevel"));
        if (var0.contains("SoundEvent", 8)) {
            this.soundEvent = BuiltInRegistries.SOUND_EVENT.getOptional(MinecraftKey.parse(var0.getString("SoundEvent"))).orElse(this.getDefaultHitGroundSoundEvent());
        }
        if (var0.contains("item", 10)) {
            this.setPickupItemStack(ItemStack.parse(this.registryAccess(), var0.getCompound("item")).orElse(this.getDefaultPickupItem()));
        } else {
            this.setPickupItemStack(this.getDefaultPickupItem());
        }
        this.firedFromWeapon = var0.contains("weapon", 10) ? (ItemStack)ItemStack.parse(this.registryAccess(), var0.getCompound("weapon")).orElse(null) : null;
    }

    @Override
    public void setOwner(@Nullable Entity var0) {
        PickupStatus pickupStatus;
        super.setOwner(var0);
        Entity entity = var0;
        int n2 = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EntityHuman.class, OminousItemSpawner.class}, (Object)entity, n2)) {
                case 0: {
                    EntityHuman var3 = (EntityHuman)entity;
                    if (this.pickup != PickupStatus.DISALLOWED) {
                        n2 = 1;
                        continue block4;
                    }
                    pickupStatus = PickupStatus.ALLOWED;
                    break block4;
                }
                case 1: {
                    OminousItemSpawner var4 = (OminousItemSpawner)entity;
                    pickupStatus = PickupStatus.DISALLOWED;
                    break block4;
                }
                default: {
                    pickupStatus = this.pickup;
                    break block4;
                }
            }
            break;
        }
        this.pickup = pickupStatus;
    }

    @Override
    public void playerTouch(EntityHuman var0) {
        if (this.level().isClientSide || !this.inGround && !this.isNoPhysics() || this.shakeTime > 0) {
            return;
        }
        if (this.tryPickup(var0)) {
            var0.take(this, 1);
            this.discard();
        }
    }

    protected boolean tryPickup(EntityHuman var0) {
        return switch (this.pickup.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> false;
            case 1 -> var0.getInventory().add(this.getPickupItem());
            case 2 -> var0.hasInfiniteMaterials();
        };
    }

    protected ItemStack getPickupItem() {
        return this.pickupItemStack.copy();
    }

    protected abstract ItemStack getDefaultPickupItem();

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public ItemStack getPickupItemStackOrigin() {
        return this.pickupItemStack;
    }

    public void setBaseDamage(double var0) {
        this.baseDamage = var0;
    }

    public double getBaseDamage() {
        return this.baseDamage;
    }

    @Override
    public boolean isAttackable() {
        return this.getType().is(TagsEntity.REDIRECTABLE_PROJECTILE);
    }

    public void setCritArrow(boolean var0) {
        this.setFlag(1, var0);
    }

    public void setPierceLevel(byte var0) {
        this.entityData.set(PIERCE_LEVEL, var0);
    }

    private void setFlag(int var0, boolean var1) {
        byte var2 = this.entityData.get(ID_FLAGS);
        if (var1) {
            this.entityData.set(ID_FLAGS, (byte)(var2 | var0));
        } else {
            this.entityData.set(ID_FLAGS, (byte)(var2 & ~var0));
        }
    }

    protected void setPickupItemStack(ItemStack var0) {
        this.pickupItemStack = !var0.isEmpty() ? var0 : this.getDefaultPickupItem();
    }

    public boolean isCritArrow() {
        byte var0 = this.entityData.get(ID_FLAGS);
        return (var0 & 1) != 0;
    }

    public boolean shotFromCrossbow() {
        return this.firedFromWeapon != null && this.firedFromWeapon.is(Items.CROSSBOW);
    }

    public byte getPierceLevel() {
        return this.entityData.get(PIERCE_LEVEL);
    }

    public void setBaseDamageFromMob(float var0) {
        this.setBaseDamage((double)(var0 * 2.0f) + this.random.triangle((double)this.level().getDifficulty().getId() * 0.11, 0.57425));
    }

    protected float getWaterInertia() {
        return 0.6f;
    }

    public void setNoPhysics(boolean var0) {
        this.noPhysics = var0;
        this.setFlag(2, var0);
    }

    public boolean isNoPhysics() {
        if (!this.level().isClientSide) {
            return this.noPhysics;
        }
        return (this.entityData.get(ID_FLAGS) & 2) != 0;
    }

    @Override
    public boolean isPickable() {
        return super.isPickable() && !this.inGround;
    }

    @Override
    public SlotAccess getSlot(int var0) {
        if (var0 == 0) {
            return SlotAccess.of(this::getPickupItemStackOrigin, this::setPickupItemStack);
        }
        return super.getSlot(var0);
    }

    public static final class PickupStatus
    extends Enum<PickupStatus> {
        public static final /* enum */ PickupStatus DISALLOWED = new PickupStatus();
        public static final /* enum */ PickupStatus ALLOWED = new PickupStatus();
        public static final /* enum */ PickupStatus CREATIVE_ONLY = new PickupStatus();
        private static final /* synthetic */ PickupStatus[] d;

        public static PickupStatus[] values() {
            return (PickupStatus[])d.clone();
        }

        public static PickupStatus valueOf(String var0) {
            return Enum.valueOf(PickupStatus.class, var0);
        }

        public static PickupStatus byOrdinal(int var0) {
            if (var0 < 0 || var0 > PickupStatus.values().length) {
                var0 = 0;
            }
            return PickupStatus.values()[var0];
        }

        private static /* synthetic */ PickupStatus[] a() {
            return new PickupStatus[]{DISALLOWED, ALLOWED, CREATIVE_ONLY};
        }

        static {
            d = PickupStatus.a();
        }
    }
}

