/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;

public class EntityFireworks
extends IProjectile
implements ItemSupplier {
    public static final DataWatcherObject<ItemStack> DATA_ID_FIREWORKS_ITEM = DataWatcher.defineId(EntityFireworks.class, DataWatcherRegistry.ITEM_STACK);
    private static final DataWatcherObject<OptionalInt> DATA_ATTACHED_TO_TARGET = DataWatcher.defineId(EntityFireworks.class, DataWatcherRegistry.OPTIONAL_UNSIGNED_INT);
    public static final DataWatcherObject<Boolean> DATA_SHOT_AT_ANGLE = DataWatcher.defineId(EntityFireworks.class, DataWatcherRegistry.BOOLEAN);
    public int life;
    public int lifetime;
    @Nullable
    public EntityLiving attachedToEntity;

    public EntityFireworks(EntityTypes<? extends EntityFireworks> var0, World var1) {
        super((EntityTypes<? extends IProjectile>)var0, var1);
    }

    public EntityFireworks(World var0, double var1, double var3, double var5, ItemStack var7) {
        super((EntityTypes<? extends IProjectile>)EntityTypes.FIREWORK_ROCKET, var0);
        this.life = 0;
        this.setPos(var1, var3, var5);
        this.entityData.set(DATA_ID_FIREWORKS_ITEM, var7.copy());
        int var8 = 1;
        Fireworks var9 = var7.get(DataComponents.FIREWORKS);
        if (var9 != null) {
            var8 += var9.flightDuration();
        }
        this.setDeltaMovement(this.random.triangle(0.0, 0.002297), 0.05, this.random.triangle(0.0, 0.002297));
        this.lifetime = 10 * var8 + this.random.nextInt(6) + this.random.nextInt(7);
    }

    public EntityFireworks(World var0, @Nullable Entity var1, double var2, double var4, double var6, ItemStack var8) {
        this(var0, var2, var4, var6, var8);
        this.setOwner(var1);
    }

    public EntityFireworks(World var0, ItemStack var1, EntityLiving var2) {
        this(var0, var2, var2.getX(), var2.getY(), var2.getZ(), var1);
        this.entityData.set(DATA_ATTACHED_TO_TARGET, OptionalInt.of(var2.getId()));
        this.attachedToEntity = var2;
    }

    public EntityFireworks(World var0, ItemStack var1, double var2, double var4, double var6, boolean var8) {
        this(var0, var2, var4, var6, var1);
        this.entityData.set(DATA_SHOT_AT_ANGLE, var8);
    }

    public EntityFireworks(World var0, ItemStack var1, Entity var2, double var3, double var5, double var7, boolean var9) {
        this(var0, var1, var3, var5, var7, var9);
        this.setOwner(var2);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        var0.define(DATA_ID_FIREWORKS_ITEM, EntityFireworks.getDefaultItem());
        var0.define(DATA_ATTACHED_TO_TARGET, OptionalInt.empty());
        var0.define(DATA_SHOT_AT_ANGLE, false);
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double var0) {
        return var0 < 4096.0 && !this.isAttachedToEntity();
    }

    @Override
    public boolean shouldRender(double var0, double var2, double var4) {
        return super.shouldRender(var0, var2, var4) && !this.isAttachedToEntity();
    }

    @Override
    public void tick() {
        Object var02;
        super.tick();
        if (this.isAttachedToEntity()) {
            if (this.attachedToEntity == null) {
                this.entityData.get(DATA_ATTACHED_TO_TARGET).ifPresent(var0 -> {
                    Entity var1 = this.level().getEntity(var0);
                    if (var1 instanceof EntityLiving) {
                        this.attachedToEntity = (EntityLiving)var1;
                    }
                });
            }
            if (this.attachedToEntity != null) {
                if (this.attachedToEntity.isFallFlying()) {
                    Vec3D var1 = this.attachedToEntity.getLookAngle();
                    double var2 = 1.5;
                    double var4 = 0.1;
                    Vec3D var6 = this.attachedToEntity.getDeltaMovement();
                    this.attachedToEntity.setDeltaMovement(var6.add(var1.x * 0.1 + (var1.x * 1.5 - var6.x) * 0.5, var1.y * 0.1 + (var1.y * 1.5 - var6.y) * 0.5, var1.z * 0.1 + (var1.z * 1.5 - var6.z) * 0.5));
                    var02 = this.attachedToEntity.getHandHoldingItemAngle(Items.FIREWORK_ROCKET);
                } else {
                    var02 = Vec3D.ZERO;
                }
                this.setPos(this.attachedToEntity.getX() + ((Vec3D)var02).x, this.attachedToEntity.getY() + ((Vec3D)var02).y, this.attachedToEntity.getZ() + ((Vec3D)var02).z);
                this.setDeltaMovement(this.attachedToEntity.getDeltaMovement());
            }
        } else {
            if (!this.isShotAtAngle()) {
                double var03 = this.horizontalCollision ? 1.0 : 1.15;
                this.setDeltaMovement(this.getDeltaMovement().multiply(var03, 1.0, var03).add(0.0, 0.04, 0.0));
            }
            var02 = this.getDeltaMovement();
            this.move(EnumMoveType.SELF, (Vec3D)var02);
            this.setDeltaMovement((Vec3D)var02);
        }
        var02 = ProjectileHelper.getHitResultOnMoveVector(this, this::canHitEntity);
        if (!this.noPhysics) {
            this.hitTargetOrDeflectSelf((MovingObjectPosition)var02);
            this.hasImpulse = true;
        }
        this.updateRotation();
        if (this.life == 0 && !this.isSilent()) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEffects.FIREWORK_ROCKET_LAUNCH, SoundCategory.AMBIENT, 3.0f, 1.0f);
        }
        ++this.life;
        if (this.level().isClientSide && this.life % 2 < 2) {
            this.level().addParticle(Particles.FIREWORK, this.getX(), this.getY(), this.getZ(), this.random.nextGaussian() * 0.05, -this.getDeltaMovement().y * 0.5, this.random.nextGaussian() * 0.05);
        }
        if (!this.level().isClientSide && this.life > this.lifetime) {
            this.explode();
        }
    }

    private void explode() {
        this.level().broadcastEntityEvent(this, (byte)17);
        this.gameEvent(GameEvent.EXPLODE, this.getOwner());
        this.dealExplosionDamage();
        this.discard();
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity var0) {
        super.onHitEntity(var0);
        if (this.level().isClientSide) {
            return;
        }
        this.explode();
    }

    @Override
    protected void onHitBlock(MovingObjectPositionBlock var0) {
        BlockPosition var1 = new BlockPosition(var0.getBlockPos());
        this.level().getBlockState(var1).entityInside(this.level(), var1, this);
        if (!this.level().isClientSide() && this.hasExplosion()) {
            this.explode();
        }
        super.onHitBlock(var0);
    }

    private boolean hasExplosion() {
        return !this.getExplosions().isEmpty();
    }

    private void dealExplosionDamage() {
        float var0 = 0.0f;
        List<FireworkExplosion> var1 = this.getExplosions();
        if (!var1.isEmpty()) {
            var0 = 5.0f + (float)(var1.size() * 2);
        }
        if (var0 > 0.0f) {
            if (this.attachedToEntity != null) {
                this.attachedToEntity.hurt(this.damageSources().fireworks(this, this.getOwner()), 5.0f + (float)(var1.size() * 2));
            }
            double var2 = 5.0;
            Vec3D var4 = this.position();
            List<EntityLiving> var5 = this.level().getEntitiesOfClass(EntityLiving.class, this.getBoundingBox().inflate(5.0));
            for (EntityLiving var7 : var5) {
                if (var7 == this.attachedToEntity || this.distanceToSqr(var7) > 25.0) continue;
                boolean var8 = false;
                for (int var9 = 0; var9 < 2; ++var9) {
                    Vec3D var10 = new Vec3D(var7.getX(), var7.getY(0.5 * (double)var9), var7.getZ());
                    MovingObjectPositionBlock var11 = this.level().clip(new RayTrace(var4, var10, RayTrace.BlockCollisionOption.COLLIDER, RayTrace.FluidCollisionOption.NONE, this));
                    if (((MovingObjectPosition)var11).getType() != MovingObjectPosition.EnumMovingObjectType.MISS) continue;
                    var8 = true;
                    break;
                }
                if (!var8) continue;
                float var9 = var0 * (float)Math.sqrt((5.0 - (double)this.distanceTo(var7)) / 5.0);
                var7.hurt(this.damageSources().fireworks(this, this.getOwner()), var9);
            }
        }
    }

    private boolean isAttachedToEntity() {
        return this.entityData.get(DATA_ATTACHED_TO_TARGET).isPresent();
    }

    public boolean isShotAtAngle() {
        return this.entityData.get(DATA_SHOT_AT_ANGLE);
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 17 && this.level().isClientSide) {
            Vec3D var1 = this.getDeltaMovement();
            this.level().createFireworks(this.getX(), this.getY(), this.getZ(), var1.x, var1.y, var1.z, this.getExplosions());
        }
        super.handleEntityEvent(var0);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("Life", this.life);
        var0.putInt("LifeTime", this.lifetime);
        var0.put("FireworksItem", this.getItem().save(this.registryAccess()));
        var0.putBoolean("ShotAtAngle", this.entityData.get(DATA_SHOT_AT_ANGLE));
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.life = var0.getInt("Life");
        this.lifetime = var0.getInt("LifeTime");
        if (var0.contains("FireworksItem", 10)) {
            this.entityData.set(DATA_ID_FIREWORKS_ITEM, ItemStack.parse(this.registryAccess(), var0.getCompound("FireworksItem")).orElseGet(EntityFireworks::getDefaultItem));
        } else {
            this.entityData.set(DATA_ID_FIREWORKS_ITEM, EntityFireworks.getDefaultItem());
        }
        if (var0.contains("ShotAtAngle")) {
            this.entityData.set(DATA_SHOT_AT_ANGLE, var0.getBoolean("ShotAtAngle"));
        }
    }

    private List<FireworkExplosion> getExplosions() {
        ItemStack var0 = this.entityData.get(DATA_ID_FIREWORKS_ITEM);
        Fireworks var1 = var0.get(DataComponents.FIREWORKS);
        return var1 != null ? var1.explosions() : List.of();
    }

    @Override
    public ItemStack getItem() {
        return this.entityData.get(DATA_ID_FIREWORKS_ITEM);
    }

    @Override
    public boolean isAttackable() {
        return false;
    }

    private static ItemStack getDefaultItem() {
        return new ItemStack(Items.FIREWORK_ROCKET);
    }

    @Override
    public DoubleDoubleImmutablePair calculateHorizontalHurtKnockbackDirection(EntityLiving var0, DamageSource var1) {
        double var2 = var0.position().x - this.position().x;
        double var4 = var0.position().z - this.position().z;
        return DoubleDoubleImmutablePair.of((double)var2, (double)var4);
    }
}

