/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;

public class EntityShulkerBullet
extends IProjectile {
    private static final double SPEED = 0.15;
    @Nullable
    private Entity finalTarget;
    @Nullable
    private EnumDirection currentMoveDirection;
    private int flightSteps;
    private double targetDeltaX;
    private double targetDeltaY;
    private double targetDeltaZ;
    @Nullable
    private UUID targetId;

    public EntityShulkerBullet(EntityTypes<? extends EntityShulkerBullet> var0, World var1) {
        super((EntityTypes<? extends IProjectile>)var0, var1);
        this.noPhysics = true;
    }

    public EntityShulkerBullet(World var0, EntityLiving var1, Entity var2, EnumDirection.EnumAxis var3) {
        this((EntityTypes<? extends EntityShulkerBullet>)EntityTypes.SHULKER_BULLET, var0);
        this.setOwner(var1);
        Vec3D var4 = var1.getBoundingBox().getCenter();
        this.moveTo(var4.x, var4.y, var4.z, this.getYRot(), this.getXRot());
        this.finalTarget = var2;
        this.currentMoveDirection = EnumDirection.UP;
        this.selectNextMoveDirection(var3);
    }

    @Override
    public SoundCategory getSoundSource() {
        return SoundCategory.HOSTILE;
    }

    @Override
    protected void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        if (this.finalTarget != null) {
            var0.putUUID("Target", this.finalTarget.getUUID());
        }
        if (this.currentMoveDirection != null) {
            var0.putInt("Dir", this.currentMoveDirection.get3DDataValue());
        }
        var0.putInt("Steps", this.flightSteps);
        var0.putDouble("TXD", this.targetDeltaX);
        var0.putDouble("TYD", this.targetDeltaY);
        var0.putDouble("TZD", this.targetDeltaZ);
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.flightSteps = var0.getInt("Steps");
        this.targetDeltaX = var0.getDouble("TXD");
        this.targetDeltaY = var0.getDouble("TYD");
        this.targetDeltaZ = var0.getDouble("TZD");
        if (var0.contains("Dir", 99)) {
            this.currentMoveDirection = EnumDirection.from3DDataValue(var0.getInt("Dir"));
        }
        if (var0.hasUUID("Target")) {
            this.targetId = var0.getUUID("Target");
        }
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
    }

    @Nullable
    private EnumDirection getMoveDirection() {
        return this.currentMoveDirection;
    }

    private void setMoveDirection(@Nullable EnumDirection var0) {
        this.currentMoveDirection = var0;
    }

    private void selectNextMoveDirection(@Nullable EnumDirection.EnumAxis var0) {
        BlockPosition var1;
        double var2 = 0.5;
        if (this.finalTarget == null) {
            var1 = this.blockPosition().below();
        } else {
            var2 = (double)this.finalTarget.getBbHeight() * 0.5;
            var1 = BlockPosition.containing(this.finalTarget.getX(), this.finalTarget.getY() + var2, this.finalTarget.getZ());
        }
        double var4 = (double)var1.getX() + 0.5;
        double var6 = (double)var1.getY() + var2;
        double var8 = (double)var1.getZ() + 0.5;
        EnumDirection var10 = null;
        if (!var1.closerToCenterThan(this.position(), 2.0)) {
            BlockPosition var11 = this.blockPosition();
            ArrayList var12 = Lists.newArrayList();
            if (var0 != EnumDirection.EnumAxis.X) {
                if (var11.getX() < var1.getX() && this.level().isEmptyBlock(var11.east())) {
                    var12.add(EnumDirection.EAST);
                } else if (var11.getX() > var1.getX() && this.level().isEmptyBlock(var11.west())) {
                    var12.add(EnumDirection.WEST);
                }
            }
            if (var0 != EnumDirection.EnumAxis.Y) {
                if (var11.getY() < var1.getY() && this.level().isEmptyBlock(var11.above())) {
                    var12.add(EnumDirection.UP);
                } else if (var11.getY() > var1.getY() && this.level().isEmptyBlock(var11.below())) {
                    var12.add(EnumDirection.DOWN);
                }
            }
            if (var0 != EnumDirection.EnumAxis.Z) {
                if (var11.getZ() < var1.getZ() && this.level().isEmptyBlock(var11.south())) {
                    var12.add(EnumDirection.SOUTH);
                } else if (var11.getZ() > var1.getZ() && this.level().isEmptyBlock(var11.north())) {
                    var12.add(EnumDirection.NORTH);
                }
            }
            var10 = EnumDirection.getRandom(this.random);
            if (var12.isEmpty()) {
                for (int var13 = 5; !this.level().isEmptyBlock(var11.relative(var10)) && var13 > 0; --var13) {
                    var10 = EnumDirection.getRandom(this.random);
                }
            } else {
                var10 = (EnumDirection)var12.get(this.random.nextInt(var12.size()));
            }
            var4 = this.getX() + (double)var10.getStepX();
            var6 = this.getY() + (double)var10.getStepY();
            var8 = this.getZ() + (double)var10.getStepZ();
        }
        this.setMoveDirection(var10);
        double var11 = var4 - this.getX();
        double var13 = var6 - this.getY();
        double var15 = var8 - this.getZ();
        double var17 = Math.sqrt(var11 * var11 + var13 * var13 + var15 * var15);
        if (var17 == 0.0) {
            this.targetDeltaX = 0.0;
            this.targetDeltaY = 0.0;
            this.targetDeltaZ = 0.0;
        } else {
            this.targetDeltaX = var11 / var17 * 0.15;
            this.targetDeltaY = var13 / var17 * 0.15;
            this.targetDeltaZ = var15 / var17 * 0.15;
        }
        this.hasImpulse = true;
        this.flightSteps = 10 + this.random.nextInt(5) * 10;
    }

    @Override
    public void checkDespawn() {
        if (this.level().getDifficulty() == EnumDifficulty.PEACEFUL) {
            this.discard();
        }
    }

    @Override
    protected double getDefaultGravity() {
        return 0.04;
    }

    @Override
    public void tick() {
        Object var0;
        super.tick();
        if (!this.level().isClientSide) {
            if (this.finalTarget == null && this.targetId != null) {
                this.finalTarget = ((WorldServer)this.level()).getEntity(this.targetId);
                if (this.finalTarget == null) {
                    this.targetId = null;
                }
            }
            if (!(this.finalTarget == null || !this.finalTarget.isAlive() || this.finalTarget instanceof EntityHuman && this.finalTarget.isSpectator())) {
                this.targetDeltaX = MathHelper.clamp(this.targetDeltaX * 1.025, -1.0, 1.0);
                this.targetDeltaY = MathHelper.clamp(this.targetDeltaY * 1.025, -1.0, 1.0);
                this.targetDeltaZ = MathHelper.clamp(this.targetDeltaZ * 1.025, -1.0, 1.0);
                var0 = this.getDeltaMovement();
                this.setDeltaMovement(((Vec3D)var0).add((this.targetDeltaX - ((Vec3D)var0).x) * 0.2, (this.targetDeltaY - ((Vec3D)var0).y) * 0.2, (this.targetDeltaZ - ((Vec3D)var0).z) * 0.2));
            } else {
                this.applyGravity();
            }
            var0 = ProjectileHelper.getHitResultOnMoveVector(this, this::canHitEntity);
            if (((MovingObjectPosition)var0).getType() != MovingObjectPosition.EnumMovingObjectType.MISS) {
                this.hitTargetOrDeflectSelf((MovingObjectPosition)var0);
            }
        }
        this.checkInsideBlocks();
        var0 = this.getDeltaMovement();
        this.setPos(this.getX() + ((Vec3D)var0).x, this.getY() + ((Vec3D)var0).y, this.getZ() + ((Vec3D)var0).z);
        ProjectileHelper.rotateTowardsMovement(this, 0.5f);
        if (this.level().isClientSide) {
            this.level().addParticle(Particles.END_ROD, this.getX() - ((Vec3D)var0).x, this.getY() - ((Vec3D)var0).y + 0.15, this.getZ() - ((Vec3D)var0).z, 0.0, 0.0, 0.0);
        } else if (this.finalTarget != null && !this.finalTarget.isRemoved()) {
            if (this.flightSteps > 0) {
                --this.flightSteps;
                if (this.flightSteps == 0) {
                    this.selectNextMoveDirection(this.currentMoveDirection == null ? null : this.currentMoveDirection.getAxis());
                }
            }
            if (this.currentMoveDirection != null) {
                BlockPosition var1 = this.blockPosition();
                EnumDirection.EnumAxis var2 = this.currentMoveDirection.getAxis();
                if (this.level().loadedAndEntityCanStandOn(var1.relative(this.currentMoveDirection), this)) {
                    this.selectNextMoveDirection(var2);
                } else {
                    BlockPosition var3 = this.finalTarget.blockPosition();
                    if (var2 == EnumDirection.EnumAxis.X && var1.getX() == var3.getX() || var2 == EnumDirection.EnumAxis.Z && var1.getZ() == var3.getZ() || var2 == EnumDirection.EnumAxis.Y && var1.getY() == var3.getY()) {
                        this.selectNextMoveDirection(var2);
                    }
                }
            }
        }
    }

    @Override
    protected boolean canHitEntity(Entity var0) {
        return super.canHitEntity(var0) && !var0.noPhysics;
    }

    @Override
    public boolean isOnFire() {
        return false;
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double var0) {
        return var0 < 16384.0;
    }

    @Override
    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity var0) {
        super.onHitEntity(var0);
        Entity var1 = var0.getEntity();
        Entity var2 = this.getOwner();
        EntityLiving var3 = var2 instanceof EntityLiving ? (EntityLiving)var2 : null;
        DamageSource var4 = this.damageSources().mobProjectile(this, var3);
        boolean var5 = var1.hurt(var4, 4.0f);
        if (var5) {
            Object var6;
            World world = this.level();
            if (world instanceof WorldServer) {
                var6 = (WorldServer)world;
                EnchantmentManager.doPostAttackEffects((WorldServer)var6, var1, var4);
            }
            if (var1 instanceof EntityLiving) {
                var6 = (EntityLiving)var1;
                ((EntityLiving)var6).addEffect(new MobEffect(MobEffects.LEVITATION, 200), (Entity)MoreObjects.firstNonNull((Object)var2, (Object)this));
            }
        }
    }

    @Override
    protected void onHitBlock(MovingObjectPositionBlock var0) {
        super.onHitBlock(var0);
        ((WorldServer)this.level()).sendParticles(Particles.EXPLOSION, this.getX(), this.getY(), this.getZ(), 2, 0.2, 0.2, 0.2, 0.0);
        this.playSound(SoundEffects.SHULKER_BULLET_HIT, 1.0f, 1.0f);
    }

    private void destroy() {
        this.discard();
        this.level().gameEvent(GameEvent.ENTITY_DAMAGE, this.position(), GameEvent.a.of(this));
    }

    @Override
    protected void onHit(MovingObjectPosition var0) {
        super.onHit(var0);
        this.destroy();
    }

    @Override
    public boolean isPickable() {
        return true;
    }

    @Override
    public boolean hurt(DamageSource var0, float var1) {
        if (!this.level().isClientSide) {
            this.playSound(SoundEffects.SHULKER_BULLET_HURT, 1.0f, 1.0f);
            ((WorldServer)this.level()).sendParticles(Particles.CRIT, this.getX(), this.getY(), this.getZ(), 15, 0.2, 0.2, 0.2, 0.0);
            this.destroy();
        }
        return true;
    }

    @Override
    public void recreateFromPacket(PacketPlayOutSpawnEntity var0) {
        super.recreateFromPacket(var0);
        double var1 = var0.getXa();
        double var3 = var0.getYa();
        double var5 = var0.getZa();
        this.setDeltaMovement(var1, var3, var5);
    }
}

