/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;

public class EntitySpectralArrow
extends EntityArrow {
    public int duration = 200;

    public EntitySpectralArrow(EntityTypes<? extends EntitySpectralArrow> var0, World var1) {
        super((EntityTypes<? extends EntityArrow>)var0, var1);
    }

    public EntitySpectralArrow(World var0, EntityLiving var1, ItemStack var2, @Nullable ItemStack var3) {
        super(EntityTypes.SPECTRAL_ARROW, var1, var0, var2, var3);
    }

    public EntitySpectralArrow(World var0, double var1, double var3, double var5, ItemStack var7, @Nullable ItemStack var8) {
        super(EntityTypes.SPECTRAL_ARROW, var1, var3, var5, var0, var7, var8);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide && !this.inGround) {
            this.level().addParticle(Particles.INSTANT_EFFECT, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void doPostHurtEffects(EntityLiving var0) {
        super.doPostHurtEffects(var0);
        MobEffect var1 = new MobEffect(MobEffects.GLOWING, this.duration, 0);
        var0.addEffect(var1, this.getEffectSource());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        if (var0.contains("Duration")) {
            this.duration = var0.getInt("Duration");
        }
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("Duration", this.duration);
    }

    @Override
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack(Items.SPECTRAL_ARROW);
    }
}

