/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.base.MoreObjects;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;

public abstract class IProjectile
extends Entity
implements TraceableEntity {
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private Entity cachedOwner;
    private boolean leftOwner;
    private boolean hasBeenShot;
    @Nullable
    private Entity lastDeflectedBy;

    IProjectile(EntityTypes<? extends IProjectile> var0, World var1) {
        super(var0, var1);
    }

    public void setOwner(@Nullable Entity var0) {
        if (var0 != null) {
            this.ownerUUID = var0.getUUID();
            this.cachedOwner = var0;
        }
    }

    @Override
    @Nullable
    public Entity getOwner() {
        World world;
        if (this.cachedOwner != null && !this.cachedOwner.isRemoved()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && (world = this.level()) instanceof WorldServer) {
            WorldServer var0 = (WorldServer)world;
            this.cachedOwner = var0.getEntity(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public Entity getEffectSource() {
        return (Entity)MoreObjects.firstNonNull((Object)this.getOwner(), (Object)this);
    }

    @Override
    protected void addAdditionalSaveData(NBTTagCompound var0) {
        if (this.ownerUUID != null) {
            var0.putUUID("Owner", this.ownerUUID);
        }
        if (this.leftOwner) {
            var0.putBoolean("LeftOwner", true);
        }
        var0.putBoolean("HasBeenShot", this.hasBeenShot);
    }

    protected boolean ownedBy(Entity var0) {
        return var0.getUUID().equals(this.ownerUUID);
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound var0) {
        if (var0.hasUUID("Owner")) {
            this.ownerUUID = var0.getUUID("Owner");
            this.cachedOwner = null;
        }
        this.leftOwner = var0.getBoolean("LeftOwner");
        this.hasBeenShot = var0.getBoolean("HasBeenShot");
    }

    @Override
    public void restoreFrom(Entity var0) {
        super.restoreFrom(var0);
        if (var0 instanceof IProjectile) {
            IProjectile var1 = (IProjectile)var0;
            this.cachedOwner = var1.cachedOwner;
        }
    }

    @Override
    public void tick() {
        if (!this.hasBeenShot) {
            this.gameEvent(GameEvent.PROJECTILE_SHOOT, this.getOwner());
            this.hasBeenShot = true;
        }
        if (!this.leftOwner) {
            this.leftOwner = this.checkLeftOwner();
        }
        super.tick();
    }

    private boolean checkLeftOwner() {
        Entity var02 = this.getOwner();
        if (var02 != null) {
            for (Entity var2 : this.level().getEntities(this, this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), var0 -> !var0.isSpectator() && var0.isPickable())) {
                if (var2.getRootVehicle() != var02.getRootVehicle()) continue;
                return false;
            }
        }
        return true;
    }

    public Vec3D getMovementToShoot(double var0, double var2, double var4, float var6, float var7) {
        return new Vec3D(var0, var2, var4).normalize().add(this.random.triangle(0.0, 0.0172275 * (double)var7), this.random.triangle(0.0, 0.0172275 * (double)var7), this.random.triangle(0.0, 0.0172275 * (double)var7)).scale(var6);
    }

    public void shoot(double var0, double var2, double var4, float var6, float var7) {
        Vec3D var8 = this.getMovementToShoot(var0, var2, var4, var6, var7);
        this.setDeltaMovement(var8);
        this.hasImpulse = true;
        double var9 = var8.horizontalDistance();
        this.setYRot((float)(MathHelper.atan2(var8.x, var8.z) * 57.2957763671875));
        this.setXRot((float)(MathHelper.atan2(var8.y, var9) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public void shootFromRotation(Entity var0, float var1, float var2, float var3, float var4, float var5) {
        float var6 = -MathHelper.sin(var2 * ((float)Math.PI / 180)) * MathHelper.cos(var1 * ((float)Math.PI / 180));
        float var7 = -MathHelper.sin((var1 + var3) * ((float)Math.PI / 180));
        float var8 = MathHelper.cos(var2 * ((float)Math.PI / 180)) * MathHelper.cos(var1 * ((float)Math.PI / 180));
        this.shoot(var6, var7, var8, var4, var5);
        Vec3D var9 = var0.getKnownMovement();
        this.setDeltaMovement(this.getDeltaMovement().add(var9.x, var0.onGround() ? 0.0 : var9.y, var9.z));
    }

    protected ProjectileDeflection hitTargetOrDeflectSelf(MovingObjectPosition var0) {
        MovingObjectPositionEntity var1;
        Entity var2;
        ProjectileDeflection var3;
        if (var0.getType() == MovingObjectPosition.EnumMovingObjectType.ENTITY && (var3 = (var2 = (var1 = (MovingObjectPositionEntity)var0).getEntity()).deflection(this)) != ProjectileDeflection.NONE) {
            if (var2 != this.lastDeflectedBy && this.deflect(var3, var2, this.getOwner(), false)) {
                this.lastDeflectedBy = var2;
            }
            return var3;
        }
        this.onHit(var0);
        return ProjectileDeflection.NONE;
    }

    public boolean deflect(ProjectileDeflection var0, @Nullable Entity var1, @Nullable Entity var2, boolean var3) {
        if (!this.level().isClientSide) {
            var0.deflect(this, var1, this.random);
            this.setOwner(var2);
            this.onDeflection(var1, var3);
        }
        return true;
    }

    protected void onDeflection(@Nullable Entity var0, boolean var1) {
    }

    protected void onHit(MovingObjectPosition var0) {
        MovingObjectPosition.EnumMovingObjectType var1 = var0.getType();
        if (var1 == MovingObjectPosition.EnumMovingObjectType.ENTITY) {
            MovingObjectPositionEntity var2 = (MovingObjectPositionEntity)var0;
            Entity var3 = var2.getEntity();
            if (var3.getType().is(TagsEntity.REDIRECTABLE_PROJECTILE) && var3 instanceof IProjectile) {
                IProjectile var4 = (IProjectile)var3;
                var4.deflect(ProjectileDeflection.AIM_DEFLECT, this.getOwner(), this.getOwner(), true);
            }
            this.onHitEntity(var2);
            this.level().gameEvent(GameEvent.PROJECTILE_LAND, var0.getLocation(), GameEvent.a.of(this, null));
        } else if (var1 == MovingObjectPosition.EnumMovingObjectType.BLOCK) {
            MovingObjectPositionBlock var2 = (MovingObjectPositionBlock)var0;
            this.onHitBlock(var2);
            BlockPosition var3 = var2.getBlockPos();
            this.level().gameEvent(GameEvent.PROJECTILE_LAND, var3, GameEvent.a.of(this, this.level().getBlockState(var3)));
        }
    }

    protected void onHitEntity(MovingObjectPositionEntity var0) {
    }

    protected void onHitBlock(MovingObjectPositionBlock var0) {
        IBlockData var1 = this.level().getBlockState(var0.getBlockPos());
        var1.onProjectileHit(this.level(), var1, var0, this);
    }

    @Override
    public void lerpMotion(double var0, double var2, double var4) {
        this.setDeltaMovement(var0, var2, var4);
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double var6 = Math.sqrt(var0 * var0 + var4 * var4);
            this.setXRot((float)(MathHelper.atan2(var2, var6) * 57.2957763671875));
            this.setYRot((float)(MathHelper.atan2(var0, var4) * 57.2957763671875));
            this.xRotO = this.getXRot();
            this.yRotO = this.getYRot();
            this.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
        }
    }

    protected boolean canHitEntity(Entity var0) {
        if (!var0.canBeHitByProjectile()) {
            return false;
        }
        Entity var1 = this.getOwner();
        return var1 == null || this.leftOwner || !var1.isPassengerOfSameVehicle(var0);
    }

    protected void updateRotation() {
        Vec3D var0 = this.getDeltaMovement();
        double var1 = var0.horizontalDistance();
        this.setXRot(IProjectile.lerpRotation(this.xRotO, (float)(MathHelper.atan2(var0.y, var1) * 57.2957763671875)));
        this.setYRot(IProjectile.lerpRotation(this.yRotO, (float)(MathHelper.atan2(var0.x, var0.z) * 57.2957763671875)));
    }

    protected static float lerpRotation(float var0, float var1) {
        while (var1 - var0 < -180.0f) {
            var0 -= 360.0f;
        }
        while (var1 - var0 >= 180.0f) {
            var0 += 360.0f;
        }
        return MathHelper.lerp(0.2f, var0, var1);
    }

    @Override
    public Packet<PacketListenerPlayOut> getAddEntityPacket(EntityTrackerEntry var0) {
        Entity var1 = this.getOwner();
        return new PacketPlayOutSpawnEntity((Entity)this, var0, var1 == null ? 0 : var1.getId());
    }

    @Override
    public void recreateFromPacket(PacketPlayOutSpawnEntity var0) {
        super.recreateFromPacket(var0);
        Entity var1 = this.level().getEntity(var0.getData());
        if (var1 != null) {
            this.setOwner(var1);
        }
    }

    @Override
    public boolean mayInteract(World var0, BlockPosition var1) {
        Entity var2 = this.getOwner();
        if (var2 instanceof EntityHuman) {
            return var2.mayInteract(var0, var1);
        }
        return var2 == null || var0.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
    }

    public boolean mayBreak(World var0) {
        return this.getType().is(TagsEntity.IMPACT_PROJECTILES) && var0.getGameRules().getBoolean(GameRules.RULE_PROJECTILESCANBREAKBLOCKS);
    }

    @Override
    public boolean isPickable() {
        return this.getType().is(TagsEntity.REDIRECTABLE_PROJECTILE);
    }

    @Override
    public float getPickRadius() {
        return this.isPickable() ? 1.0f : 0.0f;
    }

    public DoubleDoubleImmutablePair calculateHorizontalHurtKnockbackDirection(EntityLiving var0, DamageSource var1) {
        double var2 = this.getDeltaMovement().x;
        double var4 = this.getDeltaMovement().z;
        return DoubleDoubleImmutablePair.of((double)var2, (double)var4);
    }
}

