/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerProperties;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ContainerLectern
extends Container {
    private static final int DATA_COUNT = 1;
    private static final int SLOT_COUNT = 1;
    public static final int BUTTON_PREV_PAGE = 1;
    public static final int BUTTON_NEXT_PAGE = 2;
    public static final int BUTTON_TAKE_BOOK = 3;
    public static final int BUTTON_PAGE_JUMP_RANGE_START = 100;
    private final IInventory lectern;
    private final IContainerProperties lecternData;

    public ContainerLectern(int var0) {
        this(var0, new InventorySubcontainer(1), new ContainerProperties(1));
    }

    public ContainerLectern(int var0, IInventory var1, IContainerProperties var2) {
        super(Containers.LECTERN, var0);
        ContainerLectern.checkContainerSize(var1, 1);
        ContainerLectern.checkContainerDataCount(var2, 1);
        this.lectern = var1;
        this.lecternData = var2;
        this.addSlot(new Slot(var1, 0, 0, 0){

            @Override
            public void setChanged() {
                super.setChanged();
                ContainerLectern.this.slotsChanged(this.container);
            }
        });
        this.addDataSlots(var2);
    }

    @Override
    public boolean clickMenuButton(EntityHuman var0, int var1) {
        if (var1 >= 100) {
            int var2 = var1 - 100;
            this.setData(0, var2);
            return true;
        }
        switch (var1) {
            case 2: {
                int var2 = this.lecternData.get(0);
                this.setData(0, var2 + 1);
                return true;
            }
            case 1: {
                int var2 = this.lecternData.get(0);
                this.setData(0, var2 - 1);
                return true;
            }
            case 3: {
                if (!var0.mayBuild()) {
                    return false;
                }
                ItemStack var2 = this.lectern.removeItemNoUpdate(0);
                this.lectern.setChanged();
                if (!var0.getInventory().add(var2)) {
                    var0.drop(var2, false);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman var0, int var1) {
        return ItemStack.EMPTY;
    }

    @Override
    public void setData(int var0, int var1) {
        super.setData(var0, var1);
        this.broadcastChanges();
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return this.lectern.stillValid(var0);
    }

    public ItemStack getBook() {
        return this.lectern.getItem(0);
    }

    public int getPage() {
        return this.lecternData.get(0);
    }
}

