/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SlotShulkerBox;
import net.minecraft.world.item.ItemStack;

public class ContainerShulkerBox
extends Container {
    private static final int CONTAINER_SIZE = 27;
    private final IInventory container;

    public ContainerShulkerBox(int var0, PlayerInventory var1) {
        this(var0, var1, new InventorySubcontainer(27));
    }

    public ContainerShulkerBox(int var0, PlayerInventory var1, IInventory var2) {
        super(Containers.SHULKER_BOX, var0);
        int var6;
        int var5;
        ContainerShulkerBox.checkContainerSize(var2, 27);
        this.container = var2;
        var2.startOpen(var1.player);
        int var3 = 3;
        int var4 = 9;
        for (var5 = 0; var5 < 3; ++var5) {
            for (var6 = 0; var6 < 9; ++var6) {
                this.addSlot(new SlotShulkerBox(var2, var6 + var5 * 9, 8 + var6 * 18, 18 + var5 * 18));
            }
        }
        for (var5 = 0; var5 < 3; ++var5) {
            for (var6 = 0; var6 < 9; ++var6) {
                this.addSlot(new Slot(var1, var6 + var5 * 9 + 9, 8 + var6 * 18, 84 + var5 * 18));
            }
        }
        for (var5 = 0; var5 < 9; ++var5) {
            this.addSlot(new Slot(var1, var5, 8 + var5 * 18, 142));
        }
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return this.container.stillValid(var0);
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman var0, int var1) {
        ItemStack var2 = ItemStack.EMPTY;
        Slot var3 = (Slot)this.slots.get(var1);
        if (var3 != null && var3.hasItem()) {
            ItemStack var4 = var3.getItem();
            var2 = var4.copy();
            if (var1 < this.container.getContainerSize() ? !this.moveItemStackTo(var4, this.container.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(var4, 0, this.container.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (var4.isEmpty()) {
                var3.setByPlayer(ItemStack.EMPTY);
            } else {
                var3.setChanged();
            }
        }
        return var2;
    }

    @Override
    public void removed(EntityHuman var0) {
        super.removed(var0);
        this.container.stopOpen(var0);
    }
}

