/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerProperties;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.CrafterSlot;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.ICrafting;
import net.minecraft.world.inventory.InventoryCraftResult;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.inventory.NonInteractiveResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.CrafterBlock;

public class CrafterMenu
extends Container
implements ICrafting {
    protected static final int SLOT_COUNT = 9;
    private static final int INV_SLOT_START = 9;
    private static final int INV_SLOT_END = 36;
    private static final int USE_ROW_SLOT_START = 36;
    private static final int USE_ROW_SLOT_END = 45;
    private final InventoryCraftResult resultContainer = new InventoryCraftResult();
    private final IContainerProperties containerData;
    private final EntityHuman player;
    private final InventoryCrafting container;

    public CrafterMenu(int var0, PlayerInventory var1) {
        super(Containers.CRAFTER_3x3, var0);
        this.player = var1.player;
        this.containerData = new ContainerProperties(10);
        this.container = new TransientCraftingContainer(this, 3, 3);
        this.addSlots(var1);
    }

    public CrafterMenu(int var0, PlayerInventory var1, InventoryCrafting var2, IContainerProperties var3) {
        super(Containers.CRAFTER_3x3, var0);
        this.player = var1.player;
        this.containerData = var3;
        this.container = var2;
        CrafterMenu.checkContainerSize(var2, 9);
        var2.startOpen(var1.player);
        this.addSlots(var1);
        this.addSlotListener(this);
    }

    private void addSlots(PlayerInventory var0) {
        int var2;
        int var1;
        for (var1 = 0; var1 < 3; ++var1) {
            for (var2 = 0; var2 < 3; ++var2) {
                int var3 = var2 + var1 * 3;
                this.addSlot(new CrafterSlot(this.container, var3, 26 + var2 * 18, 17 + var1 * 18, this));
            }
        }
        for (var1 = 0; var1 < 3; ++var1) {
            for (var2 = 0; var2 < 9; ++var2) {
                this.addSlot(new Slot(var0, var2 + var1 * 9 + 9, 8 + var2 * 18, 84 + var1 * 18));
            }
        }
        for (var1 = 0; var1 < 9; ++var1) {
            this.addSlot(new Slot(var0, var1, 8 + var1 * 18, 142));
        }
        this.addSlot(new NonInteractiveResultSlot(this.resultContainer, 0, 134, 35));
        this.addDataSlots(this.containerData);
        this.refreshRecipeResult();
    }

    public void setSlotState(int var0, boolean var1) {
        CrafterSlot var2 = (CrafterSlot)this.getSlot(var0);
        this.containerData.set(var2.index, var1 ? 0 : 1);
        this.broadcastChanges();
    }

    public boolean isSlotDisabled(int var0) {
        if (var0 > -1 && var0 < 9) {
            return this.containerData.get(var0) == 1;
        }
        return false;
    }

    public boolean isPowered() {
        return this.containerData.get(9) == 1;
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman var0, int var1) {
        ItemStack var2 = ItemStack.EMPTY;
        Slot var3 = (Slot)this.slots.get(var1);
        if (var3 != null && var3.hasItem()) {
            ItemStack var4 = var3.getItem();
            var2 = var4.copy();
            if (var1 < 9 ? !this.moveItemStackTo(var4, 9, 45, true) : !this.moveItemStackTo(var4, 0, 9, false)) {
                return ItemStack.EMPTY;
            }
            if (var4.isEmpty()) {
                var3.set(ItemStack.EMPTY);
            } else {
                var3.setChanged();
            }
            if (var4.getCount() == var2.getCount()) {
                return ItemStack.EMPTY;
            }
            var3.onTake(var0, var4);
        }
        return var2;
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return this.container.stillValid(var0);
    }

    private void refreshRecipeResult() {
        EntityHuman entityHuman = this.player;
        if (entityHuman instanceof EntityPlayer) {
            EntityPlayer var0 = (EntityPlayer)entityHuman;
            World var1 = var0.level();
            CraftingInput var22 = this.container.asCraftInput();
            ItemStack var3 = CrafterBlock.getPotentialResults(var1, var22).map(var2 -> ((RecipeCrafting)var2.value()).assemble(var22, var1.registryAccess())).orElse(ItemStack.EMPTY);
            this.resultContainer.setItem(0, var3);
        }
    }

    public IInventory getContainer() {
        return this.container;
    }

    @Override
    public void slotChanged(Container var0, int var1, ItemStack var2) {
        this.refreshRecipeResult();
    }

    @Override
    public void dataChanged(Container var0, int var1, int var2) {
    }
}

