/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.IMerchant;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.item.trading.MerchantRecipeList;

public class InventoryMerchant
implements IInventory {
    private final IMerchant merchant;
    private final NonNullList<ItemStack> itemStacks = NonNullList.withSize(3, ItemStack.EMPTY);
    @Nullable
    private MerchantRecipe activeOffer;
    public int selectionHint;
    private int futureXp;

    public InventoryMerchant(IMerchant var0) {
        this.merchant = var0;
    }

    @Override
    public int getContainerSize() {
        return this.itemStacks.size();
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack var1 : this.itemStacks) {
            if (var1.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack getItem(int var0) {
        return this.itemStacks.get(var0);
    }

    @Override
    public ItemStack removeItem(int var0, int var1) {
        ItemStack var2 = this.itemStacks.get(var0);
        if (var0 == 2 && !var2.isEmpty()) {
            return ContainerUtil.removeItem(this.itemStacks, var0, var2.getCount());
        }
        ItemStack var3 = ContainerUtil.removeItem(this.itemStacks, var0, var1);
        if (!var3.isEmpty() && this.isPaymentSlot(var0)) {
            this.updateSellItem();
        }
        return var3;
    }

    private boolean isPaymentSlot(int var0) {
        return var0 == 0 || var0 == 1;
    }

    @Override
    public ItemStack removeItemNoUpdate(int var0) {
        return ContainerUtil.takeItem(this.itemStacks, var0);
    }

    @Override
    public void setItem(int var0, ItemStack var1) {
        this.itemStacks.set(var0, var1);
        var1.limitSize(this.getMaxStackSize(var1));
        if (this.isPaymentSlot(var0)) {
            this.updateSellItem();
        }
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return this.merchant.getTradingPlayer() == var0;
    }

    @Override
    public void setChanged() {
        this.updateSellItem();
    }

    public void updateSellItem() {
        ItemStack var1;
        ItemStack var0;
        this.activeOffer = null;
        if (this.itemStacks.get(0).isEmpty()) {
            var0 = this.itemStacks.get(1);
            var1 = ItemStack.EMPTY;
        } else {
            var0 = this.itemStacks.get(0);
            var1 = this.itemStacks.get(1);
        }
        if (var0.isEmpty()) {
            this.setItem(2, ItemStack.EMPTY);
            this.futureXp = 0;
            return;
        }
        MerchantRecipeList var2 = this.merchant.getOffers();
        if (!var2.isEmpty()) {
            MerchantRecipe var3 = var2.getRecipeFor(var0, var1, this.selectionHint);
            if (var3 == null || var3.isOutOfStock()) {
                this.activeOffer = var3;
                var3 = var2.getRecipeFor(var1, var0, this.selectionHint);
            }
            if (var3 != null && !var3.isOutOfStock()) {
                this.activeOffer = var3;
                this.setItem(2, var3.assemble());
                this.futureXp = var3.getXp();
            } else {
                this.setItem(2, ItemStack.EMPTY);
                this.futureXp = 0;
            }
        }
        this.merchant.notifyTradeUpdated(this.getItem(2));
    }

    @Nullable
    public MerchantRecipe getActiveOffer() {
        return this.activeOffer;
    }

    public void setSelectionHint(int var0) {
        this.selectionHint = var0;
        this.updateSellItem();
    }

    @Override
    public void clearContent() {
        this.itemStacks.clear();
    }

    public int getFutureXp() {
        return this.futureXp;
    }
}

