/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.world.item.ItemStack;

public class ItemCombinerMenuSlotDefinition {
    private final List<b> slots;
    private final b resultSlot;

    ItemCombinerMenuSlotDefinition(List<b> var0, b var1) {
        if (var0.isEmpty() || var1.equals(b.EMPTY)) {
            throw new IllegalArgumentException("Need to define both inputSlots and resultSlot");
        }
        this.slots = var0;
        this.resultSlot = var1;
    }

    public static a create() {
        return new a();
    }

    public boolean hasSlot(int var0) {
        return this.slots.size() >= var0;
    }

    public b getSlot(int var0) {
        return this.slots.get(var0);
    }

    public b getResultSlot() {
        return this.resultSlot;
    }

    public List<b> getSlots() {
        return this.slots;
    }

    public int getNumOfInputSlots() {
        return this.slots.size();
    }

    public int getResultSlotIndex() {
        return this.getNumOfInputSlots();
    }

    public List<Integer> getInputSlotIndexes() {
        return this.slots.stream().map(b::slotIndex).collect(Collectors.toList());
    }

    public record b(int slotIndex, int x, int y, Predicate<ItemStack> mayPlace) {
        static final b EMPTY = new b(0, 0, 0, var0 -> true);
    }

    public static class a {
        private final List<b> slots = new ArrayList<b>();
        private b resultSlot = b.EMPTY;

        public a withSlot(int var0, int var1, int var2, Predicate<ItemStack> var3) {
            this.slots.add(new b(var0, var1, var2, var3));
            return this;
        }

        public a withResultSlot(int var02, int var1, int var2) {
            this.resultSlot = new b(var02, var1, var2, var0 -> false);
            return this;
        }

        public ItemCombinerMenuSlotDefinition build() {
            return new ItemCombinerMenuSlotDefinition(this.slots, this.resultSlot);
        }
    }
}

