/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.base.Suppliers;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.INamable;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.phys.AxisAlignedBB;

public class ItemArmor
extends Item
implements Equipable {
    public static final IDispenseBehavior DISPENSE_ITEM_BEHAVIOR = new DispenseBehaviorItem(){

        @Override
        protected ItemStack execute(SourceBlock var0, ItemStack var1) {
            return ItemArmor.dispenseArmor(var0, var1) ? var1 : super.execute(var0, var1);
        }
    };
    protected final a type;
    protected final Holder<ArmorMaterial> material;
    private final Supplier<ItemAttributeModifiers> defaultModifiers;

    public static boolean dispenseArmor(SourceBlock var0, ItemStack var1) {
        BlockPosition var2 = var0.pos().relative(var0.state().getValue(BlockDispenser.FACING));
        List<Entity> var3 = var0.level().getEntitiesOfClass(EntityLiving.class, new AxisAlignedBB(var2), IEntitySelector.NO_SPECTATORS.and(new IEntitySelector.EntitySelectorEquipable(var1)));
        if (var3.isEmpty()) {
            return false;
        }
        EntityLiving var4 = (EntityLiving)var3.get(0);
        EnumItemSlot var5 = var4.getEquipmentSlotForItem(var1);
        ItemStack var6 = var1.split(1);
        var4.setItemSlot(var5, var6);
        if (var4 instanceof EntityInsentient) {
            ((EntityInsentient)var4).setDropChance(var5, 2.0f);
            ((EntityInsentient)var4).setPersistenceRequired();
        }
        return true;
    }

    public ItemArmor(Holder<ArmorMaterial> var0, a var1, Item.Info var2) {
        super(var2);
        this.material = var0;
        this.type = var1;
        BlockDispenser.registerBehavior(this, DISPENSE_ITEM_BEHAVIOR);
        this.defaultModifiers = Suppliers.memoize(() -> {
            int var2 = ((ArmorMaterial)var0.value()).getDefense(var1);
            float var3 = ((ArmorMaterial)var0.value()).toughness();
            ItemAttributeModifiers.a var4 = ItemAttributeModifiers.builder();
            EquipmentSlotGroup var5 = EquipmentSlotGroup.bySlot(var1.getSlot());
            MinecraftKey var6 = MinecraftKey.withDefaultNamespace("armor." + var1.getName());
            var4.add(GenericAttributes.ARMOR, new AttributeModifier(var6, var2, AttributeModifier.Operation.ADD_VALUE), var5);
            var4.add(GenericAttributes.ARMOR_TOUGHNESS, new AttributeModifier(var6, var3, AttributeModifier.Operation.ADD_VALUE), var5);
            float var7 = ((ArmorMaterial)var0.value()).knockbackResistance();
            if (var7 > 0.0f) {
                var4.add(GenericAttributes.KNOCKBACK_RESISTANCE, new AttributeModifier(var6, var7, AttributeModifier.Operation.ADD_VALUE), var5);
            }
            return var4.build();
        });
    }

    public a getType() {
        return this.type;
    }

    @Override
    public int getEnchantmentValue() {
        return this.material.value().enchantmentValue();
    }

    public Holder<ArmorMaterial> getMaterial() {
        return this.material;
    }

    @Override
    public boolean isValidRepairItem(ItemStack var0, ItemStack var1) {
        return this.material.value().repairIngredient().get().test(var1) || super.isValidRepairItem(var0, var1);
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        return this.swapWithEquipmentSlot(this, var0, var1, var2);
    }

    @Override
    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        return this.defaultModifiers.get();
    }

    public int getDefense() {
        return this.material.value().getDefense(this.type);
    }

    public float getToughness() {
        return this.material.value().toughness();
    }

    @Override
    public EnumItemSlot getEquipmentSlot() {
        return this.type.getSlot();
    }

    @Override
    public Holder<SoundEffect> getEquipSound() {
        return this.getMaterial().value().equipSound();
    }

    public static final class a
    extends Enum<a>
    implements INamable {
        public static final /* enum */ a HELMET = new a(EnumItemSlot.HEAD, 11, "helmet");
        public static final /* enum */ a CHESTPLATE = new a(EnumItemSlot.CHEST, 16, "chestplate");
        public static final /* enum */ a LEGGINGS = new a(EnumItemSlot.LEGS, 15, "leggings");
        public static final /* enum */ a BOOTS = new a(EnumItemSlot.FEET, 13, "boots");
        public static final /* enum */ a BODY = new a(EnumItemSlot.BODY, 16, "body");
        public static final Codec<a> CODEC;
        private final EnumItemSlot slot;
        private final String name;
        private final int durability;
        private static final /* synthetic */ a[] j;

        public static a[] values() {
            return (a[])j.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private a(EnumItemSlot var2, int var3, String var4) {
            this.slot = var2;
            this.name = var4;
            this.durability = var3;
        }

        public int getDurability(int var0) {
            return this.durability * var0;
        }

        public EnumItemSlot getSlot() {
            return this.slot;
        }

        public String getName() {
            return this.name;
        }

        public boolean hasTrims() {
            return this == HELMET || this == CHESTPLATE || this == LEGGINGS || this == BOOTS;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ a[] e() {
            return new a[]{HELMET, CHESTPLATE, LEGGINGS, BOOTS, BODY};
        }

        static {
            j = a.e();
            CODEC = INamable.fromValues(a::values);
        }
    }
}

