/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class ItemBlockWallable
extends ItemBlock {
    public final Block wallBlock;
    private final EnumDirection attachmentDirection;

    public ItemBlockWallable(Block var0, Block var1, Item.Info var2, EnumDirection var3) {
        super(var0, var2);
        this.wallBlock = var1;
        this.attachmentDirection = var3;
    }

    protected boolean canPlace(IWorldReader var0, IBlockData var1, BlockPosition var2) {
        return var1.canSurvive(var0, var2);
    }

    @Override
    @Nullable
    protected IBlockData getPlacementState(BlockActionContext var0) {
        IBlockData var1 = this.wallBlock.getStateForPlacement(var0);
        IBlockData var2 = null;
        World var3 = var0.getLevel();
        BlockPosition var4 = var0.getClickedPos();
        for (EnumDirection var8 : var0.getNearestLookingDirections()) {
            IBlockData var9;
            if (var8 == this.attachmentDirection.getOpposite()) continue;
            IBlockData iBlockData = var9 = var8 == this.attachmentDirection ? this.getBlock().getStateForPlacement(var0) : var1;
            if (var9 == null || !this.canPlace(var3, var9, var4)) continue;
            var2 = var9;
            break;
        }
        return var2 != null && var3.isUnobstructed(var2, var4, VoxelShapeCollision.empty()) ? var2 : null;
    }

    @Override
    public void registerBlocks(Map<Block, Item> var0, Item var1) {
        super.registerBlocks(var0, var1);
        var0.put(this.wallBlock, var1);
    }
}

