/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;

public class ItemChorusFruit
extends Item {
    public ItemChorusFruit(Item.Info var0) {
        super(var0);
    }

    @Override
    public ItemStack finishUsingItem(ItemStack var0, World var1, EntityLiving var2) {
        ItemStack var3 = super.finishUsingItem(var0, var1, var2);
        if (!var1.isClientSide) {
            for (int var4 = 0; var4 < 16; ++var4) {
                SoundCategory var12;
                SoundEffect var13;
                double var5 = var2.getX() + (var2.getRandom().nextDouble() - 0.5) * 16.0;
                double var7 = MathHelper.clamp(var2.getY() + (double)(var2.getRandom().nextInt(16) - 8), (double)var1.getMinBuildHeight(), (double)(var1.getMinBuildHeight() + ((WorldServer)var1).getLogicalHeight() - 1));
                double var9 = var2.getZ() + (var2.getRandom().nextDouble() - 0.5) * 16.0;
                if (var2.isPassenger()) {
                    var2.stopRiding();
                }
                Vec3D var11 = var2.position();
                if (!var2.randomTeleport(var5, var7, var9, true)) continue;
                var1.gameEvent(GameEvent.TELEPORT, var11, GameEvent.a.of(var2));
                if (var2 instanceof EntityFox) {
                    var13 = SoundEffects.FOX_TELEPORT;
                    var12 = SoundCategory.NEUTRAL;
                } else {
                    var13 = SoundEffects.CHORUS_FRUIT_TELEPORT;
                    var12 = SoundCategory.PLAYERS;
                }
                var1.playSound(null, var2.getX(), var2.getY(), var2.getZ(), var13, var12);
                var2.resetFallDistance();
                break;
            }
            if (var2 instanceof EntityHuman) {
                EntityHuman var4 = (EntityHuman)var2;
                var4.resetCurrentImpulseContext();
                var4.getCooldowns().addCooldown(this, 20);
            }
        }
        return var3;
    }
}

