/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;

public class ItemFireworks
extends Item
implements ProjectileItem {
    public static final byte[] CRAFTABLE_DURATIONS = new byte[]{1, 2, 3};
    public static final double ROCKET_PLACEMENT_OFFSET = 0.15;

    public ItemFireworks(Item.Info var0) {
        super(var0);
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        World var1 = var0.getLevel();
        if (!var1.isClientSide) {
            ItemStack var2 = var0.getItemInHand();
            Vec3D var3 = var0.getClickLocation();
            EnumDirection var4 = var0.getClickedFace();
            EntityFireworks var5 = new EntityFireworks(var1, var0.getPlayer(), var3.x + (double)var4.getStepX() * 0.15, var3.y + (double)var4.getStepY() * 0.15, var3.z + (double)var4.getStepZ() * 0.15, var2);
            var1.addFreshEntity(var5);
            var2.shrink(1);
        }
        return EnumInteractionResult.sidedSuccess(var1.isClientSide);
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        if (var1.isFallFlying()) {
            ItemStack var3 = var1.getItemInHand(var2);
            if (!var0.isClientSide) {
                EntityFireworks var4 = new EntityFireworks(var0, var3, var1);
                var0.addFreshEntity(var4);
                var3.consume(1, var1);
                var1.awardStat(StatisticList.ITEM_USED.get(this));
            }
            return InteractionResultWrapper.sidedSuccess(var1.getItemInHand(var2), var0.isClientSide());
        }
        return InteractionResultWrapper.pass(var1.getItemInHand(var2));
    }

    @Override
    public void appendHoverText(ItemStack var0, Item.b var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        Fireworks var4 = var0.get(DataComponents.FIREWORKS);
        if (var4 != null) {
            var4.addToTooltip(var1, var2::add, var3);
        }
    }

    @Override
    public IProjectile asProjectile(World var0, IPosition var1, ItemStack var2, EnumDirection var3) {
        return new EntityFireworks(var0, var2.copyWithCount(1), var1.x(), var1.y(), var1.z(), true);
    }

    @Override
    public ProjectileItem.a createDispenseConfig() {
        return ProjectileItem.a.builder().positionFunction(ItemFireworks::getEntityPokingOutOfBlockPos).uncertainty(1.0f).power(0.5f).overrideDispenseEvent(1004).build();
    }

    private static Vec3D getEntityPokingOutOfBlockPos(SourceBlock var0, EnumDirection var1) {
        return var0.center().add((double)var1.getStepX() * (0.5000099999997474 - (double)EntityTypes.FIREWORK_ROCKET.getWidth() / 2.0), (double)var1.getStepY() * (0.5000099999997474 - (double)EntityTypes.FIREWORK_ROCKET.getHeight() / 2.0) - (double)EntityTypes.FIREWORK_ROCKET.getHeight() / 2.0, (double)var1.getStepZ() * (0.5000099999997474 - (double)EntityTypes.FIREWORK_ROCKET.getWidth() / 2.0));
    }
}

