/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.decoration.EntityLeash;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;

public class ItemLeash
extends Item {
    public ItemLeash(Item.Info var0) {
        super(var0);
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        BlockPosition var2;
        World var1 = var0.getLevel();
        IBlockData var3 = var1.getBlockState(var2 = var0.getClickedPos());
        if (var3.is(TagsBlock.FENCES)) {
            EntityHuman var4 = var0.getPlayer();
            if (!var1.isClientSide && var4 != null) {
                ItemLeash.bindPlayerMobs(var4, var1, var2);
            }
            return EnumInteractionResult.sidedSuccess(var1.isClientSide);
        }
        return EnumInteractionResult.PASS;
    }

    public static EnumInteractionResult bindPlayerMobs(EntityHuman var0, World var12, BlockPosition var2) {
        EntityLeash var3 = null;
        List<Leashable> var4 = ItemLeash.leashableInArea(var12, var2, var1 -> var1.getLeashHolder() == var0);
        for (Leashable var6 : var4) {
            if (var3 == null) {
                var3 = EntityLeash.getOrCreateKnot(var12, var2);
                var3.playPlacementSound();
            }
            var6.setLeashedTo(var3, true);
        }
        if (!var4.isEmpty()) {
            var12.gameEvent(GameEvent.BLOCK_ATTACH, var2, GameEvent.a.of(var0));
            return EnumInteractionResult.SUCCESS;
        }
        return EnumInteractionResult.PASS;
    }

    public static List<Leashable> leashableInArea(World var0, BlockPosition var12, Predicate<Leashable> var2) {
        double var3 = 7.0;
        int var5 = var12.getX();
        int var6 = var12.getY();
        int var7 = var12.getZ();
        AxisAlignedBB var8 = new AxisAlignedBB((double)var5 - 7.0, (double)var6 - 7.0, (double)var7 - 7.0, (double)var5 + 7.0, (double)var6 + 7.0, (double)var7 + 7.0);
        return var0.getEntitiesOfClass(Entity.class, var8, var1 -> {
            Leashable var2;
            return var1 instanceof Leashable && var2.test(var2 = (Leashable)((Object)var1));
        }).stream().map(Leashable.class::cast).toList();
    }
}

