/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;

public class ItemMinecart
extends Item {
    private static final IDispenseBehavior DISPENSE_ITEM_BEHAVIOR = new DispenseBehaviorItem(){
        private final DispenseBehaviorItem defaultDispenseItemBehavior = new DispenseBehaviorItem();

        @Override
        public ItemStack execute(SourceBlock var0, ItemStack var1) {
            Object var16;
            double var14;
            BlockPropertyTrackPosition var13;
            EnumDirection var2 = var0.state().getValue(BlockDispenser.FACING);
            WorldServer var3 = var0.level();
            Vec3D var4 = var0.center();
            double var5 = var4.x() + (double)var2.getStepX() * 1.125;
            double var7 = Math.floor(var4.y()) + (double)var2.getStepY();
            double var9 = var4.z() + (double)var2.getStepZ() * 1.125;
            BlockPosition var11 = var0.pos().relative(var2);
            IBlockData var12 = var3.getBlockState(var11);
            BlockPropertyTrackPosition blockPropertyTrackPosition = var13 = var12.getBlock() instanceof BlockMinecartTrackAbstract ? var12.getValue(((BlockMinecartTrackAbstract)var12.getBlock()).getShapeProperty()) : BlockPropertyTrackPosition.NORTH_SOUTH;
            if (var12.is(TagsBlock.RAILS)) {
                var14 = var13.isAscending() ? 0.6 : 0.1;
            } else if (var12.isAir() && var3.getBlockState(var11.below()).is(TagsBlock.RAILS)) {
                BlockPropertyTrackPosition var17;
                var16 = var3.getBlockState(var11.below());
                BlockPropertyTrackPosition blockPropertyTrackPosition2 = var17 = ((BlockBase.BlockData)var16).getBlock() instanceof BlockMinecartTrackAbstract ? ((IBlockDataHolder)var16).getValue(((BlockMinecartTrackAbstract)((BlockBase.BlockData)var16).getBlock()).getShapeProperty()) : BlockPropertyTrackPosition.NORTH_SOUTH;
                var14 = var2 == EnumDirection.DOWN || !var17.isAscending() ? -0.9 : -0.4;
            } else {
                return this.defaultDispenseItemBehavior.dispense(var0, var1);
            }
            var16 = EntityMinecartAbstract.createMinecart(var3, var5, var7 + var14, var9, ((ItemMinecart)var1.getItem()).type, var1, null);
            var3.addFreshEntity((Entity)var16);
            var1.shrink(1);
            return var1;
        }

        @Override
        protected void playSound(SourceBlock var0) {
            var0.level().levelEvent(1000, var0.pos(), 0);
        }
    };
    final EntityMinecartAbstract.EnumMinecartType type;

    public ItemMinecart(EntityMinecartAbstract.EnumMinecartType var0, Item.Info var1) {
        super(var1);
        this.type = var0;
        BlockDispenser.registerBehavior(this, DISPENSE_ITEM_BEHAVIOR);
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        BlockPosition var2;
        World var1 = var0.getLevel();
        IBlockData var3 = var1.getBlockState(var2 = var0.getClickedPos());
        if (!var3.is(TagsBlock.RAILS)) {
            return EnumInteractionResult.FAIL;
        }
        ItemStack var4 = var0.getItemInHand();
        if (var1 instanceof WorldServer) {
            WorldServer var5 = (WorldServer)var1;
            BlockPropertyTrackPosition var6 = var3.getBlock() instanceof BlockMinecartTrackAbstract ? var3.getValue(((BlockMinecartTrackAbstract)var3.getBlock()).getShapeProperty()) : BlockPropertyTrackPosition.NORTH_SOUTH;
            double var7 = 0.0;
            if (var6.isAscending()) {
                var7 = 0.5;
            }
            EntityMinecartAbstract var9 = EntityMinecartAbstract.createMinecart(var5, (double)var2.getX() + 0.5, (double)var2.getY() + 0.0625 + var7, (double)var2.getZ() + 0.5, this.type, var4, var0.getPlayer());
            var5.addFreshEntity(var9);
            var5.gameEvent(GameEvent.ENTITY_PLACE, var2, GameEvent.a.of(var0.getPlayer(), var5.getBlockState(var2.below())));
        }
        var4.shrink(1);
        return EnumInteractionResult.sidedSuccess(var1.isClientSide);
    }
}

