/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;

public class ItemPotion
extends Item {
    private static final int DRINK_DURATION = 32;

    public ItemPotion(Item.Info var0) {
        super(var0);
    }

    @Override
    public ItemStack getDefaultInstance() {
        ItemStack var0 = super.getDefaultInstance();
        var0.set(DataComponents.POTION_CONTENTS, new PotionContents(Potions.WATER));
        return var0;
    }

    @Override
    public ItemStack finishUsingItem(ItemStack var0, World var1, EntityLiving var22) {
        EntityHuman var3;
        EntityHuman entityHuman = var3 = var22 instanceof EntityHuman ? (EntityHuman)var22 : null;
        if (var3 instanceof EntityPlayer) {
            CriterionTriggers.CONSUME_ITEM.trigger((EntityPlayer)var3, var0);
        }
        if (!var1.isClientSide) {
            PotionContents var4 = var0.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
            var4.forEachEffect(var2 -> {
                if (var2.getEffect().value().isInstantenous()) {
                    var2.getEffect().value().applyInstantenousEffect(var3, var3, var22, var2.getAmplifier(), 1.0);
                } else {
                    var22.addEffect((MobEffect)var2);
                }
            });
        }
        if (var3 != null) {
            var3.awardStat(StatisticList.ITEM_USED.get(this));
            var0.consume(1, var3);
        }
        if (var3 == null || !var3.hasInfiniteMaterials()) {
            if (var0.isEmpty()) {
                return new ItemStack(Items.GLASS_BOTTLE);
            }
            if (var3 != null) {
                var3.getInventory().add(new ItemStack(Items.GLASS_BOTTLE));
            }
        }
        var22.gameEvent(GameEvent.DRINK);
        return var0;
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        World var1 = var0.getLevel();
        BlockPosition var2 = var0.getClickedPos();
        EntityHuman var3 = var0.getPlayer();
        ItemStack var4 = var0.getItemInHand();
        PotionContents var5 = var4.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
        IBlockData var6 = var1.getBlockState(var2);
        if (var0.getClickedFace() != EnumDirection.DOWN && var6.is(TagsBlock.CONVERTABLE_TO_MUD) && var5.is(Potions.WATER)) {
            var1.playSound(null, var2, SoundEffects.GENERIC_SPLASH, SoundCategory.BLOCKS, 1.0f, 1.0f);
            var3.setItemInHand(var0.getHand(), ItemLiquidUtil.createFilledResult(var4, var3, new ItemStack(Items.GLASS_BOTTLE)));
            var3.awardStat(StatisticList.ITEM_USED.get(var4.getItem()));
            if (!var1.isClientSide) {
                WorldServer var7 = (WorldServer)var1;
                for (int var8 = 0; var8 < 5; ++var8) {
                    var7.sendParticles(Particles.SPLASH, (double)var2.getX() + var1.random.nextDouble(), var2.getY() + 1, (double)var2.getZ() + var1.random.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0);
                }
            }
            var1.playSound(null, var2, SoundEffects.BOTTLE_EMPTY, SoundCategory.BLOCKS, 1.0f, 1.0f);
            var1.gameEvent(null, GameEvent.FLUID_PLACE, var2);
            var1.setBlockAndUpdate(var2, Blocks.MUD.defaultBlockState());
            return EnumInteractionResult.sidedSuccess(var1.isClientSide);
        }
        return EnumInteractionResult.PASS;
    }

    @Override
    public int getUseDuration(ItemStack var0, EntityLiving var1) {
        return 32;
    }

    @Override
    public EnumAnimation getUseAnimation(ItemStack var0) {
        return EnumAnimation.DRINK;
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        return ItemLiquidUtil.startUsingInstantly(var0, var1, var2);
    }

    @Override
    public String getDescriptionId(ItemStack var0) {
        return PotionRegistry.getName(var0.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY).potion(), this.getDescriptionId() + ".effect.");
    }

    @Override
    public void appendHoverText(ItemStack var0, Item.b var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        PotionContents var4 = var0.get(DataComponents.POTION_CONTENTS);
        if (var4 == null) {
            return;
        }
        var4.addPotionTooltip(var2::add, 1.0f, var1.tickRate());
    }
}

