/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.UtilColor;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.level.World;

public class ItemWrittenBook
extends Item {
    public ItemWrittenBook(Item.Info var0) {
        super(var0);
    }

    @Override
    public IChatBaseComponent getName(ItemStack var0) {
        String var2;
        WrittenBookContent var1 = var0.get(DataComponents.WRITTEN_BOOK_CONTENT);
        if (var1 != null && !UtilColor.isBlank(var2 = var1.title().raw())) {
            return IChatBaseComponent.literal(var2);
        }
        return super.getName(var0);
    }

    @Override
    public void appendHoverText(ItemStack var0, Item.b var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        WrittenBookContent var4 = var0.get(DataComponents.WRITTEN_BOOK_CONTENT);
        if (var4 != null) {
            if (!UtilColor.isBlank(var4.author())) {
                var2.add(IChatBaseComponent.translatable("book.byAuthor", var4.author()).withStyle(EnumChatFormat.GRAY));
            }
            var2.add(IChatBaseComponent.translatable("book.generation." + var4.generation()).withStyle(EnumChatFormat.GRAY));
        }
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        var1.openItemGui(var3, var2);
        var1.awardStat(StatisticList.ITEM_USED.get(this));
        return InteractionResultWrapper.sidedSuccess(var3, var0.isClientSide());
    }

    public static boolean resolveBookComponents(ItemStack var0, CommandListenerWrapper var1, @Nullable EntityHuman var2) {
        WrittenBookContent var3 = var0.get(DataComponents.WRITTEN_BOOK_CONTENT);
        if (var3 != null && !var3.resolved()) {
            WrittenBookContent var4 = var3.resolve(var1, var2);
            if (var4 != null) {
                var0.set(DataComponents.WRITTEN_BOOK_CONTENT, var4);
                return true;
            }
            var0.set(DataComponents.WRITTEN_BOOK_CONTENT, var3.markResolved());
        }
        return false;
    }
}

