/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;

public class JukeboxSongPlayer {
    public static final int PLAY_EVENT_INTERVAL_TICKS = 20;
    private long ticksSinceSongStarted;
    @Nullable
    public Holder<JukeboxSong> song;
    private final BlockPosition blockPos;
    private final a onSongChanged;

    public JukeboxSongPlayer(a var0, BlockPosition var1) {
        this.onSongChanged = var0;
        this.blockPos = var1;
    }

    public boolean isPlaying() {
        return this.song != null;
    }

    @Nullable
    public JukeboxSong getSong() {
        if (this.song == null) {
            return null;
        }
        return this.song.value();
    }

    public long getTicksSinceSongStarted() {
        return this.ticksSinceSongStarted;
    }

    public void setSongWithoutPlaying(Holder<JukeboxSong> var0, long var1) {
        if (var0.value().hasFinished(var1)) {
            return;
        }
        this.song = var0;
        this.ticksSinceSongStarted = var1;
    }

    public void play(GeneratorAccess var0, Holder<JukeboxSong> var1) {
        this.song = var1;
        this.ticksSinceSongStarted = 0L;
        int var2 = var0.registryAccess().registryOrThrow(Registries.JUKEBOX_SONG).getId(this.song.value());
        var0.levelEvent(null, 1010, this.blockPos, var2);
        this.onSongChanged.notifyChange();
    }

    public void stop(GeneratorAccess var0, @Nullable IBlockData var1) {
        if (this.song == null) {
            return;
        }
        this.song = null;
        this.ticksSinceSongStarted = 0L;
        var0.gameEvent(GameEvent.JUKEBOX_STOP_PLAY, this.blockPos, GameEvent.a.of(var1));
        var0.levelEvent(1011, this.blockPos, 0);
        this.onSongChanged.notifyChange();
    }

    public void tick(GeneratorAccess var0, @Nullable IBlockData var1) {
        if (this.song == null) {
            return;
        }
        if (this.song.value().hasFinished(this.ticksSinceSongStarted)) {
            this.stop(var0, var1);
            return;
        }
        if (this.shouldEmitJukeboxPlayingEvent()) {
            var0.gameEvent(GameEvent.JUKEBOX_PLAY, this.blockPos, GameEvent.a.of(var1));
            JukeboxSongPlayer.spawnMusicParticles(var0, this.blockPos);
        }
        ++this.ticksSinceSongStarted;
    }

    private boolean shouldEmitJukeboxPlayingEvent() {
        return this.ticksSinceSongStarted % 20L == 0L;
    }

    private static void spawnMusicParticles(GeneratorAccess var0, BlockPosition var1) {
        if (var0 instanceof WorldServer) {
            WorldServer var2 = (WorldServer)var0;
            Vec3D var3 = Vec3D.atBottomCenterOf(var1).add(0.0, 1.2f, 0.0);
            float var4 = (float)var0.getRandom().nextInt(4) / 24.0f;
            var2.sendParticles(Particles.NOTE, var3.x(), var3.y(), var3.z(), 0, var4, 0.0, 0.0, 1.0);
        }
    }

    @FunctionalInterface
    public static interface a {
        public void notifyChange();
    }
}

