/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.MathHelper;

public interface LevelBasedValue {
    public static final Codec<LevelBasedValue> DISPATCH_CODEC = BuiltInRegistries.ENCHANTMENT_LEVEL_BASED_VALUE_TYPE.byNameCodec().dispatch(LevelBasedValue::codec, var0 -> var0);
    public static final Codec<LevelBasedValue> CODEC = Codec.either(b.CODEC, DISPATCH_CODEC).xmap(var02 -> (LevelBasedValue)var02.map(var0 -> var0, var0 -> var0), var0 -> {
        Either either;
        if (var0 instanceof b) {
            b var1 = (b)var0;
            either = Either.left((Object)var1);
        } else {
            either = Either.right((Object)var0);
        }
        return either;
    });

    public static MapCodec<? extends LevelBasedValue> bootstrap(IRegistry<MapCodec<? extends LevelBasedValue>> var0) {
        IRegistry.register(var0, "clamped", a.CODEC);
        IRegistry.register(var0, "fraction", c.CODEC);
        IRegistry.register(var0, "levels_squared", d.CODEC);
        IRegistry.register(var0, "linear", e.CODEC);
        return IRegistry.register(var0, "lookup", f.CODEC);
    }

    public static b constant(float var0) {
        return new b(var0);
    }

    public static e perLevel(float var0, float var1) {
        return new e(var0, var1);
    }

    public static e perLevel(float var0) {
        return LevelBasedValue.perLevel(var0, var0);
    }

    public static f lookup(List<Float> var0, LevelBasedValue var1) {
        return new f(var0, var1);
    }

    public float calculate(int var1);

    public MapCodec<? extends LevelBasedValue> codec();

    public record a(LevelBasedValue value, float min, float max) implements LevelBasedValue
    {
        public static final MapCodec<a> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)CODEC.fieldOf("value").forGetter(a::value), (App)Codec.FLOAT.fieldOf("min").forGetter(a::min), (App)Codec.FLOAT.fieldOf("max").forGetter(a::max)).apply((Applicative)var0, a::new)).validate(var0 -> {
            if (var0.max <= var0.min) {
                return DataResult.error(() -> "Max must be larger than min, min: " + var0.min + ", max: " + var0.max);
            }
            return DataResult.success((Object)var0);
        });

        @Override
        public float calculate(int var0) {
            return MathHelper.clamp(this.value.calculate(var0), this.min, this.max);
        }

        public MapCodec<a> codec() {
            return CODEC;
        }
    }

    public record c(LevelBasedValue numerator, LevelBasedValue denominator) implements LevelBasedValue
    {
        public static final MapCodec<c> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)CODEC.fieldOf("numerator").forGetter(c::numerator), (App)CODEC.fieldOf("denominator").forGetter(c::denominator)).apply((Applicative)var0, c::new));

        @Override
        public float calculate(int var0) {
            float var1 = this.denominator.calculate(var0);
            if (var1 == 0.0f) {
                return 0.0f;
            }
            return this.numerator.calculate(var0) / var1;
        }

        public MapCodec<c> codec() {
            return CODEC;
        }
    }

    public record d(float added) implements LevelBasedValue
    {
        public static final MapCodec<d> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.FLOAT.fieldOf("added").forGetter(d::added)).apply((Applicative)var0, d::new));

        @Override
        public float calculate(int var0) {
            return (float)MathHelper.square(var0) + this.added;
        }

        public MapCodec<d> codec() {
            return CODEC;
        }
    }

    public record e(float base, float perLevelAboveFirst) implements LevelBasedValue
    {
        public static final MapCodec<e> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.FLOAT.fieldOf("base").forGetter(e::base), (App)Codec.FLOAT.fieldOf("per_level_above_first").forGetter(e::perLevelAboveFirst)).apply((Applicative)var0, e::new));

        @Override
        public float calculate(int var0) {
            return this.base + this.perLevelAboveFirst * (float)(var0 - 1);
        }

        public MapCodec<e> codec() {
            return CODEC;
        }
    }

    public record f(List<Float> values, LevelBasedValue fallback) implements LevelBasedValue
    {
        public static final MapCodec<f> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.FLOAT.listOf().fieldOf("values").forGetter(f::values), (App)CODEC.fieldOf("fallback").forGetter(f::fallback)).apply((Applicative)var0, f::new));

        @Override
        public float calculate(int var0) {
            return var0 <= this.values.size() ? this.values.get(var0 - 1).floatValue() : this.fallback.calculate(var0);
        }

        public MapCodec<f> codec() {
            return CODEC;
        }
    }

    public record b(float value) implements LevelBasedValue
    {
        public static final Codec<b> CODEC = Codec.FLOAT.xmap(b::new, b::value);
        public static final MapCodec<b> TYPED_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.FLOAT.fieldOf("value").forGetter(b::value)).apply((Applicative)var0, b::new));

        @Override
        public float calculate(int var0) {
            return this.value;
        }

        public MapCodec<b> codec() {
            return TYPED_CODEC;
        }
    }
}

