/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3D;

public record ApplyMobEffect(HolderSet<MobEffectList> toApply, LevelBasedValue minDuration, LevelBasedValue maxDuration, LevelBasedValue minAmplifier, LevelBasedValue maxAmplifier) implements EnchantmentEntityEffect
{
    public static final MapCodec<ApplyMobEffect> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)RegistryCodecs.homogeneousList(Registries.MOB_EFFECT).fieldOf("to_apply").forGetter(ApplyMobEffect::toApply), (App)LevelBasedValue.CODEC.fieldOf("min_duration").forGetter(ApplyMobEffect::minDuration), (App)LevelBasedValue.CODEC.fieldOf("max_duration").forGetter(ApplyMobEffect::maxDuration), (App)LevelBasedValue.CODEC.fieldOf("min_amplifier").forGetter(ApplyMobEffect::minAmplifier), (App)LevelBasedValue.CODEC.fieldOf("max_amplifier").forGetter(ApplyMobEffect::maxAmplifier)).apply((Applicative)var0, ApplyMobEffect::new));

    @Override
    public void apply(WorldServer var0, int var1, EnchantedItemInUse var2, Entity var3, Vec3D var4) {
        EntityLiving var5;
        RandomSource var6;
        Optional<Holder<MobEffectList>> var7;
        if (var3 instanceof EntityLiving && (var7 = this.toApply.getRandomElement(var6 = (var5 = (EntityLiving)var3).getRandom())).isPresent()) {
            int var8 = Math.round(MathHelper.randomBetween(var6, this.minDuration.calculate(var1), this.maxDuration.calculate(var1)) * 20.0f);
            int var9 = Math.max(0, Math.round(MathHelper.randomBetween(var6, this.minAmplifier.calculate(var1), this.maxAmplifier.calculate(var1))));
            var5.addEffect(new MobEffect(var7.get(), var8, var9));
        }
    }

    public MapCodec<ApplyMobEffect> codec() {
        return CODEC;
    }
}

