/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.INamable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.phys.Vec3D;

public record EnchantmentAttributeEffect(MinecraftKey id, Holder<AttributeBase> attribute, LevelBasedValue amount, AttributeModifier.Operation operation) implements EnchantmentLocationBasedEffect
{
    public static final MapCodec<EnchantmentAttributeEffect> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)MinecraftKey.CODEC.fieldOf("id").forGetter(EnchantmentAttributeEffect::id), (App)AttributeBase.CODEC.fieldOf("attribute").forGetter(EnchantmentAttributeEffect::attribute), (App)LevelBasedValue.CODEC.fieldOf("amount").forGetter(EnchantmentAttributeEffect::amount), (App)AttributeModifier.Operation.CODEC.fieldOf("operation").forGetter(EnchantmentAttributeEffect::operation)).apply((Applicative)var0, EnchantmentAttributeEffect::new));

    private MinecraftKey idForSlot(INamable var0) {
        return this.id.withSuffix("/" + var0.getSerializedName());
    }

    public AttributeModifier getModifier(int var0, INamable var1) {
        return new AttributeModifier(this.idForSlot(var1), this.amount().calculate(var0), this.operation());
    }

    @Override
    public void onChangedBlock(WorldServer var0, int var1, EnchantedItemInUse var2, Entity var3, Vec3D var4, boolean var5) {
        if (var5 && var3 instanceof EntityLiving) {
            EntityLiving var6 = (EntityLiving)var3;
            var6.getAttributes().addTransientAttributeModifiers((Multimap<Holder<AttributeBase>, AttributeModifier>)this.makeAttributeMap(var1, var2.inSlot()));
        }
    }

    @Override
    public void onDeactivated(EnchantedItemInUse var0, Entity var1, Vec3D var2, int var3) {
        if (var1 instanceof EntityLiving) {
            EntityLiving var4 = (EntityLiving)var1;
            var4.getAttributes().removeAttributeModifiers((Multimap<Holder<AttributeBase>, AttributeModifier>)this.makeAttributeMap(var3, var0.inSlot()));
        }
    }

    private HashMultimap<Holder<AttributeBase>, AttributeModifier> makeAttributeMap(int var0, EnumItemSlot var1) {
        HashMultimap var2 = HashMultimap.create();
        var2.put(this.attribute, (Object)this.getModifier(var0, var1));
        return var2;
    }

    public MapCodec<EnchantmentAttributeEffect> codec() {
        return CODEC;
    }
}

