/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProvider;
import net.minecraft.world.phys.Vec3D;

public record ReplaceBlock(BaseBlockPosition offset, Optional<BlockPredicate> predicate, WorldGenFeatureStateProvider blockState, Optional<Holder<GameEvent>> triggerGameEvent) implements EnchantmentEntityEffect
{
    public static final MapCodec<ReplaceBlock> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)BaseBlockPosition.CODEC.optionalFieldOf("offset", (Object)BaseBlockPosition.ZERO).forGetter(ReplaceBlock::offset), (App)BlockPredicate.CODEC.optionalFieldOf("predicate").forGetter(ReplaceBlock::predicate), (App)WorldGenFeatureStateProvider.CODEC.fieldOf("block_state").forGetter(ReplaceBlock::blockState), (App)GameEvent.CODEC.optionalFieldOf("trigger_game_event").forGetter(ReplaceBlock::triggerGameEvent)).apply((Applicative)var0, ReplaceBlock::new));

    @Override
    public void apply(WorldServer var0, int var1, EnchantedItemInUse var22, Entity var32, Vec3D var4) {
        BlockPosition var5 = BlockPosition.containing(var4).offset(this.offset);
        if (this.predicate.map(var2 -> var2.test(var0, var5)).orElse(true).booleanValue() && var0.setBlockAndUpdate(var5, this.blockState.getState(var32.getRandom(), var5))) {
            this.triggerGameEvent.ifPresent(var3 -> var0.gameEvent(var32, (Holder<GameEvent>)var3, var5));
        }
    }

    public MapCodec<ReplaceBlock> codec() {
        return CODEC;
    }
}

