/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;

public record SummonEntityEffect(HolderSet<EntityTypes<?>> entityTypes, boolean joinTeam) implements EnchantmentEntityEffect
{
    public static final MapCodec<SummonEntityEffect> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)RegistryCodecs.homogeneousList(Registries.ENTITY_TYPE).fieldOf("entity").forGetter(SummonEntityEffect::entityTypes), (App)Codec.BOOL.optionalFieldOf("join_team", (Object)false).forGetter(SummonEntityEffect::joinTeam)).apply((Applicative)var0, SummonEntityEffect::new));

    @Override
    public void apply(WorldServer var0, int var1, EnchantedItemInUse var2, Entity var3, Vec3D var4) {
        BlockPosition var5 = BlockPosition.containing(var4);
        if (!World.isInSpawnableBounds(var5)) {
            return;
        }
        Optional<Holder<EntityTypes<?>>> var6 = this.entityTypes().getRandomElement(var0.getRandom());
        if (var6.isEmpty()) {
            return;
        }
        Object var7 = var6.get().value().spawn(var0, var5, EnumMobSpawn.TRIGGERED);
        if (var7 == null) {
            return;
        }
        if (var7 instanceof EntityLightning) {
            EntityLightning var8 = (EntityLightning)var7;
            EntityLiving entityLiving = var2.owner();
            if (entityLiving instanceof EntityPlayer) {
                EntityPlayer var9 = (EntityPlayer)entityLiving;
                var8.setCause(var9);
            }
        }
        if (this.joinTeam && var3.getTeam() != null) {
            var0.getScoreboard().addPlayerToTeam(((Entity)var7).getScoreboardName(), var3.getTeam());
        }
        ((Entity)var7).moveTo(var4.x, var4.y, var4.z, ((Entity)var7).getYRot(), ((Entity)var7).getXRot());
    }

    public MapCodec<SummonEntityEffect> codec() {
        return CODEC;
    }
}

