/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.providers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.WeightedRandomEnchant;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;

public record EnchantmentsByCost(HolderSet<Enchantment> enchantments, IntProvider cost) implements EnchantmentProvider
{
    public static final MapCodec<EnchantmentsByCost> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)RegistryCodecs.homogeneousList(Registries.ENCHANTMENT).fieldOf("enchantments").forGetter(EnchantmentsByCost::enchantments), (App)IntProvider.CODEC.fieldOf("cost").forGetter(EnchantmentsByCost::cost)).apply((Applicative)var0, EnchantmentsByCost::new));

    @Override
    public void enchant(ItemStack var0, ItemEnchantments.a var1, RandomSource var2, DifficultyDamageScaler var3) {
        List<WeightedRandomEnchant> var4 = EnchantmentManager.selectEnchantment(var2, var0, this.cost.sample(var2), this.enchantments.stream());
        for (WeightedRandomEnchant var6 : var4) {
            var1.upgrade(var6.enchantment, var6.level);
        }
    }

    public MapCodec<EnchantmentsByCost> codec() {
        return CODEC;
    }
}

