/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3D;

public class ExplosionDamageCalculator {
    public Optional<Float> getBlockExplosionResistance(Explosion var0, IBlockAccess var1, BlockPosition var2, IBlockData var3, Fluid var4) {
        if (var3.isAir() && var4.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Float.valueOf(Math.max(var3.getBlock().getExplosionResistance(), var4.getExplosionResistance())));
    }

    public boolean shouldBlockExplode(Explosion var0, IBlockAccess var1, BlockPosition var2, IBlockData var3, float var4) {
        return true;
    }

    public boolean shouldDamageEntity(Explosion var0, Entity var1) {
        return true;
    }

    public float getKnockbackMultiplier(Entity var0) {
        return 1.0f;
    }

    public float getEntityDamageAmount(Explosion var0, Entity var1) {
        float var2 = var0.radius() * 2.0f;
        Vec3D var3 = var0.center();
        double var4 = Math.sqrt(var1.distanceToSqr(var3)) / (double)var2;
        double var6 = (1.0 - var4) * (double)Explosion.getSeenPercent(var3, var1);
        return (float)((var6 * var6 + var6) / 2.0 * 7.0 * (double)var2 + 1.0);
    }
}

