/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicLike;
import java.util.Comparator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import org.slf4j.Logger;

public class GameRules {
    public static final int DEFAULT_RANDOM_TICK_SPEED = 3;
    static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<GameRuleKey<?>, GameRuleDefinition<?>> GAME_RULE_TYPES = Maps.newTreeMap(Comparator.comparing(var0 -> var0.id));
    public static final GameRuleKey<GameRuleBoolean> RULE_DOFIRETICK = GameRules.register("doFireTick", GameRuleCategory.UPDATES, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_MOBGRIEFING = GameRules.register("mobGriefing", GameRuleCategory.MOBS, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_KEEPINVENTORY = GameRules.register("keepInventory", GameRuleCategory.PLAYER, GameRuleBoolean.create(false));
    public static final GameRuleKey<GameRuleBoolean> RULE_DOMOBSPAWNING = GameRules.register("doMobSpawning", GameRuleCategory.SPAWNING, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_DOMOBLOOT = GameRules.register("doMobLoot", GameRuleCategory.DROPS, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_PROJECTILESCANBREAKBLOCKS = GameRules.register("projectilesCanBreakBlocks", GameRuleCategory.DROPS, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_DOBLOCKDROPS = GameRules.register("doTileDrops", GameRuleCategory.DROPS, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_DOENTITYDROPS = GameRules.register("doEntityDrops", GameRuleCategory.DROPS, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_COMMANDBLOCKOUTPUT = GameRules.register("commandBlockOutput", GameRuleCategory.CHAT, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_NATURAL_REGENERATION = GameRules.register("naturalRegeneration", GameRuleCategory.PLAYER, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_DAYLIGHT = GameRules.register("doDaylightCycle", GameRuleCategory.UPDATES, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_LOGADMINCOMMANDS = GameRules.register("logAdminCommands", GameRuleCategory.CHAT, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_SHOWDEATHMESSAGES = GameRules.register("showDeathMessages", GameRuleCategory.CHAT, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleInt> RULE_RANDOMTICKING = GameRules.register("randomTickSpeed", GameRuleCategory.UPDATES, GameRuleInt.create(3));
    public static final GameRuleKey<GameRuleBoolean> RULE_SENDCOMMANDFEEDBACK = GameRules.register("sendCommandFeedback", GameRuleCategory.CHAT, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_REDUCEDDEBUGINFO = GameRules.register("reducedDebugInfo", GameRuleCategory.MISC, GameRuleBoolean.create(false, (var0, var1) -> {
        byte var2 = var1.get() ? (byte)22 : (byte)23;
        for (EntityPlayer var4 : var0.getPlayerList().getPlayers()) {
            var4.connection.send(new PacketPlayOutEntityStatus(var4, var2));
        }
    }));
    public static final GameRuleKey<GameRuleBoolean> RULE_SPECTATORSGENERATECHUNKS = GameRules.register("spectatorsGenerateChunks", GameRuleCategory.PLAYER, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleInt> RULE_SPAWN_RADIUS = GameRules.register("spawnRadius", GameRuleCategory.PLAYER, GameRuleInt.create(10));
    public static final GameRuleKey<GameRuleBoolean> RULE_DISABLE_ELYTRA_MOVEMENT_CHECK = GameRules.register("disableElytraMovementCheck", GameRuleCategory.PLAYER, GameRuleBoolean.create(false));
    public static final GameRuleKey<GameRuleInt> RULE_MAX_ENTITY_CRAMMING = GameRules.register("maxEntityCramming", GameRuleCategory.MOBS, GameRuleInt.create(24));
    public static final GameRuleKey<GameRuleBoolean> RULE_WEATHER_CYCLE = GameRules.register("doWeatherCycle", GameRuleCategory.UPDATES, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_LIMITED_CRAFTING = GameRules.register("doLimitedCrafting", GameRuleCategory.PLAYER, GameRuleBoolean.create(false, (var0, var1) -> {
        for (EntityPlayer var3 : var0.getPlayerList().getPlayers()) {
            var3.connection.send(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.LIMITED_CRAFTING, var1.get() ? 1.0f : 0.0f));
        }
    }));
    public static final GameRuleKey<GameRuleInt> RULE_MAX_COMMAND_CHAIN_LENGTH = GameRules.register("maxCommandChainLength", GameRuleCategory.MISC, GameRuleInt.create(65536));
    public static final GameRuleKey<GameRuleInt> RULE_MAX_COMMAND_FORK_COUNT = GameRules.register("maxCommandForkCount", GameRuleCategory.MISC, GameRuleInt.create(65536));
    public static final GameRuleKey<GameRuleInt> RULE_COMMAND_MODIFICATION_BLOCK_LIMIT = GameRules.register("commandModificationBlockLimit", GameRuleCategory.MISC, GameRuleInt.create(32768));
    public static final GameRuleKey<GameRuleBoolean> RULE_ANNOUNCE_ADVANCEMENTS = GameRules.register("announceAdvancements", GameRuleCategory.CHAT, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_DISABLE_RAIDS = GameRules.register("disableRaids", GameRuleCategory.MOBS, GameRuleBoolean.create(false));
    public static final GameRuleKey<GameRuleBoolean> RULE_DOINSOMNIA = GameRules.register("doInsomnia", GameRuleCategory.SPAWNING, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_DO_IMMEDIATE_RESPAWN = GameRules.register("doImmediateRespawn", GameRuleCategory.PLAYER, GameRuleBoolean.create(false, (var0, var1) -> {
        for (EntityPlayer var3 : var0.getPlayerList().getPlayers()) {
            var3.connection.send(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.IMMEDIATE_RESPAWN, var1.get() ? 1.0f : 0.0f));
        }
    }));
    public static final GameRuleKey<GameRuleInt> RULE_PLAYERS_NETHER_PORTAL_DEFAULT_DELAY = GameRules.register("playersNetherPortalDefaultDelay", GameRuleCategory.PLAYER, GameRuleInt.create(80));
    public static final GameRuleKey<GameRuleInt> RULE_PLAYERS_NETHER_PORTAL_CREATIVE_DELAY = GameRules.register("playersNetherPortalCreativeDelay", GameRuleCategory.PLAYER, GameRuleInt.create(1));
    public static final GameRuleKey<GameRuleBoolean> RULE_DROWNING_DAMAGE = GameRules.register("drowningDamage", GameRuleCategory.PLAYER, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_FALL_DAMAGE = GameRules.register("fallDamage", GameRuleCategory.PLAYER, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_FIRE_DAMAGE = GameRules.register("fireDamage", GameRuleCategory.PLAYER, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_FREEZE_DAMAGE = GameRules.register("freezeDamage", GameRuleCategory.PLAYER, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_DO_PATROL_SPAWNING = GameRules.register("doPatrolSpawning", GameRuleCategory.SPAWNING, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_DO_TRADER_SPAWNING = GameRules.register("doTraderSpawning", GameRuleCategory.SPAWNING, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_DO_WARDEN_SPAWNING = GameRules.register("doWardenSpawning", GameRuleCategory.SPAWNING, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_FORGIVE_DEAD_PLAYERS = GameRules.register("forgiveDeadPlayers", GameRuleCategory.MOBS, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_UNIVERSAL_ANGER = GameRules.register("universalAnger", GameRuleCategory.MOBS, GameRuleBoolean.create(false));
    public static final GameRuleKey<GameRuleInt> RULE_PLAYERS_SLEEPING_PERCENTAGE = GameRules.register("playersSleepingPercentage", GameRuleCategory.PLAYER, GameRuleInt.create(100));
    public static final GameRuleKey<GameRuleBoolean> RULE_BLOCK_EXPLOSION_DROP_DECAY = GameRules.register("blockExplosionDropDecay", GameRuleCategory.DROPS, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_MOB_EXPLOSION_DROP_DECAY = GameRules.register("mobExplosionDropDecay", GameRuleCategory.DROPS, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_TNT_EXPLOSION_DROP_DECAY = GameRules.register("tntExplosionDropDecay", GameRuleCategory.DROPS, GameRuleBoolean.create(false));
    public static final GameRuleKey<GameRuleInt> RULE_SNOW_ACCUMULATION_HEIGHT = GameRules.register("snowAccumulationHeight", GameRuleCategory.UPDATES, GameRuleInt.create(1));
    public static final GameRuleKey<GameRuleBoolean> RULE_WATER_SOURCE_CONVERSION = GameRules.register("waterSourceConversion", GameRuleCategory.UPDATES, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_LAVA_SOURCE_CONVERSION = GameRules.register("lavaSourceConversion", GameRuleCategory.UPDATES, GameRuleBoolean.create(false));
    public static final GameRuleKey<GameRuleBoolean> RULE_GLOBAL_SOUND_EVENTS = GameRules.register("globalSoundEvents", GameRuleCategory.MISC, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_DO_VINES_SPREAD = GameRules.register("doVinesSpread", GameRuleCategory.UPDATES, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_ENDER_PEARLS_VANISH_ON_DEATH = GameRules.register("enderPearlsVanishOnDeath", GameRuleCategory.PLAYER, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleInt> RULE_SPAWN_CHUNK_RADIUS = GameRules.register("spawnChunkRadius", GameRuleCategory.MISC, GameRuleInt.create(2, 0, 32, (var0, var1) -> {
        WorldServer var2 = var0.overworld();
        var2.setDefaultSpawnPos(var2.getSharedSpawnPos(), var2.getSharedSpawnAngle());
    }));
    private final Map<GameRuleKey<?>, GameRuleValue<?>> rules;

    private static <T extends GameRuleValue<T>> GameRuleKey<T> register(String var0, GameRuleCategory var1, GameRuleDefinition<T> var2) {
        GameRuleKey var3 = new GameRuleKey(var0, var1);
        GameRuleDefinition<T> var4 = GAME_RULE_TYPES.put(var3, var2);
        if (var4 != null) {
            throw new IllegalStateException("Duplicate game rule registration for " + var0);
        }
        return var3;
    }

    public GameRules(DynamicLike<?> var0) {
        this();
        this.loadFromTag(var0);
    }

    public GameRules() {
        this.rules = (Map)GAME_RULE_TYPES.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, var0 -> ((GameRuleDefinition)var0.getValue()).createRule()));
    }

    private GameRules(Map<GameRuleKey<?>, GameRuleValue<?>> var0) {
        this.rules = var0;
    }

    public <T extends GameRuleValue<T>> T getRule(GameRuleKey<T> var0) {
        return (T)this.rules.get(var0);
    }

    public NBTTagCompound createTag() {
        NBTTagCompound var0 = new NBTTagCompound();
        this.rules.forEach((var1, var2) -> var0.putString(var1.id, var2.serialize()));
        return var0;
    }

    private void loadFromTag(DynamicLike<?> var0) {
        this.rules.forEach((var1, var2) -> var0.get(var1.id).asString().ifSuccess(var2::deserialize));
    }

    public GameRules copy() {
        return new GameRules((Map)this.rules.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, var0 -> ((GameRuleValue)var0.getValue()).copy())));
    }

    public static void visitGameRuleTypes(GameRuleVisitor var0) {
        GAME_RULE_TYPES.forEach((var1, var2) -> GameRules.callVisitorCap(var0, var1, var2));
    }

    private static <T extends GameRuleValue<T>> void callVisitorCap(GameRuleVisitor var0, GameRuleKey<?> var1, GameRuleDefinition<?> var2) {
        GameRuleKey<?> var3 = var1;
        GameRuleDefinition<?> var4 = var2;
        var0.visit(var3, var4);
        var4.callVisitor(var0, var3);
    }

    public void assignFrom(GameRules var0, @Nullable MinecraftServer var1) {
        var0.rules.keySet().forEach(var2 -> this.assignCap((GameRuleKey)var2, var0, var1));
    }

    private <T extends GameRuleValue<T>> void assignCap(GameRuleKey<T> var0, GameRules var1, @Nullable MinecraftServer var2) {
        T var3 = var1.getRule(var0);
        ((GameRuleValue)this.getRule(var0)).setFrom(var3, var2);
    }

    public boolean getBoolean(GameRuleKey<GameRuleBoolean> var0) {
        return this.getRule(var0).get();
    }

    public int getInt(GameRuleKey<GameRuleInt> var0) {
        return this.getRule(var0).get();
    }

    public static final class GameRuleKey<T extends GameRuleValue<T>> {
        final String id;
        private final GameRuleCategory category;

        public GameRuleKey(String var0, GameRuleCategory var1) {
            this.id = var0;
            this.category = var1;
        }

        public String toString() {
            return this.id;
        }

        public boolean equals(Object var0) {
            if (this == var0) {
                return true;
            }
            return var0 instanceof GameRuleKey && ((GameRuleKey)var0).id.equals(this.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String getId() {
            return this.id;
        }

        public String getDescriptionId() {
            return "gamerule." + this.id;
        }

        public GameRuleCategory getCategory() {
            return this.category;
        }
    }

    public static final class GameRuleCategory
    extends Enum<GameRuleCategory> {
        public static final /* enum */ GameRuleCategory PLAYER = new GameRuleCategory("gamerule.category.player");
        public static final /* enum */ GameRuleCategory MOBS = new GameRuleCategory("gamerule.category.mobs");
        public static final /* enum */ GameRuleCategory SPAWNING = new GameRuleCategory("gamerule.category.spawning");
        public static final /* enum */ GameRuleCategory DROPS = new GameRuleCategory("gamerule.category.drops");
        public static final /* enum */ GameRuleCategory UPDATES = new GameRuleCategory("gamerule.category.updates");
        public static final /* enum */ GameRuleCategory CHAT = new GameRuleCategory("gamerule.category.chat");
        public static final /* enum */ GameRuleCategory MISC = new GameRuleCategory("gamerule.category.misc");
        private final String descriptionId;
        private static final /* synthetic */ GameRuleCategory[] i;

        public static GameRuleCategory[] values() {
            return (GameRuleCategory[])i.clone();
        }

        public static GameRuleCategory valueOf(String var0) {
            return Enum.valueOf(GameRuleCategory.class, var0);
        }

        private GameRuleCategory(String var2) {
            this.descriptionId = var2;
        }

        public String getDescriptionId() {
            return this.descriptionId;
        }

        private static /* synthetic */ GameRuleCategory[] b() {
            return new GameRuleCategory[]{PLAYER, MOBS, SPAWNING, DROPS, UPDATES, CHAT, MISC};
        }

        static {
            i = GameRuleCategory.b();
        }
    }

    public static class GameRuleDefinition<T extends GameRuleValue<T>> {
        final Supplier<ArgumentType<?>> argument;
        private final Function<GameRuleDefinition<T>, T> constructor;
        final BiConsumer<MinecraftServer, T> callback;
        private final h<T> visitorCaller;

        GameRuleDefinition(Supplier<ArgumentType<?>> var0, Function<GameRuleDefinition<T>, T> var1, BiConsumer<MinecraftServer, T> var2, h<T> var3) {
            this.argument = var0;
            this.constructor = var1;
            this.callback = var2;
            this.visitorCaller = var3;
        }

        public RequiredArgumentBuilder<CommandListenerWrapper, ?> createArgument(String var0) {
            return CommandDispatcher.argument(var0, this.argument.get());
        }

        public T createRule() {
            return (T)((GameRuleValue)this.constructor.apply(this));
        }

        public void callVisitor(GameRuleVisitor var0, GameRuleKey<T> var1) {
            this.visitorCaller.call(var0, var1, this);
        }
    }

    public static abstract class GameRuleValue<T extends GameRuleValue<T>> {
        protected final GameRuleDefinition<T> type;

        public GameRuleValue(GameRuleDefinition<T> var0) {
            this.type = var0;
        }

        protected abstract void updateFromArgument(CommandContext<CommandListenerWrapper> var1, String var2);

        public void setFromArgument(CommandContext<CommandListenerWrapper> var0, String var1) {
            this.updateFromArgument(var0, var1);
            this.onChanged(((CommandListenerWrapper)var0.getSource()).getServer());
        }

        public void onChanged(@Nullable MinecraftServer var0) {
            if (var0 != null) {
                this.type.callback.accept(var0, (MinecraftServer)this.getSelf());
            }
        }

        protected abstract void deserialize(String var1);

        public abstract String serialize();

        public String toString() {
            return this.serialize();
        }

        public abstract int getCommandResult();

        protected abstract T getSelf();

        protected abstract T copy();

        public abstract void setFrom(T var1, @Nullable MinecraftServer var2);
    }

    public static interface GameRuleVisitor {
        default public <T extends GameRuleValue<T>> void visit(GameRuleKey<T> var0, GameRuleDefinition<T> var1) {
        }

        default public void visitBoolean(GameRuleKey<GameRuleBoolean> var0, GameRuleDefinition<GameRuleBoolean> var1) {
        }

        default public void visitInteger(GameRuleKey<GameRuleInt> var0, GameRuleDefinition<GameRuleInt> var1) {
        }
    }

    public static class GameRuleBoolean
    extends GameRuleValue<GameRuleBoolean> {
        private boolean value;

        static GameRuleDefinition<GameRuleBoolean> create(boolean var0, BiConsumer<MinecraftServer, GameRuleBoolean> var12) {
            return new GameRuleDefinition<GameRuleBoolean>(BoolArgumentType::bool, var1 -> new GameRuleBoolean((GameRuleDefinition<GameRuleBoolean>)var1, var0), var12, GameRuleVisitor::visitBoolean);
        }

        static GameRuleDefinition<GameRuleBoolean> create(boolean var02) {
            return GameRuleBoolean.create(var02, (var0, var1) -> {});
        }

        public GameRuleBoolean(GameRuleDefinition<GameRuleBoolean> var0, boolean var1) {
            super(var0);
            this.value = var1;
        }

        @Override
        protected void updateFromArgument(CommandContext<CommandListenerWrapper> var0, String var1) {
            this.value = BoolArgumentType.getBool(var0, (String)var1);
        }

        public boolean get() {
            return this.value;
        }

        public void set(boolean var0, @Nullable MinecraftServer var1) {
            this.value = var0;
            this.onChanged(var1);
        }

        @Override
        public String serialize() {
            return Boolean.toString(this.value);
        }

        @Override
        protected void deserialize(String var0) {
            this.value = Boolean.parseBoolean(var0);
        }

        @Override
        public int getCommandResult() {
            return this.value ? 1 : 0;
        }

        @Override
        protected GameRuleBoolean getSelf() {
            return this;
        }

        @Override
        protected GameRuleBoolean copy() {
            return new GameRuleBoolean(this.type, this.value);
        }

        @Override
        public void setFrom(GameRuleBoolean var0, @Nullable MinecraftServer var1) {
            this.value = var0.value;
            this.onChanged(var1);
        }

        @Override
        protected /* synthetic */ GameRuleValue copy() {
            return this.copy();
        }

        @Override
        protected /* synthetic */ GameRuleValue getSelf() {
            return this.getSelf();
        }
    }

    public static class GameRuleInt
    extends GameRuleValue<GameRuleInt> {
        private int value;

        private static GameRuleDefinition<GameRuleInt> create(int var0, BiConsumer<MinecraftServer, GameRuleInt> var12) {
            return new GameRuleDefinition<GameRuleInt>(IntegerArgumentType::integer, var1 -> new GameRuleInt((GameRuleDefinition<GameRuleInt>)var1, var0), var12, GameRuleVisitor::visitInteger);
        }

        static GameRuleDefinition<GameRuleInt> create(int var0, int var12, int var2, BiConsumer<MinecraftServer, GameRuleInt> var3) {
            return new GameRuleDefinition<GameRuleInt>(() -> IntegerArgumentType.integer((int)var12, (int)var2), var1 -> new GameRuleInt((GameRuleDefinition<GameRuleInt>)var1, var0), var3, GameRuleVisitor::visitInteger);
        }

        static GameRuleDefinition<GameRuleInt> create(int var02) {
            return GameRuleInt.create(var02, (var0, var1) -> {});
        }

        public GameRuleInt(GameRuleDefinition<GameRuleInt> var0, int var1) {
            super(var0);
            this.value = var1;
        }

        @Override
        protected void updateFromArgument(CommandContext<CommandListenerWrapper> var0, String var1) {
            this.value = IntegerArgumentType.getInteger(var0, (String)var1);
        }

        public int get() {
            return this.value;
        }

        public void set(int var0, @Nullable MinecraftServer var1) {
            this.value = var0;
            this.onChanged(var1);
        }

        @Override
        public String serialize() {
            return Integer.toString(this.value);
        }

        @Override
        protected void deserialize(String var0) {
            this.value = GameRuleInt.safeParse(var0);
        }

        public boolean tryDeserialize(String var0) {
            try {
                StringReader var1 = new StringReader(var0);
                this.value = (Integer)this.type.argument.get().parse(var1);
                return !var1.canRead();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                return false;
            }
        }

        private static int safeParse(String var0) {
            if (!var0.isEmpty()) {
                try {
                    return Integer.parseInt(var0);
                }
                catch (NumberFormatException var1) {
                    LOGGER.warn("Failed to parse integer {}", (Object)var0);
                }
            }
            return 0;
        }

        @Override
        public int getCommandResult() {
            return this.value;
        }

        @Override
        protected GameRuleInt getSelf() {
            return this;
        }

        @Override
        protected GameRuleInt copy() {
            return new GameRuleInt(this.type, this.value);
        }

        @Override
        public void setFrom(GameRuleInt var0, @Nullable MinecraftServer var1) {
            this.value = var0.value;
            this.onChanged(var1);
        }

        @Override
        protected /* synthetic */ GameRuleValue copy() {
            return this.copy();
        }

        @Override
        protected /* synthetic */ GameRuleValue getSelf() {
            return this.getSelf();
        }
    }

    static interface h<T extends GameRuleValue<T>> {
        public void call(GameRuleVisitor var1, GameRuleKey<T> var2, GameRuleDefinition<T> var3);
    }
}

