/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;

public interface IEntityAccess {
    public List<Entity> getEntities(@Nullable Entity var1, AxisAlignedBB var2, Predicate<? super Entity> var3);

    public <T extends Entity> List<T> getEntities(EntityTypeTest<Entity, T> var1, AxisAlignedBB var2, Predicate<? super T> var3);

    default public <T extends Entity> List<T> getEntitiesOfClass(Class<T> var0, AxisAlignedBB var1, Predicate<? super T> var2) {
        return this.getEntities(EntityTypeTest.forClass(var0), var1, var2);
    }

    public List<? extends EntityHuman> players();

    default public List<Entity> getEntities(@Nullable Entity var0, AxisAlignedBB var1) {
        return this.getEntities(var0, var1, IEntitySelector.NO_SPECTATORS);
    }

    default public boolean isUnobstructed(@Nullable Entity var0, VoxelShape var1) {
        if (var1.isEmpty()) {
            return true;
        }
        for (Entity var3 : this.getEntities(var0, var1.bounds())) {
            if (var3.isRemoved() || !var3.blocksBuilding || var0 != null && var3.isPassengerOfSameVehicle(var0) || !VoxelShapes.joinIsNotEmpty(var1, VoxelShapes.create(var3.getBoundingBox()), OperatorBoolean.AND)) continue;
            return false;
        }
        return true;
    }

    default public <T extends Entity> List<T> getEntitiesOfClass(Class<T> var0, AxisAlignedBB var1) {
        return this.getEntitiesOfClass(var0, var1, IEntitySelector.NO_SPECTATORS);
    }

    default public List<VoxelShape> getEntityCollisions(@Nullable Entity var0, AxisAlignedBB var1) {
        if (var1.getSize() < 1.0E-7) {
            return List.of();
        }
        Predicate<Entity> var2 = var0 == null ? IEntitySelector.CAN_BE_COLLIDED_WITH : IEntitySelector.NO_SPECTATORS.and(var0::canCollideWith);
        List<Entity> var3 = this.getEntities(var0, var1.inflate(1.0E-7), var2);
        if (var3.isEmpty()) {
            return List.of();
        }
        ImmutableList.Builder var4 = ImmutableList.builderWithExpectedSize((int)var3.size());
        for (Entity var6 : var3) {
            var4.add((Object)VoxelShapes.create(var6.getBoundingBox()));
        }
        return var4.build();
    }

    @Nullable
    default public EntityHuman getNearestPlayer(double var0, double var2, double var4, double var6, @Nullable Predicate<Entity> var8) {
        double var9 = -1.0;
        EntityHuman var11 = null;
        for (EntityHuman entityHuman : this.players()) {
            if (var8 != null && !var8.test(entityHuman)) continue;
            double var14 = entityHuman.distanceToSqr(var0, var2, var4);
            if (!(var6 < 0.0) && !(var14 < var6 * var6) || var9 != -1.0 && !(var14 < var9)) continue;
            var9 = var14;
            var11 = entityHuman;
        }
        return var11;
    }

    @Nullable
    default public EntityHuman getNearestPlayer(Entity var0, double var1) {
        return this.getNearestPlayer(var0.getX(), var0.getY(), var0.getZ(), var1, false);
    }

    @Nullable
    default public EntityHuman getNearestPlayer(double var0, double var2, double var4, double var6, boolean var8) {
        Predicate<Entity> var9 = var8 ? IEntitySelector.NO_CREATIVE_OR_SPECTATOR : IEntitySelector.NO_SPECTATORS;
        return this.getNearestPlayer(var0, var2, var4, var6, var9);
    }

    default public boolean hasNearbyAlivePlayer(double var0, double var2, double var4, double var6) {
        for (EntityHuman entityHuman : this.players()) {
            if (!IEntitySelector.NO_SPECTATORS.test(entityHuman) || !IEntitySelector.LIVING_ENTITY_STILL_ALIVE.test(entityHuman)) continue;
            double var10 = entityHuman.distanceToSqr(var0, var2, var4);
            if (!(var6 < 0.0) && !(var10 < var6 * var6)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    default public EntityHuman getNearestPlayer(PathfinderTargetCondition var0, EntityLiving var1) {
        return this.getNearestEntity(this.players(), var0, var1, var1.getX(), var1.getY(), var1.getZ());
    }

    @Nullable
    default public EntityHuman getNearestPlayer(PathfinderTargetCondition var0, EntityLiving var1, double var2, double var4, double var6) {
        return this.getNearestEntity(this.players(), var0, var1, var2, var4, var6);
    }

    @Nullable
    default public EntityHuman getNearestPlayer(PathfinderTargetCondition var0, double var1, double var3, double var5) {
        return this.getNearestEntity(this.players(), var0, null, var1, var3, var5);
    }

    @Nullable
    default public <T extends EntityLiving> T getNearestEntity(Class<? extends T> var02, PathfinderTargetCondition var1, @Nullable EntityLiving var2, double var3, double var5, double var7, AxisAlignedBB var9) {
        return (T)this.getNearestEntity(this.getEntitiesOfClass(var02, var9, var0 -> true), var1, var2, var3, var5, var7);
    }

    @Nullable
    default public <T extends EntityLiving> T getNearestEntity(List<? extends T> var0, PathfinderTargetCondition var1, @Nullable EntityLiving var2, double var3, double var5, double var7) {
        double var9 = -1.0;
        EntityLiving var11 = null;
        for (EntityLiving var13 : var0) {
            if (!var1.test(var2, var13)) continue;
            double var14 = var13.distanceToSqr(var3, var5, var7);
            if (var9 != -1.0 && !(var14 < var9)) continue;
            var9 = var14;
            var11 = var13;
        }
        return (T)var11;
    }

    default public List<EntityHuman> getNearbyPlayers(PathfinderTargetCondition var0, EntityLiving var1, AxisAlignedBB var2) {
        ArrayList var3 = Lists.newArrayList();
        for (EntityHuman entityHuman : this.players()) {
            if (!var2.contains(entityHuman.getX(), entityHuman.getY(), entityHuman.getZ()) || !var0.test(var1, entityHuman)) continue;
            var3.add(entityHuman);
        }
        return var3;
    }

    default public <T extends EntityLiving> List<T> getNearbyEntities(Class<T> var02, PathfinderTargetCondition var1, EntityLiving var2, AxisAlignedBB var3) {
        List<EntityLiving> var4 = this.getEntitiesOfClass(var02, var3, var0 -> true);
        ArrayList var5 = Lists.newArrayList();
        for (EntityLiving var7 : var4) {
            if (!var1.test(var2, var7)) continue;
            var5.add(var7);
        }
        return var5;
    }

    @Nullable
    default public EntityHuman getPlayerByUUID(UUID var0) {
        for (int var1 = 0; var1 < this.players().size(); ++var1) {
            EntityHuman var2 = this.players().get(var1);
            if (!var0.equals(var2.getUUID())) continue;
            return var2;
        }
        return null;
    }
}

