/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.ChunkCoordIntPair;

public class LocalMobCapCalculator {
    private final Long2ObjectMap<List<EntityPlayer>> playersNearChunk = new Long2ObjectOpenHashMap();
    private final Map<EntityPlayer, a> playerMobCounts = Maps.newHashMap();
    private final PlayerChunkMap chunkMap;

    public LocalMobCapCalculator(PlayerChunkMap var0) {
        this.chunkMap = var0;
    }

    private List<EntityPlayer> getPlayersNear(ChunkCoordIntPair var0) {
        return (List)this.playersNearChunk.computeIfAbsent(var0.toLong(), var1 -> this.chunkMap.getPlayersCloseForSpawning(var0));
    }

    public void addMob(ChunkCoordIntPair var02, EnumCreatureType var1) {
        for (EntityPlayer var3 : this.getPlayersNear(var02)) {
            this.playerMobCounts.computeIfAbsent(var3, var0 -> new a()).add(var1);
        }
    }

    public boolean canSpawn(EnumCreatureType var0, ChunkCoordIntPair var1) {
        for (EntityPlayer var3 : this.getPlayersNear(var1)) {
            a var4 = this.playerMobCounts.get(var3);
            if (var4 != null && !var4.canSpawn(var0)) continue;
            return true;
        }
        return false;
    }

    static class a {
        private final Object2IntMap<EnumCreatureType> counts = new Object2IntOpenHashMap(EnumCreatureType.values().length);

        a() {
        }

        public void add(EnumCreatureType var02) {
            this.counts.computeInt((Object)var02, (var0, var1) -> var1 == null ? 1 : var1 + 1);
        }

        public boolean canSpawn(EnumCreatureType var0) {
            return this.counts.getOrDefault((Object)var0, 0) < var0.getMaxInstancesPerChunk();
        }
    }
}

