/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockCactus
extends Block {
    public static final MapCodec<BlockCactus> CODEC = BlockCactus.simpleCodec(BlockCactus::new);
    public static final BlockStateInteger AGE = BlockProperties.AGE_15;
    public static final int MAX_AGE = 15;
    protected static final int AABB_OFFSET = 1;
    protected static final VoxelShape COLLISION_SHAPE = Block.box(1.0, 0.0, 1.0, 15.0, 15.0, 15.0);
    protected static final VoxelShape OUTLINE_SHAPE = Block.box(1.0, 0.0, 1.0, 15.0, 16.0, 15.0);

    public MapCodec<BlockCactus> codec() {
        return CODEC;
    }

    protected BlockCactus(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(AGE, 0));
    }

    @Override
    protected void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (!var0.canSurvive(var1, var2)) {
            var1.destroyBlock(var2, true);
        }
    }

    @Override
    protected void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        BlockPosition var4 = var2.above();
        if (!var1.isEmptyBlock(var4)) {
            return;
        }
        int var5 = 1;
        while (var1.getBlockState(var2.below(var5)).is(this)) {
            ++var5;
        }
        if (var5 >= 3) {
            return;
        }
        int var6 = var0.getValue(AGE);
        if (var6 == 15) {
            var1.setBlockAndUpdate(var4, this.defaultBlockState());
            IBlockData var7 = (IBlockData)var0.setValue(AGE, 0);
            var1.setBlock(var2, var7, 4);
            var1.neighborChanged(var7, var4, this, var2, false);
        } else {
            var1.setBlock(var2, (IBlockData)var0.setValue(AGE, var6 + 1), 4);
        }
    }

    @Override
    protected VoxelShape getCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return COLLISION_SHAPE;
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return OUTLINE_SHAPE;
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (!var0.canSurvive(var3, var4)) {
            var3.scheduleTick(var4, this, 1);
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        for (EnumDirection var4 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            IBlockData var5 = var1.getBlockState(var2.relative(var4));
            if (!var5.isSolid() && !var1.getFluidState(var2.relative(var4)).is(TagsFluid.LAVA)) continue;
            return false;
        }
        IBlockData var3 = var1.getBlockState(var2.below());
        return (var3.is(Blocks.CACTUS) || var3.is(TagsBlock.SAND)) && !var1.getBlockState(var2.above()).liquid();
    }

    @Override
    protected void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3) {
        var3.hurt(var1.damageSources().cactus(), 1.0f);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(AGE);
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return false;
    }
}

