/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockFlowerPot
extends Block {
    public static final MapCodec<BlockFlowerPot> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("potted").forGetter(var0 -> var0.potted), BlockFlowerPot.propertiesCodec()).apply((Applicative)var02, BlockFlowerPot::new));
    private static final Map<Block, Block> POTTED_BY_CONTENT = Maps.newHashMap();
    public static final float AABB_SIZE = 3.0f;
    protected static final VoxelShape SHAPE = Block.box(5.0, 0.0, 5.0, 11.0, 6.0, 11.0);
    private final Block potted;

    public MapCodec<BlockFlowerPot> codec() {
        return CODEC;
    }

    public BlockFlowerPot(Block var0, BlockBase.Info var1) {
        super(var1);
        this.potted = var0;
        POTTED_BY_CONTENT.put(var0, this);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack var0, IBlockData var1, World var2, BlockPosition var3, EntityHuman var4, EnumHand var5, MovingObjectPositionBlock var6) {
        Block block;
        Item item = var0.getItem();
        if (item instanceof ItemBlock) {
            ItemBlock var8 = (ItemBlock)item;
            block = POTTED_BY_CONTENT.getOrDefault(var8.getBlock(), Blocks.AIR);
        } else {
            block = Blocks.AIR;
        }
        IBlockData var7 = block.defaultBlockState();
        if (var7.isAir()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!this.isEmpty()) {
            return ItemInteractionResult.CONSUME;
        }
        var2.setBlock(var3, var7, 3);
        var2.gameEvent((Entity)var4, GameEvent.BLOCK_CHANGE, var3);
        var4.awardStat(StatisticList.POT_FLOWER);
        var0.consume(1, var4);
        return ItemInteractionResult.sidedSuccess(var2.isClientSide);
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        if (this.isEmpty()) {
            return EnumInteractionResult.CONSUME;
        }
        ItemStack var5 = new ItemStack(this.potted);
        if (!var3.addItem(var5)) {
            var3.drop(var5, false);
        }
        var1.setBlock(var2, Blocks.FLOWER_POT.defaultBlockState(), 3);
        var1.gameEvent((Entity)var3, GameEvent.BLOCK_CHANGE, var2);
        return EnumInteractionResult.sidedSuccess(var1.isClientSide);
    }

    @Override
    public ItemStack getCloneItemStack(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        if (this.isEmpty()) {
            return super.getCloneItemStack(var0, var1, var2);
        }
        return new ItemStack(this.potted);
    }

    private boolean isEmpty() {
        return this.potted == Blocks.AIR;
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var1 == EnumDirection.DOWN && !var0.canSurvive(var3, var4)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    public Block getPotted() {
        return this.potted;
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return false;
    }
}

