/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.entity.vehicle.EntityMinecartCommandBlock;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.MinecartTrackLogic;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.phys.AxisAlignedBB;

public class BlockMinecartDetector
extends BlockMinecartTrackAbstract {
    public static final MapCodec<BlockMinecartDetector> CODEC = BlockMinecartDetector.simpleCodec(BlockMinecartDetector::new);
    public static final BlockStateEnum<BlockPropertyTrackPosition> SHAPE = BlockProperties.RAIL_SHAPE_STRAIGHT;
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;
    private static final int PRESSED_CHECK_PERIOD = 20;

    public MapCodec<BlockMinecartDetector> codec() {
        return CODEC;
    }

    public BlockMinecartDetector(BlockBase.Info var0) {
        super(true, var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(POWERED, false)).setValue(SHAPE, BlockPropertyTrackPosition.NORTH_SOUTH)).setValue(WATERLOGGED, false));
    }

    @Override
    protected boolean isSignalSource(IBlockData var0) {
        return true;
    }

    @Override
    protected void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3) {
        if (var1.isClientSide) {
            return;
        }
        if (var0.getValue(POWERED).booleanValue()) {
            return;
        }
        this.checkPressed(var1, var2, var0);
    }

    @Override
    protected void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (!var0.getValue(POWERED).booleanValue()) {
            return;
        }
        this.checkPressed(var1, var2, var0);
    }

    @Override
    protected int getSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        return var0.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    protected int getDirectSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        if (!var0.getValue(POWERED).booleanValue()) {
            return 0;
        }
        return var3 == EnumDirection.UP ? 15 : 0;
    }

    private void checkPressed(World var02, BlockPosition var1, IBlockData var2) {
        IBlockData var6;
        if (!this.canSurvive(var2, var02, var1)) {
            return;
        }
        boolean var3 = var2.getValue(POWERED);
        boolean var4 = false;
        List<EntityMinecartAbstract> var5 = this.getInteractingMinecartOfType(var02, var1, EntityMinecartAbstract.class, var0 -> true);
        if (!var5.isEmpty()) {
            var4 = true;
        }
        if (var4 && !var3) {
            var6 = (IBlockData)var2.setValue(POWERED, true);
            var02.setBlock(var1, var6, 3);
            this.updatePowerToConnected(var02, var1, var6, true);
            var02.updateNeighborsAt(var1, this);
            var02.updateNeighborsAt(var1.below(), this);
            var02.setBlocksDirty(var1, var2, var6);
        }
        if (!var4 && var3) {
            var6 = (IBlockData)var2.setValue(POWERED, false);
            var02.setBlock(var1, var6, 3);
            this.updatePowerToConnected(var02, var1, var6, false);
            var02.updateNeighborsAt(var1, this);
            var02.updateNeighborsAt(var1.below(), this);
            var02.setBlocksDirty(var1, var2, var6);
        }
        if (var4) {
            var02.scheduleTick(var1, this, 20);
        }
        var02.updateNeighbourForOutputSignal(var1, this);
    }

    protected void updatePowerToConnected(World var0, BlockPosition var1, IBlockData var2, boolean var3) {
        MinecartTrackLogic var4 = new MinecartTrackLogic(var0, var1, var2);
        List<BlockPosition> var5 = var4.getConnections();
        for (BlockPosition var7 : var5) {
            IBlockData var8 = var0.getBlockState(var7);
            var0.neighborChanged(var8, var7, var8.getBlock(), var1, false);
        }
    }

    @Override
    protected void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var3.is(var0.getBlock())) {
            return;
        }
        IBlockData var5 = this.updateState(var0, var1, var2, var4);
        this.checkPressed(var1, var2, var5);
    }

    @Override
    public IBlockState<BlockPropertyTrackPosition> getShapeProperty() {
        return SHAPE;
    }

    @Override
    protected boolean hasAnalogOutputSignal(IBlockData var0) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(IBlockData var02, World var1, BlockPosition var2) {
        if (var02.getValue(POWERED).booleanValue()) {
            List<EntityMinecartCommandBlock> var3 = this.getInteractingMinecartOfType(var1, var2, EntityMinecartCommandBlock.class, var0 -> true);
            if (!var3.isEmpty()) {
                return var3.get(0).getCommandBlock().getSuccessCount();
            }
            List<EntityMinecartAbstract> var4 = this.getInteractingMinecartOfType(var1, var2, EntityMinecartAbstract.class, IEntitySelector.CONTAINER_ENTITY_SELECTOR);
            if (!var4.isEmpty()) {
                return Container.getRedstoneSignalFromContainer((IInventory)((Object)var4.get(0)));
            }
        }
        return 0;
    }

    private <T extends EntityMinecartAbstract> List<T> getInteractingMinecartOfType(World var0, BlockPosition var1, Class<T> var2, Predicate<Entity> var3) {
        return var0.getEntitiesOfClass(var2, this.getSearchBB(var1), var3);
    }

    private AxisAlignedBB getSearchBB(BlockPosition var0) {
        double var1 = 0.2;
        return new AxisAlignedBB((double)var0.getX() + 0.2, var0.getY(), (double)var0.getZ() + 0.2, (double)(var0.getX() + 1) - 0.2, (double)(var0.getY() + 1) - 0.2, (double)(var0.getZ() + 1) - 0.2);
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        switch (var1) {
            case CLOCKWISE_180: {
                switch (var0.getValue(SHAPE)) {
                    case ASCENDING_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_EAST);
                    }
                    case ASCENDING_NORTH: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_WEST);
                    }
                }
            }
            case COUNTERCLOCKWISE_90: {
                switch (var0.getValue(SHAPE)) {
                    case NORTH_SOUTH: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_SOUTH);
                    }
                    case ASCENDING_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_NORTH);
                    }
                    case ASCENDING_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_SOUTH);
                    }
                    case ASCENDING_NORTH: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_WEST);
                    }
                    case ASCENDING_SOUTH: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_WEST);
                    }
                }
            }
            case CLOCKWISE_90: {
                switch (var0.getValue(SHAPE)) {
                    case NORTH_SOUTH: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_SOUTH);
                    }
                    case ASCENDING_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_SOUTH);
                    }
                    case ASCENDING_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_NORTH);
                    }
                    case ASCENDING_NORTH: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_EAST);
                    }
                    case ASCENDING_SOUTH: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_WEST);
                    }
                    case SOUTH_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_EAST);
                    }
                }
            }
        }
        return var0;
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        BlockPropertyTrackPosition var2 = var0.getValue(SHAPE);
        switch (var1) {
            case LEFT_RIGHT: {
                switch (var2) {
                    case ASCENDING_NORTH: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_EAST);
                    }
                }
                break;
            }
            case FRONT_BACK: {
                switch (var2) {
                    case ASCENDING_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_WEST);
                    }
                }
                break;
            }
        }
        return super.mirror(var0, var1);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(SHAPE, POWERED, WATERLOGGED);
    }
}

