/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.portal.BlockPortalShape;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.slf4j.Logger;

public class BlockPortal
extends Block
implements Portal {
    public static final MapCodec<BlockPortal> CODEC = BlockPortal.simpleCodec(BlockPortal::new);
    public static final BlockStateEnum<EnumDirection.EnumAxis> AXIS = BlockProperties.HORIZONTAL_AXIS;
    private static final Logger LOGGER = LogUtils.getLogger();
    protected static final int AABB_OFFSET = 2;
    protected static final VoxelShape X_AXIS_AABB = Block.box(0.0, 0.0, 6.0, 16.0, 16.0, 10.0);
    protected static final VoxelShape Z_AXIS_AABB = Block.box(6.0, 0.0, 0.0, 10.0, 16.0, 16.0);

    public MapCodec<BlockPortal> codec() {
        return CODEC;
    }

    public BlockPortal(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(AXIS, EnumDirection.EnumAxis.X));
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        switch (var0.getValue(AXIS)) {
            case Z: {
                return Z_AXIS_AABB;
            }
        }
        return X_AXIS_AABB;
    }

    @Override
    protected void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (var1.dimensionType().natural() && var1.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && var3.nextInt(2000) < var1.getDifficulty().getId()) {
            EntityPigZombie var4;
            while (var1.getBlockState(var2).is(this)) {
                var2 = var2.below();
            }
            if (var1.getBlockState(var2).isValidSpawn(var1, var2, EntityTypes.ZOMBIFIED_PIGLIN) && (var4 = EntityTypes.ZOMBIFIED_PIGLIN.spawn(var1, var2.above(), EnumMobSpawn.STRUCTURE)) != null) {
                var4.setPortalCooldown();
            }
        }
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        boolean var8;
        EnumDirection.EnumAxis var6 = var1.getAxis();
        EnumDirection.EnumAxis var7 = var0.getValue(AXIS);
        boolean bl = var8 = var7 != var6 && var6.isHorizontal();
        if (var8 || var2.is(this) || new BlockPortalShape(var3, var4, var7).isComplete()) {
            return super.updateShape(var0, var1, var2, var3, var4, var5);
        }
        return Blocks.AIR.defaultBlockState();
    }

    @Override
    protected void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3) {
        if (var3.canUsePortal(false)) {
            var3.setAsInsidePortal(this, var2);
        }
    }

    @Override
    public int getPortalTransitionTime(WorldServer var0, Entity var1) {
        if (var1 instanceof EntityHuman) {
            EntityHuman var2 = (EntityHuman)var1;
            return Math.max(1, var0.getGameRules().getInt(var2.getAbilities().invulnerable ? GameRules.RULE_PLAYERS_NETHER_PORTAL_CREATIVE_DELAY : GameRules.RULE_PLAYERS_NETHER_PORTAL_DEFAULT_DELAY));
        }
        return 0;
    }

    @Override
    @Nullable
    public DimensionTransition getPortalDestination(WorldServer var0, Entity var1, BlockPosition var2) {
        ResourceKey<World> var3 = var0.dimension() == World.NETHER ? World.OVERWORLD : World.NETHER;
        WorldServer var4 = var0.getServer().getLevel(var3);
        if (var4 == null) {
            return null;
        }
        boolean var5 = var4.dimension() == World.NETHER;
        WorldBorder var6 = var4.getWorldBorder();
        double var7 = DimensionManager.getTeleportationScale(var0.dimensionType(), var4.dimensionType());
        BlockPosition var9 = var6.clampToBounds(var1.getX() * var7, var1.getY(), var1.getZ() * var7);
        return this.getExitPortal(var4, var1, var2, var9, var5, var6);
    }

    @Nullable
    private DimensionTransition getExitPortal(WorldServer var0, Entity var12, BlockPosition var22, BlockPosition var3, boolean var4, WorldBorder var5) {
        DimensionTransition.a var8;
        BlockUtil.Rectangle var7;
        Optional<BlockPosition> var6 = var0.getPortalForcer().findClosestPortalPosition(var3, var4, var5);
        if (var6.isPresent()) {
            BlockPosition var9 = var6.get();
            IBlockData var10 = var0.getBlockState(var9);
            var7 = BlockUtil.getLargestRectangleAround(var9, var10.getValue(BlockProperties.HORIZONTAL_AXIS), 21, EnumDirection.EnumAxis.Y, 21, var2 -> var0.getBlockState((BlockPosition)var2) == var10);
            var8 = DimensionTransition.PLAY_PORTAL_SOUND.then(var1 -> var1.placePortalTicket(var9));
        } else {
            EnumDirection.EnumAxis var9 = var12.level().getBlockState(var22).getOptionalValue(AXIS).orElse(EnumDirection.EnumAxis.X);
            Optional<BlockUtil.Rectangle> var10 = var0.getPortalForcer().createPortal(var3, var9);
            if (var10.isEmpty()) {
                LOGGER.error("Unable to create a portal, likely target out of worldborder");
                return null;
            }
            var7 = var10.get();
            var8 = DimensionTransition.PLAY_PORTAL_SOUND.then(DimensionTransition.PLACE_PORTAL_TICKET);
        }
        return BlockPortal.getDimensionTransitionFromExit(var12, var22, var7, var0, var8);
    }

    private static DimensionTransition getDimensionTransitionFromExit(Entity var0, BlockPosition var1, BlockUtil.Rectangle var22, WorldServer var3, DimensionTransition.a var4) {
        Vec3D var6;
        EnumDirection.EnumAxis var5;
        IBlockData var7 = var0.level().getBlockState(var1);
        if (var7.hasProperty(BlockProperties.HORIZONTAL_AXIS)) {
            var5 = var7.getValue(BlockProperties.HORIZONTAL_AXIS);
            BlockUtil.Rectangle var8 = BlockUtil.getLargestRectangleAround(var1, var5, 21, EnumDirection.EnumAxis.Y, 21, var2 -> var0.level().getBlockState((BlockPosition)var2) == var7);
            var6 = var0.getRelativePortalPosition(var5, var8);
        } else {
            var5 = EnumDirection.EnumAxis.X;
            var6 = new Vec3D(0.5, 0.0, 0.0);
        }
        return BlockPortal.createDimensionTransition(var3, var22, var5, var6, var0, var0.getDeltaMovement(), var0.getYRot(), var0.getXRot(), var4);
    }

    private static DimensionTransition createDimensionTransition(WorldServer var0, BlockUtil.Rectangle var1, EnumDirection.EnumAxis var2, Vec3D var3, Entity var4, Vec3D var5, float var6, float var7, DimensionTransition.a var8) {
        BlockPosition var9 = var1.minCorner;
        IBlockData var10 = var0.getBlockState(var9);
        EnumDirection.EnumAxis var11 = var10.getOptionalValue(BlockProperties.HORIZONTAL_AXIS).orElse(EnumDirection.EnumAxis.X);
        double var12 = var1.axis1Size;
        double var14 = var1.axis2Size;
        EntitySize var16 = var4.getDimensions(var4.getPose());
        int var17 = var2 == var11 ? 0 : 90;
        Vec3D var18 = var2 == var11 ? var5 : new Vec3D(var5.z, var5.y, -var5.x);
        double var19 = (double)var16.width() / 2.0 + (var12 - (double)var16.width()) * var3.x();
        double var21 = (var14 - (double)var16.height()) * var3.y();
        double var23 = 0.5 + var3.z();
        boolean var25 = var11 == EnumDirection.EnumAxis.X;
        Vec3D var26 = new Vec3D((double)var9.getX() + (var25 ? var19 : var23), (double)var9.getY() + var21, (double)var9.getZ() + (var25 ? var23 : var19));
        Vec3D var27 = BlockPortalShape.findCollisionFreePosition(var26, var0, var4, var16);
        return new DimensionTransition(var0, var27, var18, var6 + (float)var17, var7, var8);
    }

    @Override
    public Portal.a getLocalTransition() {
        return Portal.a.CONFUSION;
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        if (var3.nextInt(100) == 0) {
            var1.playLocalSound((double)var2.getX() + 0.5, (double)var2.getY() + 0.5, (double)var2.getZ() + 0.5, SoundEffects.PORTAL_AMBIENT, SoundCategory.BLOCKS, 0.5f, var3.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int var4 = 0; var4 < 4; ++var4) {
            double var5 = (double)var2.getX() + var3.nextDouble();
            double var7 = (double)var2.getY() + var3.nextDouble();
            double var9 = (double)var2.getZ() + var3.nextDouble();
            double var11 = ((double)var3.nextFloat() - 0.5) * 0.5;
            double var13 = ((double)var3.nextFloat() - 0.5) * 0.5;
            double var15 = ((double)var3.nextFloat() - 0.5) * 0.5;
            int var17 = var3.nextInt(2) * 2 - 1;
            if (var1.getBlockState(var2.west()).is(this) || var1.getBlockState(var2.east()).is(this)) {
                var9 = (double)var2.getZ() + 0.5 + 0.25 * (double)var17;
                var15 = var3.nextFloat() * 2.0f * (float)var17;
            } else {
                var5 = (double)var2.getX() + 0.5 + 0.25 * (double)var17;
                var11 = var3.nextFloat() * 2.0f * (float)var17;
            }
            var1.addParticle(Particles.PORTAL, var5, var7, var9, var11, var13, var15);
        }
    }

    @Override
    public ItemStack getCloneItemStack(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        return ItemStack.EMPTY;
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        switch (var1) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch (var0.getValue(AXIS)) {
                    case X: {
                        return (IBlockData)var0.setValue(AXIS, EnumDirection.EnumAxis.Z);
                    }
                    case Z: {
                        return (IBlockData)var0.setValue(AXIS, EnumDirection.EnumAxis.X);
                    }
                }
                return var0;
            }
        }
        return var0;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(AXIS);
    }
}

