/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockRedstoneTorch;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;

public class BlockRedstoneLamp
extends Block {
    public static final MapCodec<BlockRedstoneLamp> CODEC = BlockRedstoneLamp.simpleCodec(BlockRedstoneLamp::new);
    public static final BlockStateBoolean LIT = BlockRedstoneTorch.LIT;

    public MapCodec<BlockRedstoneLamp> codec() {
        return CODEC;
    }

    public BlockRedstoneLamp(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)this.defaultBlockState().setValue(LIT, false));
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return (IBlockData)this.defaultBlockState().setValue(LIT, var0.getLevel().hasNeighborSignal(var0.getClickedPos()));
    }

    @Override
    protected void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, BlockPosition var4, boolean var5) {
        if (var1.isClientSide) {
            return;
        }
        boolean var6 = var0.getValue(LIT);
        if (var6 != var1.hasNeighborSignal(var2)) {
            if (var6) {
                var1.scheduleTick(var2, this, 4);
            } else {
                var1.setBlock(var2, (IBlockData)var0.cycle(LIT), 2);
            }
        }
    }

    @Override
    protected void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (var0.getValue(LIT).booleanValue() && !var1.hasNeighborSignal(var2)) {
            var1.setBlock(var2, (IBlockData)var0.cycle(LIT), 2);
        }
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(LIT);
    }
}

