/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCauldron;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;

public class LayeredCauldronBlock
extends AbstractCauldronBlock {
    public static final MapCodec<LayeredCauldronBlock> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)BiomeBase.Precipitation.CODEC.fieldOf("precipitation").forGetter(var0 -> var0.precipitationType), (App)CauldronInteraction.CODEC.fieldOf("interactions").forGetter(var0 -> var0.interactions), LayeredCauldronBlock.propertiesCodec()).apply((Applicative)var02, LayeredCauldronBlock::new));
    public static final int MIN_FILL_LEVEL = 1;
    public static final int MAX_FILL_LEVEL = 3;
    public static final BlockStateInteger LEVEL = BlockProperties.LEVEL_CAULDRON;
    private static final int BASE_CONTENT_HEIGHT = 6;
    private static final double HEIGHT_PER_LEVEL = 3.0;
    private final BiomeBase.Precipitation precipitationType;

    public MapCodec<LayeredCauldronBlock> codec() {
        return CODEC;
    }

    public LayeredCauldronBlock(BiomeBase.Precipitation var0, CauldronInteraction.a var1, BlockBase.Info var2) {
        super(var2, var1);
        this.precipitationType = var0;
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(LEVEL, 1));
    }

    @Override
    public boolean isFull(IBlockData var0) {
        return var0.getValue(LEVEL) == 3;
    }

    @Override
    protected boolean canReceiveStalactiteDrip(FluidType var0) {
        return var0 == FluidTypes.WATER && this.precipitationType == BiomeBase.Precipitation.RAIN;
    }

    @Override
    protected double getContentHeight(IBlockData var0) {
        return (6.0 + (double)var0.getValue(LEVEL).intValue() * 3.0) / 16.0;
    }

    @Override
    protected void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3) {
        if (!var1.isClientSide && var3.isOnFire() && this.isEntityInsideContent(var0, var2, var3)) {
            var3.clearFire();
            if (var3.mayInteract(var1, var2)) {
                this.handleEntityOnFireInside(var0, var1, var2);
            }
        }
    }

    private void handleEntityOnFireInside(IBlockData var0, World var1, BlockPosition var2) {
        if (this.precipitationType == BiomeBase.Precipitation.SNOW) {
            LayeredCauldronBlock.lowerFillLevel((IBlockData)Blocks.WATER_CAULDRON.defaultBlockState().setValue(LEVEL, var0.getValue(LEVEL)), var1, var2);
        } else {
            LayeredCauldronBlock.lowerFillLevel(var0, var1, var2);
        }
    }

    public static void lowerFillLevel(IBlockData var0, World var1, BlockPosition var2) {
        int var3 = var0.getValue(LEVEL) - 1;
        IBlockData var4 = var3 == 0 ? Blocks.CAULDRON.defaultBlockState() : (IBlockData)var0.setValue(LEVEL, var3);
        var1.setBlockAndUpdate(var2, var4);
        var1.gameEvent(GameEvent.BLOCK_CHANGE, var2, GameEvent.a.of(var4));
    }

    @Override
    public void handlePrecipitation(IBlockData var0, World var1, BlockPosition var2, BiomeBase.Precipitation var3) {
        if (!BlockCauldron.shouldHandlePrecipitation(var1, var3) || var0.getValue(LEVEL) == 3 || var3 != this.precipitationType) {
            return;
        }
        IBlockData var4 = (IBlockData)var0.cycle(LEVEL);
        var1.setBlockAndUpdate(var2, var4);
        var1.gameEvent(GameEvent.BLOCK_CHANGE, var2, GameEvent.a.of(var4));
    }

    @Override
    protected int getAnalogOutputSignal(IBlockData var0, World var1, BlockPosition var2) {
        return var0.getValue(LEVEL);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(LEVEL);
    }

    @Override
    protected void receiveStalactiteDrip(IBlockData var0, World var1, BlockPosition var2, FluidType var3) {
        if (this.isFull(var0)) {
            return;
        }
        IBlockData var4 = (IBlockData)var0.setValue(LEVEL, var0.getValue(LEVEL) + 1);
        var1.setBlockAndUpdate(var2, var4);
        var1.gameEvent(GameEvent.BLOCK_CHANGE, var2, GameEvent.a.of(var4));
        var1.levelEvent(1047, var2, 0);
    }
}

