/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.IBlockData;

public class MultifaceSpreader {
    public static final e[] DEFAULT_SPREAD_ORDER = new e[]{e.SAME_POSITION, e.SAME_PLANE, e.WRAP_AROUND};
    private final b config;

    public MultifaceSpreader(MultifaceBlock var0) {
        this(new a(var0));
    }

    public MultifaceSpreader(b var0) {
        this.config = var0;
    }

    public boolean canSpreadInAnyDirection(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        return EnumDirection.stream().anyMatch(var4 -> this.getSpreadFromFaceTowardDirection(var0, var1, var2, var3, (EnumDirection)var4, this.config::canSpreadInto).isPresent());
    }

    public Optional<c> spreadFromRandomFaceTowardRandomDirection(IBlockData var0, GeneratorAccess var12, BlockPosition var2, RandomSource var3) {
        return EnumDirection.allShuffled(var3).stream().filter(var1 -> this.config.canSpreadFrom(var0, (EnumDirection)var1)).map(var4 -> this.spreadFromFaceTowardRandomDirection(var0, var12, var2, (EnumDirection)var4, var3, false)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    public long spreadAll(IBlockData var0, GeneratorAccess var12, BlockPosition var2, boolean var3) {
        return EnumDirection.stream().filter(var1 -> this.config.canSpreadFrom(var0, (EnumDirection)var1)).map(var4 -> this.spreadFromFaceTowardAllDirections(var0, var12, var2, (EnumDirection)var4, var3)).reduce(0L, Long::sum);
    }

    public Optional<c> spreadFromFaceTowardRandomDirection(IBlockData var0, GeneratorAccess var1, BlockPosition var2, EnumDirection var3, RandomSource var4, boolean var52) {
        return EnumDirection.allShuffled(var4).stream().map(var5 -> this.spreadFromFaceTowardDirection(var0, var1, var2, var3, (EnumDirection)var5, var52)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    private long spreadFromFaceTowardAllDirections(IBlockData var0, GeneratorAccess var1, BlockPosition var2, EnumDirection var3, boolean var4) {
        return EnumDirection.stream().map(var5 -> this.spreadFromFaceTowardDirection(var0, var1, var2, var3, (EnumDirection)var5, var4)).filter(Optional::isPresent).count();
    }

    @VisibleForTesting
    public Optional<c> spreadFromFaceTowardDirection(IBlockData var0, GeneratorAccess var1, BlockPosition var22, EnumDirection var3, EnumDirection var4, boolean var5) {
        return this.getSpreadFromFaceTowardDirection(var0, var1, var22, var3, var4, this.config::canSpreadInto).flatMap(var2 -> this.spreadToFace(var1, (c)var2, var5));
    }

    public Optional<c> getSpreadFromFaceTowardDirection(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3, EnumDirection var4, d var5) {
        if (var4.getAxis() == var3.getAxis()) {
            return Optional.empty();
        }
        if (!(this.config.isOtherBlockValidAsSource(var0) || this.config.hasFace(var0, var3) && !this.config.hasFace(var0, var4))) {
            return Optional.empty();
        }
        for (e var9 : this.config.getSpreadTypes()) {
            c var10 = var9.getSpreadPos(var2, var4, var3);
            if (!var5.test(var1, var2, var10)) continue;
            return Optional.of(var10);
        }
        return Optional.empty();
    }

    public Optional<c> spreadToFace(GeneratorAccess var0, c var1, boolean var2) {
        IBlockData var3 = var0.getBlockState(var1.pos());
        if (this.config.placeBlock(var0, var1, var3, var2)) {
            return Optional.of(var1);
        }
        return Optional.empty();
    }

    public static class a
    implements b {
        protected MultifaceBlock block;

        public a(MultifaceBlock var0) {
            this.block = var0;
        }

        @Override
        @Nullable
        public IBlockData getStateForPlacement(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
            return this.block.getStateForPlacement(var0, var1, var2, var3);
        }

        protected boolean stateCanBeReplaced(IBlockAccess var0, BlockPosition var1, BlockPosition var2, EnumDirection var3, IBlockData var4) {
            return var4.isAir() || var4.is(this.block) || var4.is(Blocks.WATER) && var4.getFluidState().isSource();
        }

        @Override
        public boolean canSpreadInto(IBlockAccess var0, BlockPosition var1, c var2) {
            IBlockData var3 = var0.getBlockState(var2.pos());
            return this.stateCanBeReplaced(var0, var1, var2.pos(), var2.face(), var3) && this.block.isValidStateForPlacement(var0, var3, var2.pos(), var2.face());
        }
    }

    public static interface b {
        @Nullable
        public IBlockData getStateForPlacement(IBlockData var1, IBlockAccess var2, BlockPosition var3, EnumDirection var4);

        public boolean canSpreadInto(IBlockAccess var1, BlockPosition var2, c var3);

        default public e[] getSpreadTypes() {
            return DEFAULT_SPREAD_ORDER;
        }

        default public boolean hasFace(IBlockData var0, EnumDirection var1) {
            return MultifaceBlock.hasFace(var0, var1);
        }

        default public boolean isOtherBlockValidAsSource(IBlockData var0) {
            return false;
        }

        default public boolean canSpreadFrom(IBlockData var0, EnumDirection var1) {
            return this.isOtherBlockValidAsSource(var0) || this.hasFace(var0, var1);
        }

        default public boolean placeBlock(GeneratorAccess var0, c var1, IBlockData var2, boolean var3) {
            IBlockData var4 = this.getStateForPlacement(var2, var0, var1.pos(), var1.face());
            if (var4 != null) {
                if (var3) {
                    var0.getChunk(var1.pos()).markPosForPostprocessing(var1.pos());
                }
                return var0.setBlock(var1.pos(), var4, 2);
            }
            return false;
        }
    }

    @FunctionalInterface
    public static interface d {
        public boolean test(IBlockAccess var1, BlockPosition var2, c var3);
    }

    public static abstract sealed class e
    extends Enum<e> {
        public static final /* enum */ e SAME_POSITION = new e(){

            @Override
            public c getSpreadPos(BlockPosition var0, EnumDirection var1, EnumDirection var2) {
                return new c(var0, var1);
            }
        };
        public static final /* enum */ e SAME_PLANE = new e(){

            @Override
            public c getSpreadPos(BlockPosition var0, EnumDirection var1, EnumDirection var2) {
                return new c(var0.relative(var1), var2);
            }
        };
        public static final /* enum */ e WRAP_AROUND = new e(){

            @Override
            public c getSpreadPos(BlockPosition var0, EnumDirection var1, EnumDirection var2) {
                return new c(var0.relative(var1).relative(var2), var1.getOpposite());
            }
        };
        private static final /* synthetic */ e[] d;

        public static e[] values() {
            return (e[])d.clone();
        }

        public static e valueOf(String var0) {
            return Enum.valueOf(e.class, var0);
        }

        public abstract c getSpreadPos(BlockPosition var1, EnumDirection var2, EnumDirection var3);

        private static /* synthetic */ e[] a() {
            return new e[]{SAME_POSITION, SAME_PLANE, WRAP_AROUND};
        }

        static {
            d = e.a();
        }
    }

    public record c(BlockPosition pos, EnumDirection face) {
    }
}

