/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.monster.EntityRavager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCrops;
import net.minecraft.world.level.block.BlockTallPlant;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class PitcherCropBlock
extends BlockTallPlant
implements IBlockFragilePlantElement {
    public static final MapCodec<PitcherCropBlock> CODEC = PitcherCropBlock.simpleCodec(PitcherCropBlock::new);
    public static final BlockStateInteger AGE = BlockProperties.AGE_4;
    public static final int MAX_AGE = 4;
    private static final int DOUBLE_PLANT_AGE_INTERSECTION = 3;
    private static final int BONEMEAL_INCREASE = 1;
    private static final VoxelShape FULL_UPPER_SHAPE = Block.box(3.0, 0.0, 3.0, 13.0, 15.0, 13.0);
    private static final VoxelShape FULL_LOWER_SHAPE = Block.box(3.0, -1.0, 3.0, 13.0, 16.0, 13.0);
    private static final VoxelShape COLLISION_SHAPE_BULB = Block.box(5.0, -1.0, 5.0, 11.0, 3.0, 11.0);
    private static final VoxelShape COLLISION_SHAPE_CROP = Block.box(3.0, -1.0, 3.0, 13.0, 5.0, 13.0);
    private static final VoxelShape[] UPPER_SHAPE_BY_AGE = new VoxelShape[]{Block.box(3.0, 0.0, 3.0, 13.0, 11.0, 13.0), FULL_UPPER_SHAPE};
    private static final VoxelShape[] LOWER_SHAPE_BY_AGE = new VoxelShape[]{COLLISION_SHAPE_BULB, Block.box(3.0, -1.0, 3.0, 13.0, 14.0, 13.0), FULL_LOWER_SHAPE, FULL_LOWER_SHAPE, FULL_LOWER_SHAPE};

    public MapCodec<PitcherCropBlock> codec() {
        return CODEC;
    }

    public PitcherCropBlock(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return this.defaultBlockState();
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return var0.getValue(HALF) == BlockPropertyDoubleBlockHalf.UPPER ? UPPER_SHAPE_BY_AGE[Math.min(Math.abs(4 - (var0.getValue(AGE) + 1)), UPPER_SHAPE_BY_AGE.length - 1)] : LOWER_SHAPE_BY_AGE[var0.getValue(AGE)];
    }

    @Override
    public VoxelShape getCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        if (var0.getValue(AGE) == 0) {
            return COLLISION_SHAPE_BULB;
        }
        if (var0.getValue(HALF) == BlockPropertyDoubleBlockHalf.LOWER) {
            return COLLISION_SHAPE_CROP;
        }
        return super.getCollisionShape(var0, var1, var2, var3);
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (PitcherCropBlock.isDouble(var0.getValue(AGE))) {
            return super.updateShape(var0, var1, var2, var3, var4, var5);
        }
        return var0.canSurvive(var3, var4) ? var0 : Blocks.AIR.defaultBlockState();
    }

    @Override
    public boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        if (PitcherCropBlock.isLower(var0) && !PitcherCropBlock.sufficientLight(var1, var2)) {
            return false;
        }
        return super.canSurvive(var0, var1, var2);
    }

    @Override
    protected boolean mayPlaceOn(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return var0.is(Blocks.FARMLAND);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(AGE);
        super.createBlockStateDefinition(var0);
    }

    @Override
    public void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3) {
        if (var3 instanceof EntityRavager && var1.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            var1.destroyBlock(var2, true, var3);
        }
        super.entityInside(var0, var1, var2, var3);
    }

    @Override
    public boolean canBeReplaced(IBlockData var0, BlockActionContext var1) {
        return false;
    }

    @Override
    public void setPlacedBy(World var0, BlockPosition var1, IBlockData var2, EntityLiving var3, ItemStack var4) {
    }

    @Override
    public boolean isRandomlyTicking(IBlockData var0) {
        return var0.getValue(HALF) == BlockPropertyDoubleBlockHalf.LOWER && !this.isMaxAge(var0);
    }

    @Override
    public void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        boolean var5;
        float var4 = BlockCrops.getGrowthSpeed(this, var1, var2);
        boolean bl = var5 = var3.nextInt((int)(25.0f / var4) + 1) == 0;
        if (var5) {
            this.grow(var1, var0, var2, 1);
        }
    }

    private void grow(WorldServer var0, IBlockData var1, BlockPosition var2, int var3) {
        int var4 = Math.min(var1.getValue(AGE) + var3, 4);
        if (!this.canGrow(var0, var2, var1, var4)) {
            return;
        }
        IBlockData var5 = (IBlockData)var1.setValue(AGE, var4);
        var0.setBlock(var2, var5, 2);
        if (PitcherCropBlock.isDouble(var4)) {
            var0.setBlock(var2.above(), (IBlockData)var5.setValue(HALF, BlockPropertyDoubleBlockHalf.UPPER), 3);
        }
    }

    private static boolean canGrowInto(IWorldReader var0, BlockPosition var1) {
        IBlockData var2 = var0.getBlockState(var1);
        return var2.isAir() || var2.is(Blocks.PITCHER_CROP);
    }

    private static boolean sufficientLight(IWorldReader var0, BlockPosition var1) {
        return BlockCrops.hasSufficientLight(var0, var1);
    }

    private static boolean isLower(IBlockData var0) {
        return var0.is(Blocks.PITCHER_CROP) && var0.getValue(HALF) == BlockPropertyDoubleBlockHalf.LOWER;
    }

    private static boolean isDouble(int var0) {
        return var0 >= 3;
    }

    private boolean canGrow(IWorldReader var0, BlockPosition var1, IBlockData var2, int var3) {
        return !this.isMaxAge(var2) && PitcherCropBlock.sufficientLight(var0, var1) && (!PitcherCropBlock.isDouble(var3) || PitcherCropBlock.canGrowInto(var0, var1.above()));
    }

    private boolean isMaxAge(IBlockData var0) {
        return var0.getValue(AGE) >= 4;
    }

    @Nullable
    private a getLowerHalf(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        if (PitcherCropBlock.isLower(var2)) {
            return new a(var1, var2);
        }
        BlockPosition var3 = var1.below();
        IBlockData var4 = var0.getBlockState(var3);
        if (PitcherCropBlock.isLower(var4)) {
            return new a(var3, var4);
        }
        return null;
    }

    @Override
    public boolean isValidBonemealTarget(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        a var3 = this.getLowerHalf(var0, var1, var2);
        if (var3 == null) {
            return false;
        }
        return this.canGrow(var0, var3.pos, var3.state, var3.state.getValue(AGE) + 1);
    }

    @Override
    public boolean isBonemealSuccess(World var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        return true;
    }

    @Override
    public void performBonemeal(WorldServer var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        a var4 = this.getLowerHalf(var0, var2, var3);
        if (var4 == null) {
            return;
        }
        this.grow(var0, var4.state, var4.pos, 1);
    }

    static final class a
    extends Record {
        final BlockPosition pos;
        final IBlockData state;

        a(BlockPosition var0, IBlockData var1) {
            this.pos = var0;
            this.state = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "pos;state", "pos", "state"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "pos;state", "pos", "state"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "pos;state", "pos", "state"}, this, var0);
        }

        public BlockPosition pos() {
            return this.pos;
        }

        public IBlockData state() {
            return this.state;
        }
    }
}

