/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.SculkBehaviour;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.material.FluidTypes;

public class SculkBlock
extends DropExperienceBlock
implements SculkBehaviour {
    public static final MapCodec<SculkBlock> CODEC = SculkBlock.simpleCodec(SculkBlock::new);

    public MapCodec<SculkBlock> codec() {
        return CODEC;
    }

    public SculkBlock(BlockBase.Info var0) {
        super(ConstantInt.of(1), var0);
    }

    @Override
    public int attemptUseCharge(SculkSpreader.a var0, GeneratorAccess var1, BlockPosition var2, RandomSource var3, SculkSpreader var4, boolean var5) {
        int var6 = var0.getCharge();
        if (var6 == 0 || var3.nextInt(var4.chargeDecayRate()) != 0) {
            return var6;
        }
        BlockPosition var7 = var0.getPos();
        boolean var8 = var7.closerThan(var2, var4.noGrowthRadius());
        if (var8 || !SculkBlock.canPlaceGrowth(var1, var7)) {
            if (var3.nextInt(var4.additionalDecayRate()) != 0) {
                return var6;
            }
            return var6 - (var8 ? 1 : SculkBlock.getDecayPenalty(var4, var7, var2, var6));
        }
        int var9 = var4.growthSpawnCost();
        if (var3.nextInt(var9) < var6) {
            BlockPosition var10 = var7.above();
            IBlockData var11 = this.getRandomGrowthState(var1, var10, var3, var4.isWorldGeneration());
            var1.setBlock(var10, var11, 3);
            var1.playSound(null, var7, var11.getSoundType().getPlaceSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        return Math.max(0, var6 - var9);
    }

    private static int getDecayPenalty(SculkSpreader var0, BlockPosition var1, BlockPosition var2, int var3) {
        int var4 = var0.noGrowthRadius();
        float var5 = MathHelper.square((float)Math.sqrt(var1.distSqr(var2)) - (float)var4);
        int var6 = MathHelper.square(24 - var4);
        float var7 = Math.min(1.0f, var5 / (float)var6);
        return Math.max(1, (int)((float)var3 * var7 * 0.5f));
    }

    private IBlockData getRandomGrowthState(GeneratorAccess var0, BlockPosition var1, RandomSource var2, boolean var3) {
        IBlockData var4 = var2.nextInt(11) == 0 ? (IBlockData)Blocks.SCULK_SHRIEKER.defaultBlockState().setValue(SculkShriekerBlock.CAN_SUMMON, var3) : Blocks.SCULK_SENSOR.defaultBlockState();
        if (var4.hasProperty(BlockProperties.WATERLOGGED) && !var0.getFluidState(var1).isEmpty()) {
            return (IBlockData)var4.setValue(BlockProperties.WATERLOGGED, true);
        }
        return var4;
    }

    private static boolean canPlaceGrowth(GeneratorAccess var0, BlockPosition var1) {
        IBlockData var2 = var0.getBlockState(var1.above());
        if (!(var2.isAir() || var2.is(Blocks.WATER) && var2.getFluidState().is(FluidTypes.WATER))) {
            return false;
        }
        int var3 = 0;
        for (BlockPosition var5 : BlockPosition.betweenClosed(var1.offset(-4, 0, -4), var1.offset(4, 2, 4))) {
            IBlockData var6 = var0.getBlockState(var5);
            if (var6.is(Blocks.SCULK_SENSOR) || var6.is(Blocks.SCULK_SHRIEKER)) {
                ++var3;
            }
            if (var3 <= 2) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canChangeBlockStateOnSpread() {
        return false;
    }
}

