/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;

public abstract class ContainerOpenersCounter {
    private static final int CHECK_TICK_DELAY = 5;
    private int openCount;
    private double maxInteractionRange;

    protected abstract void onOpen(World var1, BlockPosition var2, IBlockData var3);

    protected abstract void onClose(World var1, BlockPosition var2, IBlockData var3);

    protected abstract void openerCountChanged(World var1, BlockPosition var2, IBlockData var3, int var4, int var5);

    protected abstract boolean isOwnContainer(EntityHuman var1);

    public void incrementOpeners(EntityHuman var0, World var1, BlockPosition var2, IBlockData var3) {
        int var4;
        if ((var4 = this.openCount++) == 0) {
            this.onOpen(var1, var2, var3);
            var1.gameEvent((Entity)var0, GameEvent.CONTAINER_OPEN, var2);
            ContainerOpenersCounter.scheduleRecheck(var1, var2, var3);
        }
        this.openerCountChanged(var1, var2, var3, var4, this.openCount);
        this.maxInteractionRange = Math.max(var0.blockInteractionRange(), this.maxInteractionRange);
    }

    public void decrementOpeners(EntityHuman var0, World var1, BlockPosition var2, IBlockData var3) {
        int var4 = this.openCount--;
        if (this.openCount == 0) {
            this.onClose(var1, var2, var3);
            var1.gameEvent((Entity)var0, GameEvent.CONTAINER_CLOSE, var2);
            this.maxInteractionRange = 0.0;
        }
        this.openerCountChanged(var1, var2, var3, var4, this.openCount);
    }

    private List<EntityHuman> getPlayersWithContainerOpen(World var0, BlockPosition var1) {
        double var2 = this.maxInteractionRange + 4.0;
        AxisAlignedBB var4 = new AxisAlignedBB(var1).inflate(var2);
        return var0.getEntities(EntityTypeTest.forClass(EntityHuman.class), var4, this::isOwnContainer);
    }

    public void recheckOpeners(World var0, BlockPosition var1, IBlockData var2) {
        List<EntityHuman> var3 = this.getPlayersWithContainerOpen(var0, var1);
        this.maxInteractionRange = 0.0;
        for (EntityHuman var5 : var3) {
            this.maxInteractionRange = Math.max(var5.blockInteractionRange(), this.maxInteractionRange);
        }
        int var5 = this.openCount;
        int var4 = var3.size();
        if (var5 != var4) {
            boolean var7;
            boolean var6 = var4 != 0;
            boolean bl = var7 = var5 != 0;
            if (var6 && !var7) {
                this.onOpen(var0, var1, var2);
                var0.gameEvent(null, GameEvent.CONTAINER_OPEN, var1);
            } else if (!var6) {
                this.onClose(var0, var1, var2);
                var0.gameEvent(null, GameEvent.CONTAINER_CLOSE, var1);
            }
            this.openCount = var4;
        }
        this.openerCountChanged(var0, var1, var2, var5, var4);
        if (var4 > 0) {
            ContainerOpenersCounter.scheduleRecheck(var0, var1, var2);
        }
    }

    public int getOpenerCount() {
        return this.openCount;
    }

    private static void scheduleRecheck(World var0, BlockPosition var1, IBlockData var2) {
        var0.scheduleTick(var1, var2.getBlock(), 5);
    }
}

