/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public record PotDecorations(Optional<Item> back, Optional<Item> left, Optional<Item> right, Optional<Item> front) {
    public static final PotDecorations EMPTY = new PotDecorations(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    public static final Codec<PotDecorations> CODEC = BuiltInRegistries.ITEM.byNameCodec().sizeLimitedListOf(4).xmap(PotDecorations::new, PotDecorations::ordered);
    public static final StreamCodec<RegistryFriendlyByteBuf, PotDecorations> STREAM_CODEC = ByteBufCodecs.registry(Registries.ITEM).apply(ByteBufCodecs.list(4)).map(PotDecorations::new, PotDecorations::ordered);

    private PotDecorations(List<Item> var0) {
        this(PotDecorations.getItem(var0, 0), PotDecorations.getItem(var0, 1), PotDecorations.getItem(var0, 2), PotDecorations.getItem(var0, 3));
    }

    public PotDecorations(Item var0, Item var1, Item var2, Item var3) {
        this(List.of(var0, var1, var2, var3));
    }

    private static Optional<Item> getItem(List<Item> var0, int var1) {
        if (var1 >= var0.size()) {
            return Optional.empty();
        }
        Item var2 = var0.get(var1);
        return var2 == Items.BRICK ? Optional.empty() : Optional.of(var2);
    }

    public NBTTagCompound save(NBTTagCompound var0) {
        if (this.equals(EMPTY)) {
            return var0;
        }
        var0.put("sherds", (NBTBase)CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this).getOrThrow());
        return var0;
    }

    public List<Item> ordered() {
        return Stream.of(this.back, this.left, this.right, this.front).map(var0 -> var0.orElse(Items.BRICK)).toList();
    }

    public static PotDecorations load(@Nullable NBTTagCompound var0) {
        if (var0 == null || !var0.contains("sherds")) {
            return EMPTY;
        }
        return CODEC.parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var0.get("sherds")).result().orElse(EMPTY);
    }
}

