/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.logging.LogUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.storage.RegionFileBitSet;
import net.minecraft.world.level.chunk.storage.RegionFileCompression;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import org.slf4j.Logger;

public class RegionFile
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int SECTOR_BYTES = 4096;
    @VisibleForTesting
    protected static final int SECTOR_INTS = 1024;
    private static final int CHUNK_HEADER_SIZE = 5;
    private static final int HEADER_OFFSET = 0;
    private static final ByteBuffer PADDING_BUFFER = ByteBuffer.allocateDirect(1);
    private static final String EXTERNAL_FILE_EXTENSION = ".mcc";
    private static final int EXTERNAL_STREAM_FLAG = 128;
    private static final int EXTERNAL_CHUNK_THRESHOLD = 256;
    private static final int CHUNK_NOT_PRESENT = 0;
    final RegionStorageInfo info;
    private final Path path;
    private final FileChannel file;
    private final Path externalFileDir;
    final RegionFileCompression version;
    private final ByteBuffer header = ByteBuffer.allocateDirect(8192);
    private final IntBuffer offsets;
    private final IntBuffer timestamps;
    @VisibleForTesting
    protected final RegionFileBitSet usedSectors = new RegionFileBitSet();

    public RegionFile(RegionStorageInfo var0, Path var1, Path var2, boolean var3) throws IOException {
        this(var0, var1, var2, RegionFileCompression.getSelected(), var3);
    }

    public RegionFile(RegionStorageInfo var0, Path var1, Path var2, RegionFileCompression var3, boolean var4) throws IOException {
        this.info = var0;
        this.path = var1;
        this.version = var3;
        if (!Files.isDirectory(var2, new LinkOption[0])) {
            throw new IllegalArgumentException("Expected directory, got " + String.valueOf(var2.toAbsolutePath()));
        }
        this.externalFileDir = var2;
        this.offsets = this.header.asIntBuffer();
        this.offsets.limit(1024);
        this.header.position(4096);
        this.timestamps = this.header.asIntBuffer();
        this.file = var4 ? FileChannel.open(var1, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.DSYNC) : FileChannel.open(var1, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        this.usedSectors.force(0, 2);
        this.header.position(0);
        int var5 = this.file.read(this.header, 0L);
        if (var5 != -1) {
            if (var5 != 8192) {
                LOGGER.warn("Region file {} has truncated header: {}", (Object)var1, (Object)var5);
            }
            long var6 = Files.size(var1);
            for (int var8 = 0; var8 < 1024; ++var8) {
                int var9 = this.offsets.get(var8);
                if (var9 == 0) continue;
                int var10 = RegionFile.getSectorNumber(var9);
                int var11 = RegionFile.getNumSectors(var9);
                if (var10 < 2) {
                    LOGGER.warn("Region file {} has invalid sector at index: {}; sector {} overlaps with header", new Object[]{var1, var8, var10});
                    this.offsets.put(var8, 0);
                    continue;
                }
                if (var11 == 0) {
                    LOGGER.warn("Region file {} has an invalid sector at index: {}; size has to be > 0", (Object)var1, (Object)var8);
                    this.offsets.put(var8, 0);
                    continue;
                }
                if ((long)var10 * 4096L > var6) {
                    LOGGER.warn("Region file {} has an invalid sector at index: {}; sector {} is out of bounds", new Object[]{var1, var8, var10});
                    this.offsets.put(var8, 0);
                    continue;
                }
                this.usedSectors.force(var10, var11);
            }
        }
    }

    public Path getPath() {
        return this.path;
    }

    private Path getExternalChunkPath(ChunkCoordIntPair var0) {
        String var1 = "c." + var0.x + "." + var0.z + EXTERNAL_FILE_EXTENSION;
        return this.externalFileDir.resolve(var1);
    }

    @Nullable
    public synchronized DataInputStream getChunkDataInputStream(ChunkCoordIntPair var0) throws IOException {
        int var1 = this.getOffset(var0);
        if (var1 == 0) {
            return null;
        }
        int var2 = RegionFile.getSectorNumber(var1);
        int var3 = RegionFile.getNumSectors(var1);
        int var4 = var3 * 4096;
        ByteBuffer var5 = ByteBuffer.allocate(var4);
        this.file.read(var5, var2 * 4096);
        var5.flip();
        if (var5.remaining() < 5) {
            LOGGER.error("Chunk {} header is truncated: expected {} but read {}", new Object[]{var0, var4, var5.remaining()});
            return null;
        }
        int var6 = var5.getInt();
        byte var7 = var5.get();
        if (var6 == 0) {
            LOGGER.warn("Chunk {} is allocated, but stream is missing", (Object)var0);
            return null;
        }
        int var8 = var6 - 1;
        if (RegionFile.isExternalStreamChunk(var7)) {
            if (var8 != 0) {
                LOGGER.warn("Chunk has both internal and external streams");
            }
            return this.createExternalChunkInputStream(var0, RegionFile.getExternalChunkVersion(var7));
        }
        if (var8 > var5.remaining()) {
            LOGGER.error("Chunk {} stream is truncated: expected {} but read {}", new Object[]{var0, var8, var5.remaining()});
            return null;
        }
        if (var8 < 0) {
            LOGGER.error("Declared size {} of chunk {} is negative", (Object)var6, (Object)var0);
            return null;
        }
        JvmProfiler.INSTANCE.onRegionFileRead(this.info, var0, this.version, var8);
        return this.createChunkInputStream(var0, var7, RegionFile.createStream(var5, var8));
    }

    private static int getTimestamp() {
        return (int)(SystemUtils.getEpochMillis() / 1000L);
    }

    private static boolean isExternalStreamChunk(byte var0) {
        return (var0 & 0x80) != 0;
    }

    private static byte getExternalChunkVersion(byte var0) {
        return (byte)(var0 & 0xFFFFFF7F);
    }

    @Nullable
    private DataInputStream createChunkInputStream(ChunkCoordIntPair var0, byte var1, InputStream var2) throws IOException {
        RegionFileCompression var3 = RegionFileCompression.fromId(var1);
        if (var3 == RegionFileCompression.VERSION_CUSTOM) {
            String var4 = new DataInputStream(var2).readUTF();
            MinecraftKey var5 = MinecraftKey.tryParse(var4);
            if (var5 != null) {
                LOGGER.error("Unrecognized custom compression {}", (Object)var5);
                return null;
            }
            LOGGER.error("Invalid custom compression id {}", (Object)var4);
            return null;
        }
        if (var3 == null) {
            LOGGER.error("Chunk {} has invalid chunk stream version {}", (Object)var0, (Object)var1);
            return null;
        }
        return new DataInputStream(var3.wrap(var2));
    }

    @Nullable
    private DataInputStream createExternalChunkInputStream(ChunkCoordIntPair var0, byte var1) throws IOException {
        Path var2 = this.getExternalChunkPath(var0);
        if (!Files.isRegularFile(var2, new LinkOption[0])) {
            LOGGER.error("External chunk path {} is not file", (Object)var2);
            return null;
        }
        return this.createChunkInputStream(var0, var1, Files.newInputStream(var2, new OpenOption[0]));
    }

    private static ByteArrayInputStream createStream(ByteBuffer var0, int var1) {
        return new ByteArrayInputStream(var0.array(), var0.position(), var1);
    }

    private int packSectorOffset(int var0, int var1) {
        return var0 << 8 | var1;
    }

    private static int getNumSectors(int var0) {
        return var0 & 0xFF;
    }

    private static int getSectorNumber(int var0) {
        return var0 >> 8 & 0xFFFFFF;
    }

    private static int sizeToSectors(int var0) {
        return (var0 + 4096 - 1) / 4096;
    }

    public boolean doesChunkExist(ChunkCoordIntPair var0) {
        int var1 = this.getOffset(var0);
        if (var1 == 0) {
            return false;
        }
        int var2 = RegionFile.getSectorNumber(var1);
        int var3 = RegionFile.getNumSectors(var1);
        ByteBuffer var4 = ByteBuffer.allocate(5);
        try {
            this.file.read(var4, var2 * 4096);
            var4.flip();
            if (var4.remaining() != 5) {
                return false;
            }
            int var5 = var4.getInt();
            byte var6 = var4.get();
            if (RegionFile.isExternalStreamChunk(var6)) {
                if (!RegionFileCompression.isValidVersion(RegionFile.getExternalChunkVersion(var6))) {
                    return false;
                }
                if (!Files.isRegularFile(this.getExternalChunkPath(var0), new LinkOption[0])) {
                    return false;
                }
            } else {
                if (!RegionFileCompression.isValidVersion(var6)) {
                    return false;
                }
                if (var5 == 0) {
                    return false;
                }
                int var7 = var5 - 1;
                if (var7 < 0 || var7 > 4096 * var3) {
                    return false;
                }
            }
        }
        catch (IOException var5) {
            return false;
        }
        return true;
    }

    public DataOutputStream getChunkDataOutputStream(ChunkCoordIntPair var0) throws IOException {
        return new DataOutputStream(this.version.wrap(new ChunkBuffer(var0)));
    }

    public void flush() throws IOException {
        this.file.force(true);
    }

    public void clear(ChunkCoordIntPair var0) throws IOException {
        int var1 = RegionFile.getOffsetIndex(var0);
        int var2 = this.offsets.get(var1);
        if (var2 == 0) {
            return;
        }
        this.offsets.put(var1, 0);
        this.timestamps.put(var1, RegionFile.getTimestamp());
        this.writeHeader();
        Files.deleteIfExists(this.getExternalChunkPath(var0));
        this.usedSectors.free(RegionFile.getSectorNumber(var2), RegionFile.getNumSectors(var2));
    }

    protected synchronized void write(ChunkCoordIntPair var0, ByteBuffer var1) throws IOException {
        b var9;
        int var8;
        int var2 = RegionFile.getOffsetIndex(var0);
        int var3 = this.offsets.get(var2);
        int var4 = RegionFile.getSectorNumber(var3);
        int var5 = RegionFile.getNumSectors(var3);
        int var6 = var1.remaining();
        int var7 = RegionFile.sizeToSectors(var6);
        if (var7 >= 256) {
            Path var10 = this.getExternalChunkPath(var0);
            LOGGER.warn("Saving oversized chunk {} ({} bytes} to external file {}", new Object[]{var0, var6, var10});
            var7 = 1;
            var8 = this.usedSectors.allocate(var7);
            var9 = this.writeToExternalFile(var10, var1);
            ByteBuffer var11 = this.createExternalStub();
            this.file.write(var11, var8 * 4096);
        } else {
            var8 = this.usedSectors.allocate(var7);
            var9 = () -> Files.deleteIfExists(this.getExternalChunkPath(var0));
            this.file.write(var1, var8 * 4096);
        }
        this.offsets.put(var2, this.packSectorOffset(var8, var7));
        this.timestamps.put(var2, RegionFile.getTimestamp());
        this.writeHeader();
        var9.run();
        if (var4 != 0) {
            this.usedSectors.free(var4, var5);
        }
    }

    private ByteBuffer createExternalStub() {
        ByteBuffer var0 = ByteBuffer.allocate(5);
        var0.putInt(1);
        var0.put((byte)(this.version.getId() | 0x80));
        var0.flip();
        return var0;
    }

    private b writeToExternalFile(Path var0, ByteBuffer var1) throws IOException {
        Path var2 = Files.createTempFile(this.externalFileDir, "tmp", null, new FileAttribute[0]);
        try (FileChannel var3 = FileChannel.open(var2, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            var1.position(5);
            var3.write(var1);
        }
        return () -> Files.move(var2, var0, StandardCopyOption.REPLACE_EXISTING);
    }

    private void writeHeader() throws IOException {
        this.header.position(0);
        this.file.write(this.header, 0L);
    }

    private int getOffset(ChunkCoordIntPair var0) {
        return this.offsets.get(RegionFile.getOffsetIndex(var0));
    }

    public boolean hasChunk(ChunkCoordIntPair var0) {
        return this.getOffset(var0) != 0;
    }

    private static int getOffsetIndex(ChunkCoordIntPair var0) {
        return var0.getRegionLocalX() + var0.getRegionLocalZ() * 32;
    }

    @Override
    public void close() throws IOException {
        try {
            this.padToFullSector();
        }
        finally {
            try {
                this.file.force(true);
            }
            finally {
                this.file.close();
            }
        }
    }

    private void padToFullSector() throws IOException {
        int var1;
        int var0 = (int)this.file.size();
        if (var0 != (var1 = RegionFile.sizeToSectors(var0) * 4096)) {
            ByteBuffer var2 = PADDING_BUFFER.duplicate();
            var2.position(0);
            this.file.write(var2, var1 - 1);
        }
    }

    class ChunkBuffer
    extends ByteArrayOutputStream {
        private final ChunkCoordIntPair pos;

        public ChunkBuffer(ChunkCoordIntPair var1) {
            super(8096);
            super.write(0);
            super.write(0);
            super.write(0);
            super.write(0);
            super.write(RegionFile.this.version.getId());
            this.pos = var1;
        }

        @Override
        public void close() throws IOException {
            ByteBuffer var0 = ByteBuffer.wrap(this.buf, 0, this.count);
            int var1 = this.count - 5 + 1;
            JvmProfiler.INSTANCE.onRegionFileWrite(RegionFile.this.info, this.pos, RegionFile.this.version, var1);
            var0.putInt(0, var1);
            RegionFile.this.write(this.pos, var0);
        }
    }

    static interface b {
        public void run() throws IOException;
    }
}

