/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import javax.annotation.Nullable;
import net.minecraft.FileUtils;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.util.ExceptionSuppressor;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;

public final class RegionFileCache
implements AutoCloseable {
    public static final String ANVIL_EXTENSION = ".mca";
    private static final int MAX_CACHE_SIZE = 256;
    public final Long2ObjectLinkedOpenHashMap<RegionFile> regionCache = new Long2ObjectLinkedOpenHashMap();
    private final RegionStorageInfo info;
    private final Path folder;
    private final boolean sync;

    RegionFileCache(RegionStorageInfo var0, Path var1, boolean var2) {
        this.folder = var1;
        this.sync = var2;
        this.info = var0;
    }

    private RegionFile getRegionFile(ChunkCoordIntPair var0) throws IOException {
        long var1 = ChunkCoordIntPair.asLong(var0.getRegionX(), var0.getRegionZ());
        RegionFile var3 = (RegionFile)this.regionCache.getAndMoveToFirst(var1);
        if (var3 != null) {
            return var3;
        }
        if (this.regionCache.size() >= 256) {
            ((RegionFile)this.regionCache.removeLast()).close();
        }
        FileUtils.createDirectoriesSafe(this.folder);
        Path var4 = this.folder.resolve("r." + var0.getRegionX() + "." + var0.getRegionZ() + ANVIL_EXTENSION);
        RegionFile var5 = new RegionFile(this.info, var4, this.folder, this.sync);
        this.regionCache.putAndMoveToFirst(var1, (Object)var5);
        return var5;
    }

    @Nullable
    public NBTTagCompound read(ChunkCoordIntPair var0) throws IOException {
        RegionFile var1 = this.getRegionFile(var0);
        try (DataInputStream var2 = var1.getChunkDataInputStream(var0);){
            if (var2 == null) {
                NBTTagCompound nBTTagCompound = null;
                return nBTTagCompound;
            }
            NBTTagCompound nBTTagCompound = NBTCompressedStreamTools.read(var2);
            return nBTTagCompound;
        }
    }

    public void scanChunk(ChunkCoordIntPair var0, StreamTagVisitor var1) throws IOException {
        RegionFile var2 = this.getRegionFile(var0);
        try (DataInputStream var3 = var2.getChunkDataInputStream(var0);){
            if (var3 != null) {
                NBTCompressedStreamTools.parse(var3, var1, NBTReadLimiter.unlimitedHeap());
            }
        }
    }

    protected void write(ChunkCoordIntPair var0, @Nullable NBTTagCompound var1) throws IOException {
        RegionFile var2 = this.getRegionFile(var0);
        if (var1 == null) {
            var2.clear(var0);
        } else {
            try (DataOutputStream var3 = var2.getChunkDataOutputStream(var0);){
                NBTCompressedStreamTools.write(var1, var3);
            }
        }
    }

    @Override
    public void close() throws IOException {
        ExceptionSuppressor<IOException> var0 = new ExceptionSuppressor<IOException>();
        for (RegionFile var2 : this.regionCache.values()) {
            try {
                var2.close();
            }
            catch (IOException var3) {
                var0.add(var3);
            }
        }
        var0.throwIfPresent();
    }

    public void flush() throws IOException {
        for (RegionFile var1 : this.regionCache.values()) {
            var1.flush();
        }
    }

    public RegionStorageInfo info() {
        return this.info;
    }
}

