/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent.vibrations;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;

public record VibrationInfo(Holder<GameEvent> gameEvent, float distance, Vec3D pos, @Nullable UUID uuid, @Nullable UUID projectileOwnerUuid, @Nullable Entity entity) {
    public static final Codec<VibrationInfo> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)GameEvent.CODEC.fieldOf("game_event").forGetter(VibrationInfo::gameEvent), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).fieldOf("distance").forGetter(VibrationInfo::distance), (App)Vec3D.CODEC.fieldOf("pos").forGetter(VibrationInfo::pos), (App)UUIDUtil.CODEC.lenientOptionalFieldOf("source").forGetter(var0 -> Optional.ofNullable(var0.uuid())), (App)UUIDUtil.CODEC.lenientOptionalFieldOf("projectile_owner").forGetter(var0 -> Optional.ofNullable(var0.projectileOwnerUuid()))).apply((Applicative)var02, (var0, var1, var2, var3, var4) -> new VibrationInfo((Holder<GameEvent>)var0, var1.floatValue(), (Vec3D)var2, var3.orElse(null), var4.orElse(null))));

    public VibrationInfo(Holder<GameEvent> var0, float var1, Vec3D var2, @Nullable UUID var3, @Nullable UUID var4) {
        this(var0, var1, var2, var3, var4, null);
    }

    public VibrationInfo(Holder<GameEvent> var0, float var1, Vec3D var2, @Nullable Entity var3) {
        this(var0, var1, var2, var3 == null ? null : var3.getUUID(), VibrationInfo.getProjectileOwner(var3), var3);
    }

    @Nullable
    private static UUID getProjectileOwner(@Nullable Entity var0) {
        IProjectile var1;
        if (var0 instanceof IProjectile && (var1 = (IProjectile)var0).getOwner() != null) {
            return var1.getOwner().getUUID();
        }
        return null;
    }

    public Optional<Entity> getEntity(WorldServer var0) {
        return Optional.ofNullable(this.entity).or(() -> Optional.ofNullable(this.uuid).map(var0::getEntity));
    }

    public Optional<Entity> getProjectileOwner(WorldServer var02) {
        return this.getEntity(var02).filter(var0 -> var0 instanceof IProjectile).map(var0 -> (IProjectile)var0).map(IProjectile::getOwner).or(() -> Optional.ofNullable(this.projectileOwnerUuid).map(var02::getEntity));
    }
}

