/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.monster.EntityMonsterPatrolling;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.HeightMap;

public class MobSpawnerPatrol
implements MobSpawner {
    private int nextTick;

    @Override
    public int tick(WorldServer var0, boolean var1, boolean var2) {
        if (!var1) {
            return 0;
        }
        if (!var0.getGameRules().getBoolean(GameRules.RULE_DO_PATROL_SPAWNING)) {
            return 0;
        }
        RandomSource var3 = var0.random;
        --this.nextTick;
        if (this.nextTick > 0) {
            return 0;
        }
        this.nextTick += 12000 + var3.nextInt(1200);
        long var4 = var0.getDayTime() / 24000L;
        if (var4 < 5L || !var0.isDay()) {
            return 0;
        }
        if (var3.nextInt(5) != 0) {
            return 0;
        }
        int var6 = var0.players().size();
        if (var6 < 1) {
            return 0;
        }
        EntityHuman var7 = var0.players().get(var3.nextInt(var6));
        if (var7.isSpectator()) {
            return 0;
        }
        if (var0.isCloseToVillage(var7.blockPosition(), 2)) {
            return 0;
        }
        int var8 = (24 + var3.nextInt(24)) * (var3.nextBoolean() ? -1 : 1);
        int var9 = (24 + var3.nextInt(24)) * (var3.nextBoolean() ? -1 : 1);
        BlockPosition.MutableBlockPosition var10 = var7.blockPosition().mutable().move(var8, 0, var9);
        int var11 = 10;
        if (!var0.hasChunksAt(var10.getX() - 10, var10.getZ() - 10, var10.getX() + 10, var10.getZ() + 10)) {
            return 0;
        }
        Holder<BiomeBase> var12 = var0.getBiome(var10);
        if (var12.is(BiomeTags.WITHOUT_PATROL_SPAWNS)) {
            return 0;
        }
        int var13 = 0;
        int var14 = (int)Math.ceil(var0.getCurrentDifficultyAt(var10).getEffectiveDifficulty()) + 1;
        for (int var15 = 0; var15 < var14; ++var15) {
            ++var13;
            var10.setY(var0.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, var10).getY());
            if (var15 == 0) {
                if (!this.spawnPatrolMember(var0, var10, var3, true)) {
                    break;
                }
            } else {
                this.spawnPatrolMember(var0, var10, var3, false);
            }
            var10.setX(var10.getX() + var3.nextInt(5) - var3.nextInt(5));
            var10.setZ(var10.getZ() + var3.nextInt(5) - var3.nextInt(5));
        }
        return var13;
    }

    private boolean spawnPatrolMember(WorldServer var0, BlockPosition var1, RandomSource var2, boolean var3) {
        IBlockData var4 = var0.getBlockState(var1);
        if (!SpawnerCreature.isValidEmptySpawnBlock(var0, var1, var4, var4.getFluidState(), EntityTypes.PILLAGER)) {
            return false;
        }
        if (!EntityMonsterPatrolling.checkPatrollingMonsterSpawnRules(EntityTypes.PILLAGER, var0, EnumMobSpawn.PATROL, var1, var2)) {
            return false;
        }
        EntityMonsterPatrolling var5 = EntityTypes.PILLAGER.create(var0);
        if (var5 != null) {
            if (var3) {
                var5.setPatrolLeader(true);
                var5.findPatrolTarget();
            }
            var5.setPos(var1.getX(), var1.getY(), var1.getZ());
            var5.finalizeSpawn(var0, var0.getCurrentDifficultyAt(var1), EnumMobSpawn.PATROL, null);
            var0.addFreshEntityWithPassengers(var5);
            return true;
        }
        return false;
    }
}

