/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.featuresize;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.OptionalInt;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSizeType;

public class FeatureSizeTwoLayers
extends FeatureSize {
    public static final MapCodec<FeatureSizeTwoLayers> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Codec.intRange((int)0, (int)81).fieldOf("limit").orElse((Object)1).forGetter(var0 -> var0.limit), (App)Codec.intRange((int)0, (int)16).fieldOf("lower_size").orElse((Object)0).forGetter(var0 -> var0.lowerSize), (App)Codec.intRange((int)0, (int)16).fieldOf("upper_size").orElse((Object)1).forGetter(var0 -> var0.upperSize), FeatureSizeTwoLayers.minClippedHeightCodec()).apply((Applicative)var02, FeatureSizeTwoLayers::new));
    private final int limit;
    private final int lowerSize;
    private final int upperSize;

    public FeatureSizeTwoLayers(int var0, int var1, int var2) {
        this(var0, var1, var2, OptionalInt.empty());
    }

    public FeatureSizeTwoLayers(int var0, int var1, int var2, OptionalInt var3) {
        super(var3);
        this.limit = var0;
        this.lowerSize = var1;
        this.upperSize = var2;
    }

    @Override
    protected FeatureSizeType<?> type() {
        return FeatureSizeType.TWO_LAYERS_FEATURE_SIZE;
    }

    @Override
    public int getSizeAtHeight(int var0, int var1) {
        return var1 < this.limit ? this.lowerSize : this.upperSize;
    }
}

