/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.presets;

import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterLists;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.biome.WorldChunkManagerHell;
import net.minecraft.world.level.biome.WorldChunkManagerMultiNoise;
import net.minecraft.world.level.biome.WorldChunkManagerTheEnd;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.ChunkProviderDebug;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.flat.GeneratorSettingsFlat;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public class WorldPresets {
    public static final ResourceKey<WorldPreset> NORMAL = WorldPresets.register("normal");
    public static final ResourceKey<WorldPreset> FLAT = WorldPresets.register("flat");
    public static final ResourceKey<WorldPreset> LARGE_BIOMES = WorldPresets.register("large_biomes");
    public static final ResourceKey<WorldPreset> AMPLIFIED = WorldPresets.register("amplified");
    public static final ResourceKey<WorldPreset> SINGLE_BIOME_SURFACE = WorldPresets.register("single_biome_surface");
    public static final ResourceKey<WorldPreset> DEBUG = WorldPresets.register("debug_all_block_states");

    public static void bootstrap(BootstrapContext<WorldPreset> var0) {
        new a(var0).bootstrap();
    }

    private static ResourceKey<WorldPreset> register(String var0) {
        return ResourceKey.create(Registries.WORLD_PRESET, MinecraftKey.withDefaultNamespace(var0));
    }

    public static Optional<ResourceKey<WorldPreset>> fromSettings(WorldDimensions var02) {
        return var02.get(WorldDimension.OVERWORLD).flatMap(var0 -> {
            ChunkGenerator chunkGenerator = var0.generator();
            Objects.requireNonNull(chunkGenerator);
            ChunkGenerator var1 = chunkGenerator;
            int var2 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ChunkProviderFlat.class, ChunkProviderDebug.class, ChunkGeneratorAbstract.class}, (Object)var1, var2)) {
                case 0 -> {
                    ChunkProviderFlat var3 = (ChunkProviderFlat)var1;
                    yield Optional.of(FLAT);
                }
                case 1 -> {
                    ChunkProviderDebug var4 = (ChunkProviderDebug)var1;
                    yield Optional.of(DEBUG);
                }
                case 2 -> {
                    ChunkGeneratorAbstract var5 = (ChunkGeneratorAbstract)var1;
                    yield Optional.of(NORMAL);
                }
                default -> Optional.empty();
            };
        });
    }

    public static WorldDimensions createNormalWorldDimensions(IRegistryCustom var0) {
        return var0.registryOrThrow(Registries.WORLD_PRESET).getHolderOrThrow(NORMAL).value().createWorldDimensions();
    }

    public static WorldDimension getNormalOverworld(IRegistryCustom var0) {
        return var0.registryOrThrow(Registries.WORLD_PRESET).getHolderOrThrow(NORMAL).value().overworld().orElseThrow();
    }

    static class a {
        private final BootstrapContext<WorldPreset> context;
        private final HolderGetter<GeneratorSettingBase> noiseSettings;
        private final HolderGetter<BiomeBase> biomes;
        private final HolderGetter<PlacedFeature> placedFeatures;
        private final HolderGetter<StructureSet> structureSets;
        private final HolderGetter<MultiNoiseBiomeSourceParameterList> multiNoiseBiomeSourceParameterLists;
        private final Holder<DimensionManager> overworldDimensionType;
        private final WorldDimension netherStem;
        private final WorldDimension endStem;

        a(BootstrapContext<WorldPreset> var0) {
            this.context = var0;
            HolderGetter<DimensionManager> var1 = var0.lookup(Registries.DIMENSION_TYPE);
            this.noiseSettings = var0.lookup(Registries.NOISE_SETTINGS);
            this.biomes = var0.lookup(Registries.BIOME);
            this.placedFeatures = var0.lookup(Registries.PLACED_FEATURE);
            this.structureSets = var0.lookup(Registries.STRUCTURE_SET);
            this.multiNoiseBiomeSourceParameterLists = var0.lookup(Registries.MULTI_NOISE_BIOME_SOURCE_PARAMETER_LIST);
            this.overworldDimensionType = var1.getOrThrow(BuiltinDimensionTypes.OVERWORLD);
            Holder.c<DimensionManager> var2 = var1.getOrThrow(BuiltinDimensionTypes.NETHER);
            Holder.c<GeneratorSettingBase> var3 = this.noiseSettings.getOrThrow(GeneratorSettingBase.NETHER);
            Holder.c<MultiNoiseBiomeSourceParameterList> var4 = this.multiNoiseBiomeSourceParameterLists.getOrThrow(MultiNoiseBiomeSourceParameterLists.NETHER);
            this.netherStem = new WorldDimension(var2, new ChunkGeneratorAbstract((WorldChunkManager)WorldChunkManagerMultiNoise.createFromPreset(var4), var3));
            Holder.c<DimensionManager> var5 = var1.getOrThrow(BuiltinDimensionTypes.END);
            Holder.c<GeneratorSettingBase> var6 = this.noiseSettings.getOrThrow(GeneratorSettingBase.END);
            this.endStem = new WorldDimension(var5, new ChunkGeneratorAbstract((WorldChunkManager)WorldChunkManagerTheEnd.create(this.biomes), var6));
        }

        private WorldDimension makeOverworld(ChunkGenerator var0) {
            return new WorldDimension(this.overworldDimensionType, var0);
        }

        private WorldDimension makeNoiseBasedOverworld(WorldChunkManager var0, Holder<GeneratorSettingBase> var1) {
            return this.makeOverworld(new ChunkGeneratorAbstract(var0, var1));
        }

        private WorldPreset createPresetWithCustomOverworld(WorldDimension var0) {
            return new WorldPreset(Map.of(WorldDimension.OVERWORLD, var0, WorldDimension.NETHER, this.netherStem, WorldDimension.END, this.endStem));
        }

        private void registerCustomOverworldPreset(ResourceKey<WorldPreset> var0, WorldDimension var1) {
            this.context.register(var0, this.createPresetWithCustomOverworld(var1));
        }

        private void registerOverworlds(WorldChunkManager var0) {
            Holder.c<GeneratorSettingBase> var1 = this.noiseSettings.getOrThrow(GeneratorSettingBase.OVERWORLD);
            this.registerCustomOverworldPreset(NORMAL, this.makeNoiseBasedOverworld(var0, var1));
            Holder.c<GeneratorSettingBase> var2 = this.noiseSettings.getOrThrow(GeneratorSettingBase.LARGE_BIOMES);
            this.registerCustomOverworldPreset(LARGE_BIOMES, this.makeNoiseBasedOverworld(var0, var2));
            Holder.c<GeneratorSettingBase> var3 = this.noiseSettings.getOrThrow(GeneratorSettingBase.AMPLIFIED);
            this.registerCustomOverworldPreset(AMPLIFIED, this.makeNoiseBasedOverworld(var0, var3));
        }

        public void bootstrap() {
            Holder.c<MultiNoiseBiomeSourceParameterList> var0 = this.multiNoiseBiomeSourceParameterLists.getOrThrow(MultiNoiseBiomeSourceParameterLists.OVERWORLD);
            this.registerOverworlds(WorldChunkManagerMultiNoise.createFromPreset(var0));
            Holder.c<GeneratorSettingBase> var1 = this.noiseSettings.getOrThrow(GeneratorSettingBase.OVERWORLD);
            Holder.c<BiomeBase> var2 = this.biomes.getOrThrow(Biomes.PLAINS);
            this.registerCustomOverworldPreset(SINGLE_BIOME_SURFACE, this.makeNoiseBasedOverworld(new WorldChunkManagerHell(var2), var1));
            this.registerCustomOverworldPreset(FLAT, this.makeOverworld(new ChunkProviderFlat(GeneratorSettingsFlat.getDefault(this.biomes, this.structureSets, this.placedFeatures))));
            this.registerCustomOverworldPreset(DEBUG, this.makeOverworld(new ChunkProviderDebug(var2)));
        }
    }
}

